/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.login;

import com.sap.core.jpaas.security.auth.api.AuthenticationService;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class LoginContextFactory {
    private static AuthenticationService authService = null;

    public static LoginContext createLoginContext() throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext();
    }

    public static LoginContext createLoginContext(String authenticationStack) throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext(authenticationStack);
    }

    public static LoginContext createLoginContext(String authenticationStack, CallbackHandler callbackHandler) throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext(authenticationStack, callbackHandler);
    }

    public static LoginContext createLoginContext(String authenticationStack, Subject subject) throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext(authenticationStack, subject);
    }

    public static LoginContext createLoginContext(String authenticationStack, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext(authenticationStack, subject, callbackHandler);
    }

    public static LoginContext createLoginContext(String authenticationStack, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        return LoginContextFactory.getAuthenticationService().createLoginContext(authenticationStack, subject, callbackHandler, configuration);
    }

    public static Configuration getConfiguration() throws LoginException {
        return LoginContextFactory.getAuthenticationService().getConfiguration();
    }

    private static AuthenticationService getAuthenticationService() throws LoginException {
        if (authService != null) {
            return authService;
        }
        throw new LoginException("AuthenticationService is not initialized!");
    }
}

