/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationFilter
implements Filter {
    private static Iterator<Filter> factory;
    private Filter filterImpl;
    private FilterConfig config;
    private static final Logger logger;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.debug("Entering doFilter");
        if (this.filterImpl != null) {
            this.filterImpl.doFilter(request, response, chain);
            return;
        }
        if (factory == null) {
            logger.error("Factory is null. Cannot initialize filter");
            throw new ServletException("Can not initialize OAuthAuthorizationFilter");
        }
        this.filterImpl = factory.next();
        if (this.filterImpl == null) {
            logger.error("FilterImpl is null. Cannot initialize filter");
            throw new ServletException("Can not initialize OAuthAuthorizationFilter");
        }
        this.filterImpl.init(this.config);
        this.filterImpl.doFilter(request, response, chain);
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
    }

    static {
        logger = LoggerFactory.getLogger(OAuthAuthorizationFilter.class);
    }
}

