/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api;

public class RepositoryOptions {
    private String uniqueName;
    private String displayName;
    private String description;
    private Visibility visibility;
    private String repositoryKey;
    private Boolean multiTenantCapable = true;
    private boolean virusScannerEnabled = false;

    public void setUniqueName(String uniqueName) {
        if (uniqueName != null && !uniqueName.trim().isEmpty()) {
            this.uniqueName = uniqueName;
        }
    }

    public void setDisplayName(String displayName) {
        if (displayName != null && !displayName.trim().isEmpty()) {
            this.displayName = displayName;
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setRepositoryKey(String repositoryKey) {
        this.repositoryKey = repositoryKey;
    }

    public void setMultiTenantCapable(boolean multiTenantCapable) {
        this.multiTenantCapable = multiTenantCapable;
    }

    public void setVirusScannerEnabled(boolean virusScannerEnabled) {
        this.virusScannerEnabled = virusScannerEnabled;
    }

    public String validate() {
        if (this.getUniqueName() == null) {
            return "Parameter uniqueName must not be null.";
        }
        if (this.getVisibility() == null) {
            return "Parameter visibility must not be null.";
        }
        if (this.getVisibility() == Visibility.PROTECTED && this.getRepositoryKey() == null) {
            return "Parameter repositoryKey must not be null when using Visibility.PROTECTED.";
        }
        if (this.isMultiTenantCapable() == null) {
            return "Parameter multiTenantCapable must be defined.";
        }
        return null;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String getRepositoryKey() {
        return this.repositoryKey;
    }

    public Boolean isMultiTenantCapable() {
        return this.multiTenantCapable;
    }

    public boolean isVirusScannerEnabled() {
        return this.virusScannerEnabled;
    }

    public static enum Visibility {
        PRIVATE,
        PROTECTED,
        CERTPROTECTED,
        PUBLIC;

    }
}

