/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.impl.JSONParser;
import com.sap.core.deploy.commons.util.VmArgumentsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ComponentAttributesResult
extends Result {
    private static final Logger LOGGER = Logger.getLogger(ComponentAttributesResult.class);
    private final JsonObject jsonResponse;
    private String runtimeId;
    private String runtimeVersion;
    private Boolean isVersionPinned;
    private String[] jpaasServices;
    private Integer minVmCount;
    private Integer maxVmCount;
    private List<String> vmArgs;
    private String javaVersion;
    private String compressionEnabled;
    private String compressionMimeType;
    private String compressionMinSize;
    private String vmSize;
    private String uriEncoding;
    private String maxThreads;
    private String connectionTimeout;
    private List<String> environmentVariables;

    public ComponentAttributesResult(int code, String message) {
        super(code, message);
        this.jsonResponse = null;
    }

    public ComponentAttributesResult(int resultError, String message, String stackTrace) {
        super(resultError, message, stackTrace);
        this.jsonResponse = null;
    }

    public ComponentAttributesResult(int code, JsonObject jsonResponse) throws JsonParseException, SAXException {
        super(code, Status.UNKNOWN);
        JsonArray jpaasServicesArray;
        JsonElement jpaasServicesObject;
        this.jsonResponse = jsonResponse;
        JsonObject attributes = jsonResponse.getAsJsonObject("attributes");
        this.runtimeId = JSONParser.getStringValue(attributes, "runtimeId");
        this.runtimeVersion = JSONParser.getStringValue(attributes, "runtimeVersion");
        this.isVersionPinned = JSONParser.getBooleanValue(attributes, "isVersionPinned");
        if (!this.isVersionPinned.booleanValue() && this.runtimeVersion != null && this.runtimeVersion.indexOf(46) > 0) {
            this.runtimeVersion = this.runtimeVersion.substring(0, this.runtimeVersion.indexOf(46));
        }
        this.vmSize = JSONParser.getStringValue(attributes, "vmSize");
        String jpaasServicesString = JSONParser.getStringValue(attributes, "jpaas_services");
        if (jpaasServicesString != null && !"".equals(jpaasServicesString) && (jpaasServicesObject = JSONParser.parseStringToJson(jpaasServicesString)).isJsonArray() && (jpaasServicesArray = jpaasServicesObject.getAsJsonArray()) != null) {
            this.jpaasServices = new String[jpaasServicesArray.size()];
            int i = 0;
            for (JsonElement jpaasService : jpaasServicesArray) {
                this.jpaasServices[i++] = jpaasService.getAsString();
            }
        }
        String elasticityString = JSONParser.getStringValue(attributes, "elasticity.data");
        this.logInfo("Elasticity string for parsing from deployment descriptor is: [%s]", elasticityString);
        JsonObject elasticityData = null;
        if (elasticityString != null && !"".equals(elasticityString)) {
            elasticityData = JSONParser.parseJsonResponse(elasticityString);
        }
        if (elasticityData != null) {
            this.minVmCount = JSONParser.getIntegerValue(elasticityData, "minVmCount");
            this.maxVmCount = JSONParser.getIntegerValue(elasticityData, "maxVmCount");
            this.logInfo("Parsed elasticity parameters - minVmCount: %d, maxVmCount: %d", this.minVmCount, this.maxVmCount);
        }
        JsonObject cloudControllerData = jsonResponse.getAsJsonObject("cData");
        this.javaVersion = JSONParser.getStringValue(cloudControllerData, "sapjvm_version");
        JsonObject ngp = cloudControllerData.getAsJsonObject("ngp");
        JsonObject cfg = ngp.getAsJsonObject("ljs").getAsJsonObject("cfg");
        JsonObject jvmCfg = cfg.getAsJsonObject("jvm");
        VmArgumentsUtil vmArgumentsUtil = new VmArgumentsUtil();
        this.vmArgs = new ArrayList<String>();
        this.addVmArgument(vmArgumentsUtil.getVmArgRawValue("MaxPermSize", JSONParser.getStringValue(jvmCfg, "MaxPermSize")));
        this.addVmArgument(vmArgumentsUtil.getVmArgRawValue("Xmx", JSONParser.getStringValue(jvmCfg, "Xmx")));
        this.addVmArgument(vmArgumentsUtil.getVmArgRawValue("PermSize", JSONParser.getStringValue(jvmCfg, "PermSize")));
        this.addVmArgument(vmArgumentsUtil.getVmArgRawValue("Xms", JSONParser.getStringValue(jvmCfg, "Xms")));
        this.vmArgs.addAll(vmArgumentsUtil.getAdditionalVmArgValues(JSONParser.getStringValue(jvmCfg, "additional")));
        JsonObject gzipCompressionProperties = cfg.getAsJsonObject("gzip");
        this.compressionEnabled = JSONParser.getStringValue(gzipCompressionProperties, "compression");
        this.compressionMimeType = JSONParser.getStringValue(gzipCompressionProperties, "compressable_mime_type");
        this.compressionMinSize = JSONParser.getStringValue(gzipCompressionProperties, "compression_min_size");
        this.environmentVariables = this.getEnvironmentVariablesFromJson(ngp);
        this.uriEncoding = JSONParser.getStringValue(cfg, "uriEncoding");
        this.maxThreads = JSONParser.getStringValue(cfg, "max_threads");
        this.connectionTimeout = JSONParser.getStringValue(cfg, "connection_timeout");
    }

    private void addVmArgument(String vmArgument) {
        if (vmArgument != null && !vmArgument.isEmpty()) {
            this.vmArgs.add(vmArgument);
        }
    }

    private List<String> getEnvironmentVariablesFromJson(JsonObject ngp) {
        ArrayList<String> environmentVariablesList = null;
        if (ngp.getAsJsonObject("env_variables") != null) {
            environmentVariablesList = new ArrayList<String>();
            JsonObject environmentVariablesJsonObject = ngp.getAsJsonObject("env_variables");
            Set entrySet = environmentVariablesJsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                environmentVariablesList.add(String.valueOf((String)entry.getKey()) + "=" + ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return environmentVariablesList;
    }

    private void logInfo(String template, Object ... args) {
        String message = String.format(template, args);
        LOGGER.info((Object)message);
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public void setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String[] getJpaasServices() {
        return this.jpaasServices;
    }

    public void setJpaasServices(String[] jpaasServices) {
        this.jpaasServices = jpaasServices;
    }

    public Integer getMinVmCount() {
        return this.minVmCount;
    }

    public void setMinVmCount(Integer minVmCount) {
        this.minVmCount = minVmCount;
    }

    public Integer getMaxVmCount() {
        return this.maxVmCount;
    }

    public void setMaxVmCount(Integer maxVmCount) {
        this.maxVmCount = maxVmCount;
    }

    public List<String> getVmArgs() {
        return this.vmArgs;
    }

    public void setVmArgs(List<String> vmArgs) {
        this.vmArgs = vmArgs;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public String getCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(String compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public String getCompressionMimeType() {
        return this.compressionMimeType;
    }

    public void setCompressionMimeType(String compressionMimeType) {
        this.compressionMimeType = compressionMimeType;
    }

    public String getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(String compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public void setVmSize(String vmSize) {
        this.vmSize = vmSize;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public String getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(String maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public JsonObject getOriginalJsonResponse() {
        return this.jsonResponse;
    }

    public Boolean isVersionPinned() {
        return this.isVersionPinned;
    }

    public void setVersionPinned(Boolean isVersionPinned) {
        this.isVersionPinned = isVersionPinned;
    }

    public List<String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(List<String> enviormentVariables) {
        this.environmentVariables = new ArrayList<String>(enviormentVariables);
    }
}

