/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client;

import com.sap.core.deploy.client.DeployFeedbackListener;
import com.sap.core.deploy.client.IComponentUrlManager;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.impl.ComponentUrlManagerImpl;
import com.sap.core.deploy.client.impl.ConfigurationManagerImpl;
import com.sap.core.deploy.client.impl.DeployerImpl;
import org.apache.http.client.HttpClient;

public abstract class DeployClient {
    public static final String LOG_SEVERITY_KEY = "logSeverity";

    public static IDeployer getDeployInterface(String accountName) {
        return new DeployerImpl(accountName);
    }

    public static IDeployer getDeployInterface(HttpClient httpClient) {
        return new DeployerImpl(httpClient);
    }

    public static IDeployer getDeployInterface(String accountName, HttpClient httpClient) {
        return new DeployerImpl(accountName, httpClient);
    }

    public static IDeployer getDeployInterface(String accountName, HttpClient httpClient, DeployFeedbackListener feedbackListener) {
        return new DeployerImpl(accountName, httpClient, feedbackListener);
    }

    public static IDeployer getDeployInterface(String accountName, HttpClient httpClient, DeployFeedbackListener feedbackListener, String agentName, String agentVersion) {
        return new DeployerImpl(accountName, httpClient, feedbackListener, agentName, agentVersion);
    }

    public static IComponentUrlManager getComponentUrlManager() {
        return new ComponentUrlManagerImpl();
    }

    public static IComponentUrlManager getComponentUrlManager(HttpClient httpClient) {
        return new ComponentUrlManagerImpl(httpClient);
    }

    public static IConfigurationManager getConfigurationManager(HttpClient httpClient, String accountName, String agentName, String agentVersion) {
        return new ConfigurationManagerImpl(httpClient, accountName, agentName, agentVersion);
    }

    public static IConfigurationManager getConfigurationManager(HttpClient httpClient, String accountName) {
        return new ConfigurationManagerImpl(httpClient, accountName);
    }

    public static IConfigurationManager getConfigurationManager(HttpClient httpClient) {
        return new ConfigurationManagerImpl(httpClient);
    }
}

