/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client;

import com.sap.core.deploy.client.Status;

public abstract class Result {
    public static final int RESULT_OK = 0;
    public static final int RESULT_ERROR = 1;
    public static final int RESULT_INVALID_PARAMS = 2;
    public static final int RESULT_SERVER_ERROR = 3;
    public static final int RESULT_START_ERROR = 4;
    public static final int RESULT_STOP_ERROR = 5;
    public static final int RESULT_PARALLEL_OPERATION_ERROR = 6;
    protected final int code;
    protected final String message;
    protected final String stackTrace;
    protected final Status status;
    protected Throwable throwable;

    public Result(int code, Status status, String message, String stackTrace) {
        this.code = code;
        this.status = status;
        this.message = message == null && this.status != null ? status.toString() : message;
        this.stackTrace = stackTrace;
    }

    public Result(int code, String message, String stackTrace) {
        this(code, Status.UNKNOWN, message, stackTrace);
    }

    public Result(int code, String message) {
        this(code, Status.UNKNOWN, message, null);
    }

    public Result(int code, Status status) {
        this(code, status, null, null);
    }

    public Result(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append(element.toString());
            sb.append("\n");
            ++n2;
        }
        this.code = 1;
        this.message = t.getMessage();
        this.status = Status.UNKNOWN;
        this.stackTrace = sb.toString();
        this.throwable = t;
    }

    public Result(Result result) {
        this(result.getCode(), result.getStatus(), result.getMessage(), result.getStackTrace());
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Status getStatus() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "code=[" + this.code + "], " + ", status=[" + (Object)((Object)this.status) + "]" + ", message=[" + this.message + "]";
    }
}

