/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client;

import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.status.LBStatus;
import java.util.Arrays;
import java.util.Map;

public class StatusResult
extends Result {
    public static final int RESULT_NOT_FOUND = 4;
    public static final int RESULT_FORBIDDEN = 5;
    private final String url;
    private LBStatus lbStatus;
    private String maintenanceApplication;
    private String downtimeApplication;
    private final String[] urls;
    private final String[] aliases;
    private ApplicationProcessResource[] applicationProcesses;
    private Map<String, String> deployRuntime;

    public StatusResult(int code, Status state, String message, String stackTrace, String url, String[] urls, String[] aliases) {
        super(code, state, message, stackTrace);
        this.url = url;
        this.urls = urls;
        this.aliases = aliases;
    }

    public StatusResult(int code, Status state, String message, String stackTrace, String url, String[] urls, String[] aliases, Map<String, String> runtimeMetaData) {
        this(code, state, message, stackTrace, url, urls, aliases);
        this.deployRuntime = runtimeMetaData;
    }

    public StatusResult(int code, String message) {
        super(code, message);
        this.url = null;
        this.urls = null;
        this.aliases = null;
    }

    public StatusResult(int code, Status state, String message) {
        super(code, state, message, null);
        this.url = null;
        this.urls = null;
        this.aliases = null;
    }

    public StatusResult(int code, String message, String stackTrace) {
        super(code, message, stackTrace);
        this.url = null;
        this.urls = null;
        this.aliases = null;
    }

    public StatusResult(Throwable t) {
        super(t);
        this.url = null;
        this.urls = null;
        this.aliases = null;
    }

    public String getUrl() {
        return this.url;
    }

    public String[] getUrls() {
        return this.urls != null ? Arrays.copyOf(this.urls, this.urls.length) : null;
    }

    public String[] getAliases() {
        return this.aliases != null ? Arrays.copyOf(this.aliases, this.aliases.length) : null;
    }

    public void setApplicationProcesses(ApplicationProcessResource[] applicationProcesses) {
        this.applicationProcesses = applicationProcesses;
    }

    public ApplicationProcessResource[] getApplicationProcesses() {
        return this.applicationProcesses;
    }

    @Override
    public String toString() {
        return String.format("StatusResult [code=%d, status=%s, lbStatus=%s, message=%s, url=%s, urls=%s, aliases=%s, applicationProcesses=%s, maintenanceApplication=%s, downtimeApplication=%s]", new Object[]{this.code, this.status, this.lbStatus, this.message, this.url, Arrays.toString(this.urls), Arrays.toString(this.aliases), Arrays.toString(this.applicationProcesses), this.maintenanceApplication, this.downtimeApplication});
    }

    public LBStatus getLBStatus() {
        return this.lbStatus;
    }

    public void setLBStatus(LBStatus lbStatus) {
        this.lbStatus = lbStatus;
    }

    public String getMaintenanceApplication() {
        return this.maintenanceApplication;
    }

    public void setMaintenanceApplication(String maintenanceApplication) {
        this.maintenanceApplication = maintenanceApplication;
    }

    public String getDowntimeApplication() {
        return this.downtimeApplication;
    }

    public void setDowntimeApplication(String downtimeApplication) {
        this.downtimeApplication = downtimeApplication;
    }

    public Map<String, String> getDeployRuntime() {
        return this.deployRuntime;
    }

    public void setDeployRuntime(Map<String, String> deployRuntime) {
        this.deployRuntime = deployRuntime;
    }
}

