/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client;

public class TimeAndSizeUtils {
    public static String getTimeString(long millis) {
        long totalTimeSeconds = millis / 1000L;
        long ms = millis % 1000L;
        long tenthSeconds = ms / 100L;
        String totalTimeString = totalTimeSeconds < 60L ? String.valueOf(totalTimeSeconds) + "." + tenthSeconds + " s" : String.valueOf(totalTimeSeconds / 60L) + " m " + totalTimeSeconds % 60L + " s";
        return totalTimeString;
    }

    public static String getSizeAsString(long sizeInBytes) {
        long afterDecimalPoint = 0L;
        long bytes = sizeInBytes % 1000L;
        long kb = sizeInBytes / 1000L;
        long mb = 0L;
        long gb = 0L;
        if (kb > 1000L) {
            mb = kb / 1000L;
            kb %= 1000L;
        } else {
            afterDecimalPoint = bytes / 100L;
        }
        if (mb > 1000L) {
            gb = mb / 1000L;
            afterDecimalPoint = mb % 1000L;
        } else if (mb > 0L) {
            afterDecimalPoint = kb / 10L;
        }
        String result = gb > 0L ? String.valueOf(gb) + "." + afterDecimalPoint + " GB" : (mb > 0L ? String.valueOf(mb) + "." + afterDecimalPoint + " MB" : (kb > 0L ? String.valueOf(kb) + "." + afterDecimalPoint + " KB" : String.valueOf(bytes) + " B"));
        return result;
    }

    public static String getTransferSpeedAsString(long transferredBytes, long totalTimeInMillis) {
        long speed;
        if (totalTimeInMillis == 0L) {
            ++totalTimeInMillis;
        }
        if ((speed = transferredBytes / totalTimeInMillis) == 0L) {
            speed = 1L;
        }
        return String.valueOf(speed) + " KB/s";
    }
}

