/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.connection.utils;

import com.sap.core.deploy.client.connection.utils.SingleConnectionThread;
import com.sap.core.deploy.commons.protocol.Chunk;
import com.sap.core.deploy.commons.util.IOUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class Multiplexer {
    private static final Logger LOGGER = Logger.getLogger(Multiplexer.class);
    private static int CHUNK_SIZE = 8192;
    private static int BUFFER_CAPACITY = 256;
    private final HttpClient httpClient;
    private final String baseUrl;
    private final InputStream is;
    private final byte connectionsCount;
    private final String deployOperationId;
    private int packetsCounter = 0;
    private final ArrayBlockingQueue<Chunk> buffer = new ArrayBlockingQueue(BUFFER_CAPACITY);
    private Status status = Status.IN_PROGRESS;
    private final Object STATUS_SYNCHRONIZER = new Object();

    public Multiplexer(HttpClient httpClient, String baseUrl, InputStream is, byte connectionsCount, String deployOperationId) {
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
        this.is = is;
        this.connectionsCount = connectionsCount;
        this.deployOperationId = deployOperationId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Base URL for deployment requests: " + baseUrl));
            LOGGER.debug((Object)("Operation ID: " + deployOperationId));
        }
        LOGGER.info((Object)("Final count of parallel connections for deploy executions: " + connectionsCount));
    }

    synchronized Chunk requestChunk() throws InterruptedException {
        if (this.allowedToReadFromBuffer()) {
            return this.buffer.take();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allowedToReadFromBuffer() {
        Object object = this.STATUS_SYNCHRONIZER;
        synchronized (object) {
            return this.status == Status.IN_PROGRESS || this.status == Status.FINISHED_FEEDREAD && this.buffer.size() > 0;
        }
    }

    public void start() {
        FeedThread feedThread = new FeedThread();
        feedThread.start();
        byte connectionId = 0;
        while (connectionId < this.connectionsCount) {
            SingleConnectionThread connectionThread = new SingleConnectionThread(this, this.httpClient, this.baseUrl, this.deployOperationId, connectionId);
            connectionThread.start();
            connectionId = (byte)(connectionId + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure() {
        Object object = this.STATUS_SYNCHRONIZER;
        synchronized (object) {
            this.status = Status.FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFinishedFeed(Chunk lastChunk) throws InterruptedException {
        this.buffer.put(lastChunk);
        Object object = this.STATUS_SYNCHRONIZER;
        synchronized (object) {
            this.status = Status.FINISHED_FEEDREAD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inProgress() {
        Object object = this.STATUS_SYNCHRONIZER;
        synchronized (object) {
            return this.status == Status.IN_PROGRESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed() {
        Object object = this.STATUS_SYNCHRONIZER;
        synchronized (object) {
            return this.status == Status.FAILED;
        }
    }

    class FeedThread
    extends Thread {
        FeedThread() {
        }

        @Override
        public void run() {
            try {
                LOGGER.info((Object)"Starting feeding thread for reading the deployment content...");
                while (Multiplexer.this.inProgress()) {
                    int readBytes;
                    byte[] chunkData = new byte[CHUNK_SIZE];
                    int offset = 0;
                    for (int bytesLeftToRead = CHUNK_SIZE; bytesLeftToRead > 0; bytesLeftToRead -= readBytes) {
                        readBytes = Multiplexer.this.is.read(chunkData, offset, bytesLeftToRead);
                        if (readBytes != -1) {
                            offset += readBytes;
                            continue;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("[Feed Thread] Writing chunk number " + Multiplexer.this.packetsCounter + " into internal buffer, size " + offset + " bytes"));
                        }
                        Multiplexer multiplexer = Multiplexer.this;
                        int n = multiplexer.packetsCounter;
                        multiplexer.packetsCounter = n + 1;
                        Multiplexer.this.notifyFinishedFeed(new Chunk(chunkData, offset, n));
                        IOUtils.closeQuietly((Closeable)Multiplexer.this.is);
                        return;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[Feed Thread] Writing chunk number " + Multiplexer.this.packetsCounter + " into internal buffer, size " + offset + " bytes"));
                    }
                    ArrayBlockingQueue arrayBlockingQueue = Multiplexer.this.buffer;
                    Multiplexer multiplexer = Multiplexer.this;
                    int n = multiplexer.packetsCounter;
                    multiplexer.packetsCounter = n + 1;
                    arrayBlockingQueue.put(new Chunk(chunkData, offset, n));
                }
                LOGGER.info((Object)"The whole deployment content was sent to the internal buffer");
            }
            catch (Exception e) {
                Multiplexer.this.notifyFailure();
                LOGGER.error((Object)("Exception on reading from stream and feeding the internal buffer.\nException message is: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    static enum Status {
        IN_PROGRESS,
        FINISHED_FEEDREAD,
        FAILED;

    }
}

