/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.connection.utils;

import com.sap.core.deploy.client.connection.utils.Multiplexer;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.commons.protocol.Chunk;
import com.sap.core.deploy.commons.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.log4j.Logger;

public class SingleConnectionThread
extends Thread {
    private static final String SOCKET_TIMEOUT_KEY = "http.socket.timeout";
    private static final String PROTOCOL_VERSION_KEY = "http.protocol.version";
    private static final Logger LOGGER = Logger.getLogger(SingleConnectionThread.class);
    private final Multiplexer callback;
    private final HttpClient httpClient;
    private final String baseUrl;
    private String deployOperationId;
    private final byte connectionId;
    private boolean mustStop = false;

    SingleConnectionThread(Multiplexer callback, HttpClient httpClient, String baseUrl, String deployOperationId, byte connectionId) {
        this.callback = callback;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
        this.deployOperationId = deployOperationId;
        this.connectionId = connectionId;
    }

    @Override
    public void run() {
        try {
            LOGGER.info((Object)("Starting connection thread " + this.connectionId + " for deploy operation with id " + this.deployOperationId));
            PipedInputStream pis = new PipedInputStream(32768);
            final PipedOutputStream pos = new PipedOutputStream();
            pis.connect(pos);
            new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Starting internal connection thread " + SingleConnectionThread.this.connectionId));
                            }
                            while (!SingleConnectionThread.this.mustStop) {
                                DeployTimeoutUtil.cancelIfDeployTimeoutReached();
                                Chunk chunk = SingleConnectionThread.this.callback.requestChunk();
                                if (chunk == null) break;
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)("[Connection " + SingleConnectionThread.this.connectionId + "] Writing chunk number " + chunk.getPackageNumber() + " size " + chunk.getSize() + " bytes"));
                                }
                                SingleConnectionThread.this.writeInt(pos, chunk.getPackageNumber());
                                SingleConnectionThread.this.writeInt(pos, chunk.getSize());
                                pos.write(chunk.getData(), 0, chunk.getSize());
                                pos.flush();
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug((Object)("[Connection " + SingleConnectionThread.this.connectionId + "] Wrote chunk number " + chunk.getPackageNumber() + " into stream"));
                            }
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Stopping internal connection thread " + SingleConnectionThread.this.connectionId));
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error((Object)("Upload through connection thread " + SingleConnectionThread.this.connectionId + " encountered an error"), t);
                            SingleConnectionThread.this.callback.notifyFailure();
                            IOUtils.closeQuietly((Closeable)pos);
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)pos);
                    }
                }
            }.start();
            HttpPut putRequest = new HttpPut(this.baseUrl);
            putRequest.setHeader("X-OperationID", this.deployOperationId);
            putRequest.setHeader("X-ConnectionID", String.valueOf(this.connectionId));
            putRequest.getParams().setParameter(PROTOCOL_VERSION_KEY, (Object)HttpVersion.HTTP_1_1);
            putRequest.getParams().setParameter(SOCKET_TIMEOUT_KEY, (Object)600000);
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContentType("application/octet-stream");
            entity.setContent((InputStream)pis);
            putRequest.setEntity((HttpEntity)entity);
            NetworkUtils.consumeEntity(NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)putRequest, "2.0"));
            LOGGER.info((Object)("Stopping connection " + this.connectionId));
        }
        catch (Throwable t) {
            LOGGER.error((Object)("Upload through connection thread " + this.connectionId + " encountered an error"), t);
            this.callback.notifyFailure();
            this.mustStop = true;
        }
    }

    private void writeInt(OutputStream out, int value) throws IOException {
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }
}

