/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.IComponentUrlManager;
import com.sap.core.deploy.client.impl.DeployerImpl;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.client.utils.HttpClientFactory;
import com.sap.core.deploy.client.utils.LogonUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class ComponentUrlManagerImpl
implements IComponentUrlManager {
    private static final String URL = "url";
    private static final String SET_URL_OPERATION_NAME = "set_short_url";
    private HttpContext httpContext = new BasicHttpContext();
    private Logger logger = Logger.getLogger((String)DeployerImpl.class.getName());
    private HttpClient httpClient;

    public ComponentUrlManagerImpl() {
        this.httpContext.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
    }

    public ComponentUrlManagerImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public DeployResult setComponentUrl(String jpSpaceName, String jpApplianceName, String jpApplianceComponentName, String argUrl, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        host = DeployClientUtils.prepareAndValidateHostString(host);
        LogonUtils.createLoginRequest(httpClient, this.httpContext, host, "");
        return this.doSetComponentUrl(jpSpaceName, jpApplianceName, jpApplianceComponentName, argUrl, host, httpClient, "spaces");
    }

    private DeployResult doSetComponentUrl(String jpSpaceName, String jpApplianceName, String jpApplianceComponentName, String argUrl, String host, HttpClient httpClient, String applicationAlias) throws IOException, ClientProtocolException {
        if (jpApplianceName == null || "".equals(jpApplianceName)) {
            return new DeployResult(1, "Please specify appliance argument.", null);
        }
        if (jpApplianceComponentName == null || "".equals(jpApplianceComponentName)) {
            return new DeployResult(1, "Please specify component argument.", null);
        }
        if (argUrl == null || "".equals(argUrl)) {
            return new DeployResult(1, "Please specify short URL argument.", null);
        }
        if (host == null || "".equals(host)) {
            return new DeployResult(1, "Please specify host argument.", null);
        }
        String requestUrl = String.valueOf(host) + "/" + applicationAlias + "/" + jpSpaceName + "/" + "appliances" + "/" + jpApplianceName + "/" + "components" + "/" + jpApplianceComponentName + "/" + URL + "/" + argUrl;
        HttpPost httpRequest = new HttpPost(requestUrl);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Requesting short URL update for: " + jpApplianceComponentName + " on space " + jpSpaceName + " and appliance " + jpApplianceName + " with short URL value: " + argUrl));
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest, this.httpContext);
        return ResultBuilder.buildDeployResult(response, SET_URL_OPERATION_NAME, httpRequest.getRequestLine().toString());
    }

    @Override
    public DeployResult setComponentUrl(String jpSpaceName, String jpApplianceName, String jpApplianceComponentName, String argUrl, String hostURL) throws Exception {
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        return this.doSetComponentUrl(jpSpaceName, jpApplianceName, jpApplianceComponentName, argUrl, hostURL, this.httpClient, "deploy");
    }
}

