/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.exceptions.DeployClientException;
import com.sap.core.deploy.client.publicrest.impl.PatchApplicationClient;
import com.sap.core.deploy.client.publicrest.impl.ReadApplicationClient;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.enumerations.VmSize;
import com.sap.core.deploy.commons.rest.entity.request.ApplicationRequest;
import com.sap.core.deploy.commons.runtime.RuntimeVersions;
import com.sap.core.deploy.commons.runtime.Version;
import com.sap.core.deploy.commons.util.ArrayOfRuntimeVersionsDeserializer;
import com.sap.core.deploy.commons.util.LandscapeUtils;
import com.sap.core.deploy.commons.util.RuntimeVersionsComparator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class ConfigurationManagerImpl
implements IConfigurationManager {
    private static final String ERROR_UPDATING_APPLICATION_CONFIGURATION = "Error encountered while updating application configuration";
    private static final String ERROR_QUERYING_FOR_APPLICATION_CONFIGURATION = "Error encountered while querying for application configuration";
    private static final Logger LOGGER = Logger.getLogger(ConfigurationManagerImpl.class);
    private static final List<VmSize> VM_SIZES_LIST;
    private String account;
    private HttpClient httpClient;
    private String agentName;
    private String agentVersion;

    static {
        ArrayList modifiableList = new ArrayList();
        Collections.addAll(modifiableList, VmSize.values());
        VM_SIZES_LIST = Collections.unmodifiableList(modifiableList);
    }

    public ConfigurationManagerImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ConfigurationManagerImpl(HttpClient httpClient, String accountName) {
        this.httpClient = httpClient;
        this.account = accountName;
    }

    public ConfigurationManagerImpl(HttpClient httpClient, String accountName, String agentName, String agentVersion) {
        this.httpClient = httpClient;
        this.account = accountName;
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    @Override
    public List<VmSize> getVmSizes() throws DeployClientException {
        return VM_SIZES_LIST;
    }

    @Override
    public ComponentAttributesResult getConfiguration(String appliance, String component, String host) throws DeployClientException {
        if ((host = DeployClientUtils.prepareAndValidateHostString(host)) == null || "".equals(host)) {
            return new ComponentAttributesResult(1, "No host specified");
        }
        if (appliance == null || "".equals(appliance)) {
            return new ComponentAttributesResult(1, "No appliance specified");
        }
        if (component == null || "".equals(component)) {
            component = "web";
        }
        if (component.equals("web")) {
            return this.readApplicationPropertiesFromPublicREST(appliance, host);
        }
        return this.readApplicationPropertiesFromLegacyREST(appliance, component, host);
    }

    private ComponentAttributesResult readApplicationPropertiesFromPublicREST(String appliance, String host) {
        ReadApplicationClient readApplicationClient = new ReadApplicationClient(host, appliance, this.account, this.agentName, this.agentVersion);
        try {
            ComponentAttributesResult readApplication = readApplicationClient.readApplication(this.httpClient);
            return readApplication;
        }
        catch (Exception e) {
            throw new DeployClientException(ERROR_QUERYING_FOR_APPLICATION_CONFIGURATION, e);
        }
    }

    private ComponentAttributesResult readApplicationPropertiesFromLegacyREST(String appliance, String component, String host) {
        ComponentAttributesResult componentAttributesResult;
        String getApplianceRequest = String.valueOf(host) + "/" + "deploy" + "/" + this.account + "/" + "appliances" + "/" + appliance + "/" + "components" + "/" + component;
        HttpGet httpGet = this.createHttpGet(getApplianceRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Getting component descriptor of component [" + component + "] on appliance [" + appliance + "] on host [" + host + "]."));
        }
        HttpResponse response = null;
        try {
            response = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)httpGet, "1.0");
            componentAttributesResult = ResultBuilder.buildComponentAttributesResult(response);
        }
        catch (IOException e) {
            try {
                throw new DeployClientException(ERROR_QUERYING_FOR_APPLICATION_CONFIGURATION, e);
            }
            catch (Throwable throwable) {
                NetworkUtils.consumeEntity(response);
                throw throwable;
            }
        }
        NetworkUtils.consumeEntity(response);
        return componentAttributesResult;
    }

    @Override
    public ComponentAttributesResult setConfigurationProperty(String application, String host, ApplicationRequest applicationRequest) throws DeployClientException {
        PatchApplicationClient patchApplicationClient = new PatchApplicationClient(host, this.account, this.agentName, this.agentVersion);
        try {
            return patchApplicationClient.doPatch(this.account, application, applicationRequest, this.httpClient);
        }
        catch (Exception e) {
            throw new DeployClientException(ERROR_UPDATING_APPLICATION_CONFIGURATION, e);
        }
    }

    @Override
    public Collection<Version> listRuntimeVersions(String runtimeId, boolean listDeprecatedVersions, String host) throws DeployClientException {
        Collection<RuntimeVersions> runtimesAndVersions = this.listRuntimesAndVersions(runtimeId, listDeprecatedVersions, host);
        TreeSet<Version> versionResources = new TreeSet<Version>((Comparator<Version>)new RuntimeVersionsComparator());
        for (RuntimeVersions runtime : runtimesAndVersions) {
            versionResources.addAll(runtime.getVersionResources());
        }
        return versionResources;
    }

    @Override
    public Collection<RuntimeVersions> listRuntimesAndVersions(String runtimeId, boolean listDeprecatedVersions, String host) throws DeployClientException {
        int status;
        HttpResponse response;
        block21: {
            host = DeployClientUtils.prepareAndValidateHostString(host);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Getting appliances on host [" + host + "]."));
            }
            StringBuilder sb = new StringBuilder(host);
            sb.append("/").append("domain_basic").append("/").append("runtime");
            if (runtimeId != null) {
                sb.append("/").append(runtimeId);
            }
            if (listDeprecatedVersions) {
                sb.append("?").append("all");
            }
            String requestURI = sb.toString();
            response = this.getResponse(requestURI, this.account);
            status = this.retrieveStatusCode(response);
            this.checkForConnectivityError(response, status);
            if (status == 200) {
                InputStream is = null;
                try {
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.registerTypeAdapter(RuntimeVersions[].class, (Object)new ArrayOfRuntimeVersionsDeserializer());
                    Gson gson = gsonBuilder.create();
                    is = this.retrieveContent(response);
                    Object[] runtimeVersionResources = (RuntimeVersions[])gson.fromJson((Reader)new InputStreamReader(is, "UTF-8"), RuntimeVersions[].class);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Getting runtime versions on host [" + host + "]: \n" + Arrays.toString(runtimeVersionResources)));
                    }
                    List<RuntimeVersions> list = Arrays.asList(runtimeVersionResources);
                    return list;
                }
                catch (RuntimeException e) {
                    throw new DeployClientException("Unexpected response.", e);
                }
                catch (IOException ioEx) {
                    throw new DeployClientException("Unexpected response.", ioEx);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioEx) {
                            LOGGER.error((Object)ioEx);
                        }
                    }
                }
            }
            if (status != 404) break block21;
            throw new DeployClientException("Missing runtime " + runtimeId + ". Please contact the landscape opperators for available runtime IDs.");
        }
        if (LandscapeUtils.isInMaintenanceMode((HttpResponse)response)) {
            throw new DeployClientException("Deploying, starting and stopping applications is temporarily suspended. SAP Cloud Platform is in infrastructure maintenance.");
        }
        throw new DeployClientException("Failed to perform request. Server returned unexpected http response code " + status);
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    @Override
    public List<String> listRuntimeTypes(String host) throws DeployClientException {
        host = DeployClientUtils.prepareAndValidateHostString(host);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Getting appliances on host [" + host + "]."));
        }
        StringBuilder sb = new StringBuilder(host);
        sb.append("/").append("domain_basic").append("/").append("runtime_types");
        String getRuntimeTypesRequest = sb.toString();
        HttpResponse response = this.getResponse(getRuntimeTypesRequest, this.account);
        int status = this.retrieveStatusCode(response);
        try {
            this.checkForConnectivityError(response, status);
            if (status == 200) {
                InputStream is = null;
                try {
                    Gson gson = new Gson();
                    is = this.retrieveContent(response);
                    List runtimeTypes = (List)gson.fromJson((Reader)new InputStreamReader(is, "UTF-8"), new TypeToken<List<String>>(){}.getType());
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Getting runtime types on host [" + host + "]: \n" + runtimeTypes.toString()));
                    }
                    List list = runtimeTypes;
                    return list;
                }
                catch (RuntimeException e) {
                    throw new DeployClientException("Unexpected response.", e);
                }
                catch (IOException ioEx) {
                    throw new DeployClientException("Unexpected response.", ioEx);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioEx) {
                            LOGGER.error((Object)ioEx);
                        }
                    }
                }
            }
            if (status == 404) {
                throw new DeployClientException("Can't list runtime types on host [" + host + "]. Please contact the landscape opperators for available runtime IDs.");
            }
            throw new DeployClientException("Unexpected status " + status + ". Please contact the landscape opperators for details.");
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    private int retrieveStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private InputStream retrieveContent(HttpResponse response) throws IOException {
        return response.getEntity().getContent();
    }

    private void checkForConnectivityError(HttpResponse response, int status) {
        if (!ResultBuilder.isOrchestratorEndpoint(response)) {
            switch (status) {
                case 401: {
                    throw new DeployClientException("3 " + ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                }
                case 503: {
                    throw new DeployClientException("3 The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.");
                }
            }
            LOGGER.warn((Object)"Missing header [X-DomainController] in server response. The check will be skipped.");
            throw new DeployClientException("3 Unknown SAP Cloud Platform host was provided. Check whether the host is correctly spelled.");
        }
    }

    private HttpResponse getResponse(String getRuntimeTypesRequest, String account) {
        HttpGet httpGet = this.createHttpGet(getRuntimeTypesRequest);
        if (account != null && !account.trim().isEmpty()) {
            httpGet.setHeader("account", account);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Request: " + httpGet.getRequestLine().toString()));
        }
        HttpResponse response = this.retrieveResponse(httpGet);
        return response;
    }

    private HttpResponse retrieveResponse(HttpGet httpGet) {
        HttpResponse response = null;
        try {
            response = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)httpGet, "2.2");
        }
        catch (IOException e) {
            NetworkUtils.consumeEntity(response);
            throw new DeployClientException(e);
        }
        return response;
    }

    private HttpGet createHttpGet(String requestURI) {
        return new HttpGet(requestURI);
    }
}

