/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.DeployFeedbackListener;
import com.sap.core.deploy.client.TimeAndSizeUtils;
import org.apache.log4j.Logger;

public class DeployFeedbackHelper {
    private static final Logger LOGGER = Logger.getLogger(DeployFeedbackHelper.class);
    long startTime = System.currentTimeMillis();
    long processingStartTime = 0L;
    boolean processingStarted = false;
    DeployFeedbackListener feedbackListener = null;
    long totalSize = 0L;
    long bytesUploaded = 0L;
    double onePercentOfTotalSize = 1.0;
    int lastCalculatedPercents = 0;
    boolean finishInfoProcessed = false;
    boolean deployIsDeltaLevelTwo;

    public void setFeedbackListener(DeployFeedbackListener feedbackListener) {
        this.feedbackListener = feedbackListener;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        this.onePercentOfTotalSize = (double)totalSize / 100.0;
        this.bytesUploaded = 0L;
        this.finishInfoProcessed = false;
    }

    public void bytesUploaded(int readBytes) {
        if (this.bytesUploaded == 0L) {
            this.uploadStarted();
        }
        this.bytesUploaded += (long)readBytes;
        this.calculatePercents();
    }

    public void deployStarted(int i) {
        if (this.feedbackListener != null) {
            LOGGER.info((Object)"Deploy started");
            this.feedbackListener.deployStarted(i);
        }
    }

    public void deployFinished(boolean success) {
        if (this.processingStarted) {
            this.processingFinished();
        }
        if (this.feedbackListener != null) {
            LOGGER.info((Object)("Deploy finished. Success: " + success));
            this.feedbackListener.deployFinished(success, "");
        }
    }

    public void uploadStarted() {
        this.startTime = System.currentTimeMillis();
        if (this.feedbackListener != null) {
            LOGGER.info((Object)"Upload started");
            String uploadingStartedMsg = this.deployIsDeltaLevelTwo ? "Uploading and patching started..." : "Uploading started...";
            this.feedbackListener.suboperationStarted("Upload", uploadingStartedMsg);
        }
    }

    public void uploadFinished() {
        if (this.finishInfoProcessed || this.feedbackListener == null) {
            return;
        }
        this.finishInfoProcessed = true;
        if (this.lastCalculatedPercents < 100) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Upload finished without reaching 100%. Latest calculated percent: " + this.lastCalculatedPercents));
            }
            this.feedbackListener.suboperationProgressed("Upload", "", 100);
        }
        long totalTime = System.currentTimeMillis() - this.startTime;
        String uploadFinishedDetails = "Uploaded " + TimeAndSizeUtils.getSizeAsString(this.bytesUploaded) + " in " + TimeAndSizeUtils.getTimeString(totalTime) + (this.deployIsDeltaLevelTwo ? "." : " Speed: " + TimeAndSizeUtils.getTransferSpeedAsString(this.bytesUploaded, totalTime));
        LOGGER.info((Object)("Upload finished. Details: " + uploadFinishedDetails));
        this.feedbackListener.suboperationCompleted("Upload", uploadFinishedDetails);
        this.processingStarted();
    }

    public void processingStarted() {
        if (this.feedbackListener != null) {
            LOGGER.info((Object)"Processing started");
            this.feedbackListener.suboperationStarted("Processing", "Processing started...");
        }
        this.processingStarted = true;
        this.processingStartTime = System.currentTimeMillis();
    }

    public void processingFinished() {
        long totalProcessTime = System.currentTimeMillis() - this.processingStartTime;
        String totalProcessTimeString = TimeAndSizeUtils.getTimeString(totalProcessTime);
        if (this.feedbackListener != null) {
            String details = "Processing completed in " + totalProcessTimeString;
            LOGGER.info((Object)("Processing finished. Details: " + details));
            this.feedbackListener.suboperationCompleted("Processing", details);
        }
    }

    private void calculatePercents() {
        if (this.feedbackListener != null) {
            int percents = (int)Math.round((double)this.bytesUploaded / this.onePercentOfTotalSize);
            if (percents > 100) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Calculated percents over 100%! Latest calculated percents: " + percents));
                }
                percents = 100;
            }
            if (percents > this.lastCalculatedPercents) {
                this.lastCalculatedPercents = percents;
                LOGGER.info((Object)("Upload progressed. Percents: " + this.lastCalculatedPercents));
                this.feedbackListener.suboperationProgressed("Upload", "", this.lastCalculatedPercents);
            }
        }
    }

    public void setDeployIsDeltaLevelTwo(boolean deployIsDeltaLevelTwo) {
        this.deployIsDeltaLevelTwo = deployIsDeltaLevelTwo;
    }
}

