/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.google.gson.Gson;
import com.sap.core.deploy.client.DeployFeedbackListener;
import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.IRestartStrategy;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.connection.utils.Multiplexer;
import com.sap.core.deploy.client.exceptions.DeployClientException;
import com.sap.core.deploy.client.impl.DeployFeedbackHelper;
import com.sap.core.deploy.client.impl.MeasuringInputStream;
import com.sap.core.deploy.client.impl.Restarter;
import com.sap.core.deploy.client.pojo.ActionResource;
import com.sap.core.deploy.client.pojo.Maintenance;
import com.sap.core.deploy.client.pojo.Operations;
import com.sap.core.deploy.client.progress.IProgressListener;
import com.sap.core.deploy.client.publicrest.impl.DeployClient;
import com.sap.core.deploy.client.publicrest.impl.EnableDisableApplicationClient;
import com.sap.core.deploy.client.publicrest.impl.EnableDisableProcessClient;
import com.sap.core.deploy.client.publicrest.impl.ReadBasicApplicationStateClient;
import com.sap.core.deploy.client.publicrest.impl.ReadDetailedApplicationStateClient;
import com.sap.core.deploy.client.publicrest.impl.ReadProcessStateClient;
import com.sap.core.deploy.client.publicrest.impl.ReadProcessStateShortcutClient;
import com.sap.core.deploy.client.publicrest.impl.UndeployClient;
import com.sap.core.deploy.client.publicrest.impl.UpdateApplicationStateClient;
import com.sap.core.deploy.client.publicrest.impl.UpdateProcessStateClient;
import com.sap.core.deploy.client.publicrest.impl.UpdateProcessStateShortcutClient;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.client.utils.DeployResultPollingUtil;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import com.sap.core.deploy.client.utils.DeploymentContentAnalyzer;
import com.sap.core.deploy.client.utils.HttpClientFactory;
import com.sap.core.deploy.client.utils.LogonUtils;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.resource.ApplicationAction;
import com.sap.core.deploy.commons.rest.entity.enumerations.ApplicationStateEnum;
import com.sap.core.deploy.commons.rest.entity.enumerations.LoadBalancerStateEnum;
import com.sap.core.deploy.commons.rest.entity.enumerations.ProcessStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.TargetApplicationState;
import com.sap.core.deploy.commons.rest.entity.request.TargetProcessState;
import com.sap.core.deploy.commons.util.IOUtils;
import com.sap.core.jpaasrepository.api.Descriptor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class DeployerImpl
implements IDeployer {
    private static final String HTTPS = "https";
    private static final String INCLUDE_DETAILS_URL_PARAM = "?includeDetails=true";
    private static final String DEPLOY_ALIAS = "/deploy";
    private static final String SLASH = "/";
    private static final String UTF8 = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final Pattern PATTERN_ALPHANUMERIC_LOWERCASE = Pattern.compile("^[a-z][a-z0-9]{0,29}$");
    private static final int SOCKET_TIMEOUT = 600000;
    private static final Logger LOGGER = Logger.getLogger(DeployerImpl.class);
    private String jpSpaceName;
    public static final String DEPLOY_OPERATION_NAME = "deploy";
    public static final String UNDEPLOY_OPERATION_NAME = "undeploy";
    public static final String UPDATE_PROCESS_STATE_OPERATION_NAME = "update process state to %s";
    public static final String READ_APPLICATION_STATE_OPERATION = "read application state";
    public static final String READ_PROCESS_STATE_OPERATION = "read process state";
    public static final String SET_APPLICATION_PROPERTY = "set application property";
    private static final String START_OPERATION_NAME = "start";
    private static final String STOP_OPERATION_NAME = "stop";
    public static final String STATUS_HEADER_NAME = "X-NWCloud-Status";
    public static final String STATUS_HEADER_ACCESS_DENIED = "Network Access Denied";
    public static final int MINIMUM_SIZE_FOR_MULTIPLE_CONNECTIONS = 0x500000;
    private static final int DEFAULT_PARALLEL_CONNECTIONS_COUNT = 2;
    private static final int MAX_CONNECTION_PER_DEPLOY = 6;
    private final CookieStore deployCookieStore = new BasicCookieStore();
    private final HttpContext deployLocalContext = new BasicHttpContext();
    private final CookieStore startCookieStore = new BasicCookieStore();
    private final HttpContext startLocalContext = new BasicHttpContext();
    private final HttpClient httpClient;
    private String agentVersion;
    private String agentName;
    private DeployFeedbackHelper feedbackHelper = new DeployFeedbackHelper();
    public static final String DEFAULT_COMPONENT = "web";

    @Deprecated
    public DeployerImpl(String jpSpaceName) {
        this(jpSpaceName, null);
        this.deployLocalContext.setAttribute("http.cookie-store", (Object)this.deployCookieStore);
        this.startLocalContext.setAttribute("http.cookie-store", (Object)this.startCookieStore);
    }

    public DeployerImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.setSocketTimeout(httpClient);
    }

    public DeployerImpl(String jpSpaceName, HttpClient httpClient) {
        this(httpClient);
        if (jpSpaceName == null || jpSpaceName.trim().isEmpty()) {
            throw new IllegalArgumentException("Please specify space name.\r\nIt must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!");
        }
        Matcher matchSpace = PATTERN_ALPHANUMERIC_LOWERCASE.matcher(jpSpaceName);
        if (!matchSpace.matches()) {
            throw new IllegalArgumentException("Space name " + jpSpaceName + " is not valid.\r\n" + "It must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!");
        }
        this.jpSpaceName = jpSpaceName;
    }

    public DeployerImpl(String accountName, HttpClient httpClient, DeployFeedbackListener feedbackListener) {
        this(accountName, httpClient);
        this.feedbackHelper.setFeedbackListener(feedbackListener);
    }

    public DeployerImpl(String accountName, HttpClient httpClient, DeployFeedbackListener feedbackListener, String agentName, String agentVersion) {
        this(accountName, httpClient, feedbackListener);
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    private void setSocketTimeout(HttpClient httpClient) {
        if (httpClient != null) {
            HttpParams params = httpClient.getParams();
            Integer timeout = params.getIntParameter("http.socket.timeout", 600000);
            if (timeout == 0 || timeout < 60000) {
                timeout = 600000;
            }
            params.setIntParameter("http.socket.timeout", timeout.intValue());
        }
    }

    @Override
    @Deprecated
    public void setHttpProxy(String proxyHost, int proxyPort) {
        if (this.httpClient != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, HTTPS);
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", String.valueOf(proxyPort));
        String https_nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (https_nonProxyHosts == null || https_nonProxyHosts.isEmpty()) {
            https_nonProxyHosts = "*.sap.corp";
        } else {
            if (https_nonProxyHosts.contains("*.sap.corp")) {
                return;
            }
            https_nonProxyHosts = String.valueOf(https_nonProxyHosts) + "|*.sap.corp";
        }
        System.setProperty("http.nonProxyHosts", https_nonProxyHosts);
    }

    @Override
    public DeployResult deploy(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, Descriptor descriptor, String host) throws Exception {
        long startTime = System.currentTimeMillis();
        DeployTimeoutUtil.scheduleDeployTimeout();
        boolean isSuccessful = false;
        String fullApplicationName = DeployClientUtils.getFullApplicationName(this.jpSpaceName, jpApplianceName, jpApplianceComponentName);
        this.logStartOfDeployment(fullApplicationName);
        try {
            DeployResult deployResult = this.validateApplianceComponent(jpApplianceName, jpApplianceComponentName);
            if (deployResult != null) {
                DeployResult deployResult2 = deployResult;
                return deployResult2;
            }
            HttpClient client = this.getClient();
            DeployClient restClient = new DeployClient(this.jpSpaceName, jpApplianceName, descriptor, host = this.prepareAndValidateHost(host), client, this.feedbackHelper, this.agentName, this.agentVersion);
            if (restClient.usePublicRest(jpApplianceComponentName)) {
                DeployResult result = restClient.doDeploy();
                isSuccessful = result.getCode() == 0;
                DeployResult deployResult3 = result;
                return deployResult3;
            }
            DeployResult result = this.doDeployComponent(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, descriptor, host, client, DEPLOY_OPERATION_NAME);
            isSuccessful = result.getCode() == 0;
            DeployResult deployResult4 = result;
            return deployResult4;
        }
        finally {
            this.logEndOfDeployment(startTime, fullApplicationName, isSuccessful);
        }
    }

    @Override
    public DeployResult deploy(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, Descriptor descriptor, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        long startTime = System.currentTimeMillis();
        boolean isSuccessful = false;
        String fullApplicationName = DeployClientUtils.getFullApplicationName(this.jpSpaceName, jpApplianceName, jpApplianceComponentName);
        this.logStartOfDeployment(fullApplicationName);
        try {
            DeployResult deployResult = this.validateApplianceComponent(jpApplianceName, jpApplianceComponentName);
            if (deployResult != null) {
                DeployResult deployResult2 = deployResult;
                return deployResult2;
            }
            HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
            host = DeployClientUtils.prepareAndValidateHostString(host);
            LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, host, "");
            DeployResult result = this.doDeployComponent(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, descriptor, host, httpClient, "spaces");
            isSuccessful = result.getCode() == 0;
            DeployResult deployResult3 = result;
            return deployResult3;
        }
        finally {
            this.logEndOfDeployment(startTime, fullApplicationName, isSuccessful);
        }
    }

    private void logStartOfDeployment(String fullApplicationName) {
        this.feedbackHelper.deployStarted(2);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting deployment of application [" + fullApplicationName + "]"));
        }
    }

    private void logEndOfDeployment(long startTime, String fullApplicationName, boolean successful) {
        this.feedbackHelper.deployFinished(successful);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Deployment operation of application [" + fullApplicationName + "] finished for [" + (System.currentTimeMillis() - startTime) + "] ms"));
        }
    }

    private DeployResult validateApplianceComponent(String jpApplianceName, String jpApplianceComponentName) {
        if (jpApplianceName == null || jpApplianceName.trim().isEmpty()) {
            return new DeployResult(2, "Please specify appliance name.\r\nIt must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!", null);
        }
        Matcher matchAppliance = PATTERN_ALPHANUMERIC_LOWERCASE.matcher(jpApplianceName = jpApplianceName.toLowerCase());
        if (!matchAppliance.matches()) {
            return new DeployResult(2, "Appliance name " + jpApplianceName + " is not valid.\r\n" + "It must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!", null);
        }
        if (jpApplianceComponentName == null || jpApplianceComponentName.trim().isEmpty()) {
            return new DeployResult(2, "Please specify component name.\r\nIt must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!", null);
        }
        Matcher matchComponent = PATTERN_ALPHANUMERIC_LOWERCASE.matcher(jpApplianceComponentName);
        if (!matchComponent.matches()) {
            return new DeployResult(2, "Component name " + jpApplianceComponentName + " is not valid.\r\n" + "It must be non-empty alphanumeric, lowercase letters, starting with a letter, limited to 30 characters!", null);
        }
        return null;
    }

    private DeployResult doDeployComponent(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, Descriptor descriptor, String host, HttpClient httpClient, String dplServiceAlias) throws Exception {
        Header locationHeader;
        DeployClientUtils.validateServiceInstancesCfg(descriptor);
        String shortUrl = descriptor.get("url");
        if (shortUrl == null || shortUrl.isEmpty()) {
            String generatedShortUrl = DEFAULT_COMPONENT.equals(jpApplianceComponentName) ? String.valueOf(jpApplianceName) + this.jpSpaceName : String.valueOf(jpApplianceComponentName) + jpApplianceName + this.jpSpaceName;
            descriptor.set("url", generatedShortUrl);
        } else {
            this.validateShortUrl(shortUrl);
        }
        String[] updateSites = DeployClientUtils.getUpdateSitesValue(descriptor);
        DeploymentContentAnalyzer analyzer = new DeploymentContentAnalyzer(updateSites);
        analyzer.analyze();
        String putRequest = String.valueOf(host) + SLASH + dplServiceAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName + SLASH + "components" + SLASH + jpApplianceComponentName + SLASH + jpApplianceComponentVersion;
        byte parallelConnectionsCount = 2;
        String parallelConnectionsCountStr = descriptor.get("connections");
        if (parallelConnectionsCountStr != null && !parallelConnectionsCountStr.isEmpty()) {
            parallelConnectionsCount = Byte.parseByte(parallelConnectionsCountStr);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Parallel connections count requested for deploy: " + parallelConnectionsCount));
            }
            if (parallelConnectionsCount < 1) {
                throw new IllegalArgumentException("Requested number of parallel connections is " + parallelConnectionsCount + " but the allowed number is between 1 and " + 6);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Initial parallel connections count configured for deploy: " + parallelConnectionsCount));
        }
        boolean parallelUploadRequested = parallelConnectionsCount > 1;
        HttpResponse response = null;
        HttpPut httpPut = null;
        if (parallelUploadRequested) {
            ClientConnectionManager cm = httpClient.getConnectionManager();
            if (!(cm instanceof ThreadSafeClientConnManager)) {
                LOGGER.warn((Object)"Http client is not configured with a thread-safe configured manager and cannot be used for multiple requests. Falling back to deployment with one connection");
                parallelUploadRequested = false;
            } else if (analyzer.getDeploymentFiles() == null || analyzer.getDeploymentFiles().length == 0) {
                LOGGER.warn((Object)"Upload with parallel connections is not applicable for the case of deployment from remote update site. Falling back to deployment with one connection");
                parallelUploadRequested = false;
            } else {
                analyzer.calculateSize();
                if (analyzer.getTotalSize() < 0x500000L) {
                    LOGGER.warn((Object)("Size  of detected local deployment content is " + analyzer.getTotalSize() + " bytes and is not suitable for upload with multiple connections"));
                    LOGGER.warn((Object)"Falling back to deployment with one connection to avoid unnecessary overhead");
                    parallelUploadRequested = false;
                }
            }
        }
        if (!parallelUploadRequested) {
            HttpGet hg = new HttpGet(String.valueOf(host) + SLASH + dplServiceAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName + SLASH + "components" + SLASH + jpApplianceComponentName + "/status");
            LOGGER.debug((Object)"Performing test GET request to server before deploy");
            response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)hg, "2.2", 2, 2);
            LOGGER.debug((Object)"Test GET request performed successfully");
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Sending handshake request for deploy with multuple connections - PUT " + putRequest));
            }
            if (parallelConnectionsCount > 6) {
                LOGGER.warn((Object)("Deployment with " + parallelConnectionsCount + " parallel connections was requested but the maximum allowed count is " + 6));
                LOGGER.warn((Object)"Resetting parallel connections count to 6");
                parallelConnectionsCount = 6;
            }
            httpPut = new HttpPut(putRequest);
            httpPut.setHeader("X-DeployStrategy", "asynchronous");
            httpPut.setHeader("X-Connections", String.valueOf(parallelConnectionsCount));
            BasicHttpEntity bEntity = new BasicHttpEntity();
            String handshake = "handshake";
            byte[] handshakeContent = handshake.getBytes(UTF8);
            bEntity.setContentType(analyzer.getContentType());
            bEntity.setContent((InputStream)new ZipInputStream(new ByteArrayInputStream(handshakeContent)));
            httpPut.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)bEntity));
            response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpPut, "2.2", 2, 2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Handshake request executed successfully");
            }
        }
        EntityUtils.consume((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("HTTP status code from initial request is " + statusCode));
        }
        switch (statusCode) {
            case 200: 
            case 202: {
                break;
            }
            case 401: {
                return new DeployResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
            }
            case 403: {
                String statusHeaderValue = null;
                Header statusHeader = response.getFirstHeader(STATUS_HEADER_NAME);
                if (statusHeader != null) {
                    statusHeaderValue = statusHeader.getValue();
                }
                if (statusHeaderValue != null && statusHeaderValue.equals(STATUS_HEADER_ACCESS_DENIED)) {
                    return new DeployResult(1, String.format("Access to %s is not allowed from your network. Contact SAP Cloud Platform for help", host), null);
                }
                LOGGER.error((Object)("Unexpected response from server - HTTP status code 403, X-NWCloud-Status: " + statusHeaderValue));
                return new DeployResult(1, "Unexpected response from server - HTTP status code 403", null);
            }
            case 404: {
                if (!parallelUploadRequested) break;
            }
            case 500: {
                if (parallelUploadRequested && "application/zip; folder=wars_and_bundles".equals(analyzer.getContentType())) {
                    LOGGER.warn((Object)"Server does not support upload through multiple connections. Falling back to usage of one connection");
                    parallelUploadRequested = false;
                    break;
                }
            }
            case 580: {
                if (parallelUploadRequested && "application/zip".equals(analyzer.getContentType())) {
                    LOGGER.warn((Object)"Server does not support upload through multiple connections. Falling back to usage of one connection");
                    parallelUploadRequested = false;
                    break;
                }
            }
            default: {
                return new DeployResult(1, "Unexpected response from server - HTTP status code " + statusCode, null);
            }
        }
        boolean putRequestExecuted = false;
        if (!parallelUploadRequested) {
            httpPut = new HttpPut(putRequest);
            httpPut.setHeader("X-DeployStrategy", "asynchronous");
            httpPut.setEntity((HttpEntity)this.createDeployComponentEntity(descriptor, analyzer));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Sending PUT request to the server for single-connection deploy...");
            }
            response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpPut, "2.2", 2, 2);
            putRequestExecuted = true;
        }
        if (httpPut == null) {
            throw new DeployClientException("Either the handshake request on parallel deployment or the upload request for single connection failed to execute!");
        }
        String restRequest = httpPut.getRequestLine().toString();
        DeployResult result = ResultBuilder.buildDeployResult(response, DEPLOY_OPERATION_NAME, restRequest);
        if (result != null) {
            return result;
        }
        if (putRequestExecuted) {
            this.feedbackHelper.uploadFinished();
        }
        if ((locationHeader = response.getFirstHeader("Location")) == null) {
            return new DeployResult(3, "Missing 'Location' header in server response!", null);
        }
        String statusPollUrl = locationHeader.getValue();
        Multiplexer multiplexer = null;
        if (parallelUploadRequested) {
            Header operationIdHeader = response.getFirstHeader("X-OperationID");
            String operationId = operationIdHeader.getValue();
            multiplexer = this.createMultiplexer(httpClient, putRequest, descriptor, analyzer, parallelConnectionsCount, operationId);
            multiplexer.start();
        }
        DeployResultPollingUtil pollingUtil = new DeployResultPollingUtil(httpClient, multiplexer, parallelConnectionsCount, statusPollUrl, restRequest);
        return pollingUtil.getAsyncDeployResult();
    }

    void validateShortUrl(String shortUrl) {
        String shortUrlFormat = "It must be a non-empty, alphanumeric string, starting with a letter, limited to 30 characters. Please, provide short URL.";
        Matcher matchShortUrl = PATTERN_ALPHANUMERIC_LOWERCASE.matcher(shortUrl = shortUrl.toLowerCase());
        if (!matchShortUrl.matches()) {
            throw new IllegalArgumentException("Short URL " + shortUrl + " is not valid.\r\n" + shortUrlFormat);
        }
    }

    protected AbstractHttpEntity createDeployComponentEntity(final Descriptor descriptor, DeploymentContentAnalyzer analyzer) throws IOException, UnsupportedEncodingException {
        final File[] deploymentContentFiles = analyzer.getDeploymentFiles();
        String contentType = analyzer.getContentType();
        analyzer.calculateSize();
        if ("application/zip".equals(contentType)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Deployment from local update site initiated...");
            }
            this.feedbackHelper.setTotalSize(analyzer.getTotalSize());
            PipedInputStream pis = new PipedInputStream(131072);
            final PipedOutputStream pos = new PipedOutputStream();
            pis.connect(pos);
            final ZipOutputStream zos = new ZipOutputStream(pos);
            zos.setLevel(0);
            new Thread(){

                @Override
                public void run() {
                    try {
                        DeployClientUtils.zipWithDescriptor(zos, deploymentContentFiles[0], descriptor, "p2.repo");
                    }
                    catch (Throwable e) {
                        LOGGER.error((Object)e);
                        IOUtils.closeQuietly((Closeable)pos);
                    }
                }
            }.start();
            MeasuringInputStream measuringIS = new MeasuringInputStream(pis, this.feedbackHelper, false);
            BasicHttpEntity bEntity = new BasicHttpEntity();
            bEntity.setContent((InputStream)new BufferedInputStream(measuringIS, 65536));
            bEntity.setContentType(contentType);
            return bEntity;
        }
        if ("application/zip; folder=wars_and_bundles".equals(contentType)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Deployment of local war files, bundles and folders initiated...");
            }
            this.feedbackHelper.setTotalSize(analyzer.getTotalSize());
            PipedInputStream pis = new PipedInputStream(131072);
            final PipedOutputStream pos = new PipedOutputStream();
            pis.connect(pos);
            final ZipOutputStream zos = new ZipOutputStream(pos);
            new Thread(){

                @Override
                public void run() {
                    try {
                        DeployClientUtils.zipWithDescriptor(zos, deploymentContentFiles, descriptor, "");
                    }
                    catch (Throwable e) {
                        LOGGER.error((Object)e);
                        IOUtils.closeQuietly((Closeable)pos);
                    }
                }
            }.start();
            MeasuringInputStream measuringIS = new MeasuringInputStream(pis, this.feedbackHelper, true);
            BasicHttpEntity bEntity = new BasicHttpEntity();
            bEntity.setContent((InputStream)new BufferedInputStream(measuringIS, 65536));
            bEntity.setContentType(contentType);
            return bEntity;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Deployment from remote update site initiated...");
        }
        String requestBody = descriptor.serializeToJson();
        StringEntity entity = new StringEntity(requestBody, UTF8);
        return entity;
    }

    protected Multiplexer createMultiplexer(HttpClient httpClient, String baseUrl, final Descriptor descriptor, final DeploymentContentAnalyzer analyzer, byte connectionsCount, String deployOperationId) throws IOException {
        final String zipEntryPrefix = "application/zip".equals(analyzer.getContentType()) ? "p2.repo" : "";
        this.feedbackHelper.setTotalSize(analyzer.getTotalSize());
        PipedInputStream pis = new PipedInputStream(65536);
        final PipedOutputStream pos = new PipedOutputStream();
        pis.connect(pos);
        final ZipOutputStream zos = new ZipOutputStream(pos);
        new Thread(){

            @Override
            public void run() {
                try {
                    DeployClientUtils.zipWithDescriptor(zos, analyzer.getDeploymentFiles(), descriptor, zipEntryPrefix);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)e);
                    IOUtils.closeQuietly((Closeable)pos);
                }
            }
        }.start();
        MeasuringInputStream measuringIS = new MeasuringInputStream(pis, this.feedbackHelper, true);
        return new Multiplexer(httpClient, baseUrl, measuringIS, connectionsCount, deployOperationId);
    }

    @Override
    public DeployResult undeploy(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String hostURL, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, hostURL, "");
        return this.doUndeploy(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, hostURL, httpClient, "spaces", this.agentName, this.agentVersion);
    }

    @Override
    public DeployResult undeploy(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String hostURL) throws Exception {
        HttpClient client = this.getClient();
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        return this.doUndeploy(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, hostURL, client, DEPLOY_OPERATION_NAME, this.agentName, this.agentVersion);
    }

    private DeployResult doUndeploy(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String host, HttpClient httpClient, String applicationAlias, String agentName, String agentVersion) throws Exception {
        if (jpApplianceComponentName == null || jpApplianceComponentName.trim().equals("")) {
            return new DeployResult(1, "Please specify component name.", null);
        }
        String deleteRequest = String.valueOf(host) + SLASH + applicationAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName + SLASH + "components" + SLASH + jpApplianceComponentName + SLASH + jpApplianceComponentVersion;
        HttpDelete httpDelete = new HttpDelete(deleteRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Undeploying component " + jpApplianceComponentName + " on space " + this.jpSpaceName + " and appliance " + jpApplianceName + "."));
        }
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpDelete, "1.0", 2, 2);
        String restRequest = httpDelete.getRequestLine().toString();
        return ResultBuilder.buildDeployResult(response, UNDEPLOY_OPERATION_NAME, restRequest);
    }

    @Override
    public DeployResult undeploy(String jpApplianceName, String hostURL, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, hostURL, "");
        return this.doUndeploy(jpApplianceName, hostURL, httpClient, "spaces");
    }

    @Override
    public DeployResult undeploy(String jpApplianceName, String hostURL) throws Exception {
        HttpClient client = this.getClient();
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        UndeployClient restClient = new UndeployClient(hostURL, this.jpSpaceName, this.agentName, this.agentVersion);
        return restClient.doUndeploy(this.jpSpaceName, jpApplianceName, client);
    }

    private DeployResult doUndeploy(String jpApplianceName, String host, HttpClient httpClient, String applicationAlias) throws Exception {
        String deleteRequest = String.valueOf(host) + SLASH + applicationAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName;
        HttpDelete httpDelete = new HttpDelete(deleteRequest);
        LOGGER.info((Object)("Undeploying appliance " + jpApplianceName + " on space " + this.jpSpaceName + "."));
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpDelete, "1.0", 2, 2);
        String restRequest = httpDelete.getRequestLine().toString();
        return ResultBuilder.buildDeployResult(response, UNDEPLOY_OPERATION_NAME, restRequest);
    }

    @Override
    public LifecycleResult start(String jpApplianceName, String jpComponentName, String jpApplianceComponentVersion, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        host = DeployClientUtils.prepareAndValidateHostString(host);
        LogonUtils.createLoginRequest(httpClient, this.startLocalContext, host, "domain/");
        return this.doStart(jpApplianceName, jpComponentName, jpApplianceComponentVersion, host, null, false, httpClient, "domain");
    }

    @Override
    public LifecycleResult start(String jpApplianceName, String jpComponentName, String jpApplianceComponentVersion, String host, String tenant) throws Exception {
        return this.start(jpApplianceName, jpComponentName, jpApplianceComponentVersion, host, tenant, false);
    }

    @Override
    public LifecycleResult start(String jpApplianceName, String jpComponentName, String jpApplianceComponentVersion, String host, String tenant, boolean startDisabled) throws Exception {
        TargetApplicationState targetAppState;
        HttpClient client = this.getClient();
        UpdateApplicationStateClient updateAppStateRestClient = this.createUpdateAppStateRestClient(jpApplianceName, host = this.prepareAndValidateHost(host), targetAppState = new TargetApplicationState(startDisabled, tenant));
        if (updateAppStateRestClient.usePublicRest(jpComponentName)) {
            return updateAppStateRestClient.doUpdate(client);
        }
        return this.doStart(jpApplianceName, jpComponentName, jpApplianceComponentVersion, host, tenant, startDisabled, client, "domain_basic");
    }

    @Override
    public LifecycleResult start(String jpApplianceName, String jpComponentName, String jpApplianceComponentVersion, String host) throws Exception {
        return this.start(jpApplianceName, jpComponentName, jpApplianceComponentVersion, host, null, false);
    }

    protected LifecycleResult doStart(String jpApplianceName, String jpComponentName, String jpApplianceComponentVersion, String host, String tenant, boolean startDisabled, HttpClient httpClient, String applicationAlias) throws Exception {
        if (jpApplianceName == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (jpComponentName == null) {
            throw new IllegalArgumentException("Component name must not be null.");
        }
        if (host.endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder startRequest = new StringBuilder(String.valueOf(host) + SLASH + applicationAlias + SLASH + "spaces" + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName + SLASH + "components" + SLASH + jpComponentName);
        if (tenant != null && tenant.length() > 0) {
            startRequest.append(SLASH).append("tenants").append(SLASH).append(tenant);
        }
        HttpPut startHttpPutRequest = new HttpPut(startRequest.toString());
        if (startDisabled) {
            String startOperationJsonBody = "{\"actions\":[\"" + ApplicationAction.START_DISABLED + "\"]}";
            startHttpPutRequest.setEntity((HttpEntity)new StringEntity(startOperationJsonBody, APPLICATION_JSON, UTF8));
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder("Starting component [" + jpComponentName + "] in account [" + this.jpSpaceName + "] and application [" + jpApplianceName + "]");
            if (tenant != null && tenant.length() > 0) {
                debugMessage.append(" for tenant [").append(tenant).append("]");
            }
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse startResponse = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)startHttpPutRequest, "1.0", 2, 2);
        String restRequest = startHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(startResponse, START_OPERATION_NAME, restRequest, host, true);
    }

    @Override
    public LifecycleResult stop(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String hostURL, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL);
        LogonUtils.createLoginRequest(httpClient, this.startLocalContext, hostURL, "domain/");
        return this.doStop(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, hostURL, null, httpClient, "domain");
    }

    @Override
    public LifecycleResult stop(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String hostURL) throws Exception {
        return this.stop(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, hostURL, null);
    }

    @Override
    public LifecycleResult stop(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String hostURL, String tenant) throws Exception {
        TargetApplicationState targetAppState;
        HttpClient client = this.getClient();
        UpdateApplicationStateClient updateAppStateRestClient = this.createUpdateAppStateRestClient(jpApplianceName, hostURL = this.prepareAndValidateHost(hostURL), targetAppState = new TargetApplicationState(ApplicationStateEnum.STOPPED, tenant));
        if (updateAppStateRestClient.usePublicRest(jpApplianceComponentName)) {
            return updateAppStateRestClient.doUpdate(client);
        }
        return this.doStop(jpApplianceName, jpApplianceComponentName, jpApplianceComponentVersion, hostURL, tenant, client, "domain_basic");
    }

    protected UpdateApplicationStateClient createUpdateAppStateRestClient(String jpApplianceName, String host, TargetApplicationState targetAppState) {
        return new UpdateApplicationStateClient(this.jpSpaceName, jpApplianceName, host, targetAppState, this.agentName, this.agentVersion);
    }

    @Override
    public LifecycleResult stop(String applicationProcessId, String hostURL) throws Exception {
        hostURL = this.prepareAndValidateHost(hostURL);
        TargetProcessState targetProcessState = new TargetProcessState(ProcessStateEnum.STOPPED);
        UpdateProcessStateShortcutClient client = this.createUpdateProcessStateShortcutClient(applicationProcessId, hostURL, targetProcessState);
        return client.doUpdate(this.httpClient);
    }

    protected UpdateProcessStateShortcutClient createUpdateProcessStateShortcutClient(String applicationProcessId, String hostURL, TargetProcessState targetProcessState) {
        return new UpdateProcessStateShortcutClient(applicationProcessId, hostURL, targetProcessState, this.agentName, this.agentVersion);
    }

    @Override
    public LifecycleResult stopProcess(String jpApplianceName, String jpApplianceComponentName, String processId, String hostURL) throws Exception {
        HttpClient client = this.getClient();
        UpdateProcessStateClient updateProcessStateRestClient = new UpdateProcessStateClient(this.jpSpaceName, jpApplianceName, processId, hostURL = DeployClientUtils.prepareAndValidateHostString(hostURL), new TargetProcessState(ProcessStateEnum.STOPPED), this.agentName, this.agentVersion);
        if (updateProcessStateRestClient.usePublicRest(jpApplianceComponentName)) {
            return updateProcessStateRestClient.doUpdate(client);
        }
        return this.stop(processId, hostURL);
    }

    protected LifecycleResult doStop(String jpApplianceName, String jpApplianceComponentName, String jpApplianceComponentVersion, String host, String tenant, HttpClient httpClient, String applicationAlias) throws Exception {
        if (jpApplianceName == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (jpApplianceComponentName == null) {
            throw new IllegalArgumentException("Component name must not be null.");
        }
        StringBuilder stopRequest = new StringBuilder(String.valueOf(host) + SLASH + applicationAlias + SLASH + "spaces" + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + jpApplianceName + SLASH + "components" + SLASH + jpApplianceComponentName);
        if (tenant != null && tenant.length() > 0) {
            stopRequest.append(SLASH).append("tenants").append(SLASH).append(tenant);
        }
        HttpDelete httpStopDeleteRequest = new HttpDelete(stopRequest.toString());
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder("Stopping component [" + jpApplianceComponentName + "] in account [" + this.jpSpaceName + "] and appliance [" + jpApplianceName + "]");
            if (tenant != null && tenant.length() > 0) {
                debugMessage.append(" for tenant [").append(tenant).append("]");
            }
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse stopResponse = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpStopDeleteRequest, "1.0", 2, 2);
        String restRequest = httpStopDeleteRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(stopResponse, STOP_OPERATION_NAME, restRequest, host, false);
    }

    @Override
    public RepositoryResult listAppliances(String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        host = DeployClientUtils.prepareAndValidateHostString(host);
        LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, host, "");
        return this.doListAppliances(host, httpClient, "spaces");
    }

    @Override
    public RepositoryResult listAppliances(String host) throws Exception {
        HttpClient client = this.getClient();
        host = DeployClientUtils.prepareAndValidateHostString(host);
        return this.doListAppliances(host, client, DEPLOY_OPERATION_NAME);
    }

    private RepositoryResult doListAppliances(String host, HttpClient httpClient, String applicationAlias) throws Exception {
        String getAppliancesRequest = String.valueOf(host) + SLASH + applicationAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH;
        HttpGet httpGet = new HttpGet(getAppliancesRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Getting appliances on host [" + host + "]."));
        }
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpGet, "1.0", 2, 2);
        return ResultBuilder.buildRepositoryResult(response, "appliances");
    }

    @Override
    public RepositoryResult listComponents(String appliance, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
        host = DeployClientUtils.prepareAndValidateHostString(host);
        LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, host, "");
        return this.doListComponents(appliance, host, httpClient, "spaces");
    }

    @Override
    public RepositoryResult listComponents(String appliance, String host) throws Exception {
        HttpClient client = this.getClient();
        host = DeployClientUtils.prepareAndValidateHostString(host);
        return this.doListComponents(appliance, host, client, DEPLOY_OPERATION_NAME);
    }

    private RepositoryResult doListComponents(String appliance, String host, HttpClient httpClient, String applicationAlias) throws Exception {
        if (host == null || "".equals(host)) {
            return new RepositoryResult(1, "No host specified");
        }
        if (appliance == null || "".equals(appliance)) {
            return new RepositoryResult(1, "No appliance specified");
        }
        String getAppliancesRequest = String.valueOf(host) + SLASH + applicationAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + appliance + SLASH + "components";
        HttpGet httpGet = new HttpGet(getAppliancesRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Getting components of appliance [" + appliance + "] on host [" + host + "]."));
        }
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpGet, "1.0", 2, 2);
        return ResultBuilder.buildRepositoryResult(response, "components");
    }

    @Override
    public DeployResult deploy(String appliance, Descriptor descriptor, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        long startTime = System.currentTimeMillis();
        boolean isSuccessful = false;
        String fullApplicationName = DeployClientUtils.getFullApplicationName(this.jpSpaceName, appliance, null);
        this.logStartOfDeployment(fullApplicationName);
        try {
            HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, true);
            host = DeployClientUtils.prepareAndValidateHostString(host);
            LogonUtils.createLoginRequest(httpClient, this.deployLocalContext, host, "");
            DeployResult result = this.doDeployAppliance(appliance, descriptor, host, httpClient, "spaces");
            isSuccessful = result.getCode() == 0;
            DeployResult deployResult = result;
            return deployResult;
        }
        finally {
            this.logEndOfDeployment(startTime, fullApplicationName, isSuccessful);
        }
    }

    @Override
    public DeployResult deploy(String appliance, Descriptor descriptor, String host) throws Exception {
        long startTime = System.currentTimeMillis();
        boolean isSuccessful = false;
        String fullApplicationName = DeployClientUtils.getFullApplicationName(this.jpSpaceName, appliance, null);
        this.logStartOfDeployment(fullApplicationName);
        try {
            HttpClient client = this.getClient();
            host = DeployClientUtils.prepareAndValidateHostString(host);
            DeployResult result = this.doDeployAppliance(appliance, descriptor, host, client, DEPLOY_OPERATION_NAME);
            isSuccessful = result.getCode() == 0;
            DeployResult deployResult = result;
            return deployResult;
        }
        finally {
            this.logEndOfDeployment(startTime, fullApplicationName, isSuccessful);
        }
    }

    private DeployResult doDeployAppliance(String appliance, Descriptor descriptor, String host, HttpClient httpClient, String dplServiceAlias) throws Exception {
        if (appliance == null || "".equals(appliance)) {
            return new DeployResult(1, "No appliance specified", null);
        }
        if (descriptor == null) {
            return new DeployResult(1, "No descriptor specified", null);
        }
        if (host == null || "".equals(host)) {
            return new DeployResult(1, "No host specified", null);
        }
        String putRequest = String.valueOf(host) + SLASH + dplServiceAlias + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + appliance;
        HttpPut httpPut = new HttpPut(putRequest);
        StringEntity entity = new StringEntity(descriptor.serializeToJson(), UTF8);
        httpPut.setEntity((HttpEntity)entity);
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpPut, "1.0", 2, 2);
        String restRequest = httpPut.getRequestLine().toString();
        return ResultBuilder.buildDeployResult(response, DEPLOY_OPERATION_NAME, restRequest);
    }

    @Override
    public StatusResult getStatus(String appliance, String componentName, String componentVersion, String host, InputStream certificateStream, String keyStorePassword) throws Exception {
        HttpClient httpClient = HttpClientFactory.createSSLHttpClient(certificateStream, keyStorePassword, false);
        host = DeployClientUtils.prepareAndValidateHostString(host);
        LogonUtils.createLoginRequest(httpClient, this.startLocalContext, host, "domain/");
        return this.doGetStatus(appliance, componentName, componentVersion, host, null, httpClient, "domain");
    }

    @Override
    public StatusResult getStatus(String appliance, String componentName, String componentVersion, String host) throws Exception {
        return this.getStatus(appliance, componentName, componentVersion, host, null);
    }

    @Override
    public StatusResult getStatusBasic(String application, String host) throws Exception {
        HttpClient client = this.getClient();
        host = DeployClientUtils.prepareAndValidateHostString(host);
        ReadBasicApplicationStateClient readAppStatePublicRestClient = new ReadBasicApplicationStateClient(this.jpSpaceName, application, host, this.agentName, this.agentVersion);
        return readAppStatePublicRestClient.readState(client);
    }

    @Override
    public Map<String, StatusResult> listAppComponentDetails(String application, String host) throws Exception {
        Map<String, StatusResult> invalidParameters = this.populateMapWithInvalidParameters(application, host);
        if (!invalidParameters.isEmpty()) {
            return invalidParameters;
        }
        host = DeployClientUtils.prepareAndValidateHostString(host);
        String getAppliancesRequest = String.valueOf(host) + DEPLOY_ALIAS + SLASH + this.jpSpaceName + SLASH + "appliances" + SLASH + application + SLASH + "components" + INCLUDE_DETAILS_URL_PARAM;
        HttpGet httpGet = new HttpGet(getAppliancesRequest);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Getting statuses of all components of application [" + application + "] on host [" + host + "]."));
        }
        HttpResponse response = NetworkUtils.executeRequestAndFollowRedirect(this.getClient(), (HttpRequestBase)httpGet, "1.0", 2, 2);
        return new ResultBuilder().extractResultFromResponse(response, this.jpSpaceName, application, host);
    }

    public Map<String, StatusResult> populateMapWithInvalidParameters(String application, String host) {
        TreeMap<String, StatusResult> result = new TreeMap<String, StatusResult>();
        if (host == null || "".equals(host)) {
            result.put("", new StatusResult(1, "No host specified"));
        }
        if (application == null || "".equals(application)) {
            result.put("", new StatusResult(1, "No application specified"));
        }
        return result;
    }

    @Override
    public StatusResult getStatus(String appliance, String componentName, String componentVersion, String host, String tenantId) throws Exception {
        HttpClient client = this.getClient();
        host = DeployClientUtils.prepareAndValidateHostString(host);
        ReadDetailedApplicationStateClient readAppStatePublicRestClient = new ReadDetailedApplicationStateClient(this.jpSpaceName, appliance, host, this.agentName, this.agentVersion);
        if (tenantId == null && readAppStatePublicRestClient.usePublicRest(componentName)) {
            return readAppStatePublicRestClient.readState(client);
        }
        return this.doGetStatus(appliance, componentName, componentVersion, host, tenantId, client, "domain_basic");
    }

    @Override
    public StatusResult getStatus(String applicationProcessId, String host) throws Exception {
        host = this.prepareAndValidateHost(host);
        ReadProcessStateShortcutClient client = this.createReadProcessStateShortcutClient(applicationProcessId, host);
        return client.readState(this.httpClient);
    }

    protected ReadProcessStateShortcutClient createReadProcessStateShortcutClient(String applicationProcessId, String host) {
        return new ReadProcessStateShortcutClient(applicationProcessId, host, this.agentName, this.agentVersion);
    }

    @Override
    public StatusResult getProcessStatus(String jpApplianceName, String jpApplianceComponentName, String applicationProcessId, String host) throws Exception {
        HttpClient client = this.getClient();
        ReadProcessStateClient restClient = new ReadProcessStateClient(this.jpSpaceName, jpApplianceName, applicationProcessId, host = DeployClientUtils.prepareAndValidateHostString(host), this.agentName, this.agentVersion);
        if (restClient.usePublicRest(jpApplianceComponentName)) {
            return restClient.readState(client);
        }
        return this.getStatus(applicationProcessId, host);
    }

    private StatusResult doGetStatus(String appliance, String componentName, String componentVersion, String host, String tenantId, HttpClient httpClient, String applicationAlias) throws Exception {
        if (host == null || "".equals(host)) {
            return new StatusResult(1, "No host specified");
        }
        if (appliance == null || "".equals(appliance)) {
            return new StatusResult(1, "No appliance specified");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(host).append(SLASH).append(applicationAlias).append(SLASH).append("spaces").append(SLASH).append(this.jpSpaceName).append(SLASH).append("appliances").append(SLASH).append(appliance).append(SLASH);
        if (componentName != null) {
            sb.append("components").append(SLASH).append(componentName).append(SLASH);
        }
        if (tenantId != null) {
            sb.append("tenants").append(SLASH).append(tenantId);
        }
        HttpGet httpGet = new HttpGet(sb.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Requesting state of" + (componentName != null ? " component [" + componentName + "] on" : "") + " appliance [" + appliance + "] and  host [" + host + "]."));
        }
        HttpResponse getStateResponse = NetworkUtils.executeRequestAndFollowRedirect(httpClient, (HttpRequestBase)httpGet, "2.2", 2, 2);
        int status = getStateResponse.getStatusLine().getStatusCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Response status " + status + " received when requesting state of" + (componentName != null ? " component [" + componentName + "] on" : "") + " appliance [" + appliance + "] and host [" + host + "]."));
        }
        return ResultBuilder.buildStatusResult(getStateResponse, null, tenantId, host, componentName, appliance, this.jpSpaceName);
    }

    public String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, UTF8));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private HttpClient getClient() throws Exception {
        HttpClient client;
        if (this.httpClient != null) {
            client = this.httpClient;
        } else {
            client = HttpClientFactory.createSSLHttpClient();
            this.setSocketTimeout(client);
        }
        return client;
    }

    @Override
    public LifecycleResult disable(String application, String component, String host, String tenant) throws Exception {
        TargetApplicationState targetApplicationState = new TargetApplicationState(null, LoadBalancerStateEnum.DISABLED, tenant);
        return this.doEnableOrDisableApplication(application, component, host, tenant, Operations.DISABLE, targetApplicationState);
    }

    @Override
    public LifecycleResult disable(String applicationProcessId, String host) throws Exception {
        return this.doEnableOrDisable(applicationProcessId, host, LoadBalancerStateEnum.DISABLED);
    }

    @Override
    public LifecycleResult startMaintenance(String application, String component, String host, String maintenanceApplication, String tenant, String directAccessCode) throws Exception {
        if ((host = DeployClientUtils.prepareAndValidateHostString(host)).endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (component == null || component.length() == 0) {
            component = DEFAULT_COMPONENT;
        }
        if (maintenanceApplication == null) {
            throw new IllegalArgumentException("Maintenance application name must not be null.");
        }
        if (maintenanceApplication.equals(application)) {
            throw new IllegalArgumentException("Application name must not be equal to maintenance application");
        }
        Gson gson = new Gson();
        Maintenance maintenance = new Maintenance();
        maintenance.setMaintenance_application(maintenanceApplication);
        maintenance.setActions(new String[]{Operations.START_MAINTENANCE.toString().toLowerCase()});
        if (directAccessCode != null && directAccessCode.length() > 0) {
            maintenance.setDirectAccessCode(directAccessCode);
        }
        String jsonBody = gson.toJson((Object)maintenance);
        StringEntity entity = new StringEntity(jsonBody.toString(), APPLICATION_JSON, UTF8);
        StringBuilder startMaintenanceRequest = new StringBuilder(512);
        startMaintenanceRequest.append(host).append('/').append("domain_basic").append('/');
        startMaintenanceRequest.append("spaces").append('/').append(this.jpSpaceName).append('/');
        startMaintenanceRequest.append("appliances").append('/').append(application).append('/');
        startMaintenanceRequest.append("components").append('/').append(component);
        if (tenant != null && tenant.length() > 0) {
            startMaintenanceRequest.append('/').append("tenants").append('/').append(tenant);
        }
        HttpPut startMaintenanceHttpPutRequest = new HttpPut(startMaintenanceRequest.toString());
        startMaintenanceHttpPutRequest.setEntity((HttpEntity)entity);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder(256);
            debugMessage.append("Starting maintenance for ");
            this.appendAppIdentifierText(debugMessage, application, component, tenant);
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse startMaintenanceResponse = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)startMaintenanceHttpPutRequest, "1.0");
        String restRequest = startMaintenanceHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(startMaintenanceResponse, "start-maintenance", restRequest, host, true);
    }

    @Override
    public LifecycleResult stopMaintenance(String application, String component, String host, String tenant) throws Exception {
        if ((host = DeployClientUtils.prepareAndValidateHostString(host)).endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (component == null || component.length() == 0) {
            component = DEFAULT_COMPONENT;
        }
        Gson gson = new Gson();
        Maintenance maintenance = new Maintenance();
        maintenance.setActions(new String[]{Operations.STOP_MAINTENANCE.toString().toLowerCase()});
        String jsonBody = gson.toJson((Object)maintenance);
        StringEntity entity = new StringEntity(jsonBody.toString(), APPLICATION_JSON, UTF8);
        StringBuilder stopMaintenanceRequest = new StringBuilder(512);
        stopMaintenanceRequest.append(host).append('/').append("domain_basic").append('/');
        stopMaintenanceRequest.append("spaces").append('/').append(this.jpSpaceName).append('/');
        stopMaintenanceRequest.append("appliances").append('/').append(application).append('/');
        stopMaintenanceRequest.append("components").append('/').append(component);
        if (tenant != null && tenant.length() > 0) {
            stopMaintenanceRequest.append('/').append("tenants").append('/').append(tenant);
        }
        HttpPut stopMaintenanceHttpPutRequest = new HttpPut(stopMaintenanceRequest.toString());
        stopMaintenanceHttpPutRequest.setEntity((HttpEntity)entity);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder(256);
            debugMessage.append("Stopping maintenance for ");
            this.appendAppIdentifierText(debugMessage, application, component, tenant);
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse stopMaintenanceResponse = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)stopMaintenanceHttpPutRequest, "1.0");
        String restRequest = stopMaintenanceHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(stopMaintenanceResponse, "stop-maintenance", restRequest, host, false);
    }

    @Override
    public LifecycleResult setDowntimeApp(String application, String component, String host, String downtimeApplication, String tenant) throws Exception {
        if ((host = DeployClientUtils.prepareAndValidateHostString(host)).endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (component == null || component.length() == 0) {
            component = DEFAULT_COMPONENT;
        }
        if (downtimeApplication == null) {
            throw new IllegalArgumentException("Downtime application name must not be null.");
        }
        if (downtimeApplication.equals(application)) {
            throw new IllegalArgumentException("Application name must not be equal to downtime application");
        }
        StringBuilder setDowntimeAppRequest = new StringBuilder(512);
        setDowntimeAppRequest.append(host).append('/').append("domain_basic").append('/');
        setDowntimeAppRequest.append("spaces").append('/').append(this.jpSpaceName).append('/');
        setDowntimeAppRequest.append("appliances").append('/').append(application).append('/');
        setDowntimeAppRequest.append("components").append('/').append(component);
        if (tenant != null && tenant.length() > 0) {
            setDowntimeAppRequest.append('/').append("tenants").append('/').append(tenant);
        }
        String setDowntimeAppOperationJsonBody = "{\"downtime_application\":\"" + downtimeApplication + "\",\"actions\":[\"" + ApplicationAction.SET_DOWNTIME_APP + "\"]}";
        HttpPut setDowntimeAppHttpPutRequest = new HttpPut(setDowntimeAppRequest.toString());
        setDowntimeAppHttpPutRequest.setEntity((HttpEntity)new StringEntity(setDowntimeAppOperationJsonBody, APPLICATION_JSON, UTF8));
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder(256);
            debugMessage.append("Setting downtime application for ");
            this.appendAppIdentifierText(debugMessage, application, component, tenant);
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse setDowntimeAppResponse = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)setDowntimeAppHttpPutRequest, "1.0");
        String restRequest = setDowntimeAppHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(setDowntimeAppResponse, "set-downtime-app", restRequest, host, true);
    }

    @Override
    public LifecycleResult clearDowntimeApp(String application, String component, String host, String tenant) throws Exception {
        if ((host = DeployClientUtils.prepareAndValidateHostString(host)).endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (component == null || component.length() == 0) {
            component = DEFAULT_COMPONENT;
        }
        StringBuilder clearDowntimeAppRequest = new StringBuilder(512);
        clearDowntimeAppRequest.append(host).append('/').append("domain_basic").append('/');
        clearDowntimeAppRequest.append("spaces").append('/').append(this.jpSpaceName).append('/');
        clearDowntimeAppRequest.append("appliances").append('/').append(application).append('/');
        clearDowntimeAppRequest.append("components").append('/').append(component);
        if (tenant != null && tenant.length() > 0) {
            clearDowntimeAppRequest.append('/').append("tenants").append('/').append(tenant);
        }
        String clearDowntimeAppOperationJsonBody = "{\"actions\":[\"" + ApplicationAction.CLEAR_DOWNTIME_APP + "\"]}";
        HttpPut clearDowntimeAppHttpPutRequest = new HttpPut(clearDowntimeAppRequest.toString());
        clearDowntimeAppHttpPutRequest.setEntity((HttpEntity)new StringEntity(clearDowntimeAppOperationJsonBody, APPLICATION_JSON, UTF8));
        if (LOGGER.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder(256);
            debugMessage.append("Clearing downtime application for ");
            this.appendAppIdentifierText(debugMessage, application, component, tenant);
            LOGGER.debug((Object)debugMessage.toString());
        }
        HttpResponse clearDowntimeAppResponse = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)clearDowntimeAppHttpPutRequest, "1.0");
        String restRequest = clearDowntimeAppHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(clearDowntimeAppResponse, "clear-downtime-app", restRequest, host, false);
    }

    private void appendAppIdentifierText(StringBuilder debugMessage, String application, String component, String tenant) {
        if (!DEFAULT_COMPONENT.equalsIgnoreCase(component)) {
            debugMessage.append("component [").append(component).append("] of ");
        }
        debugMessage.append("application [").append(application).append("] in account [").append(this.jpSpaceName).append(']');
        if (tenant != null && tenant.length() > 0) {
            debugMessage.append(" for tenant [").append(tenant).append(']');
        }
    }

    @Override
    public LifecycleResult restart(String application, String component, String componentVersion, String host, String tenant, int waitTime, IProgressListener listener) throws Exception {
        Restarter restarter = new Restarter(this);
        return restarter.restart(application, component, componentVersion, host, tenant, waitTime, listener);
    }

    @Override
    public LifecycleResult restart(String application, String component, String componentVersion, String host, String tenant, int waitTime, IProgressListener listener, IRestartStrategy.RestartStrategy strategy) throws Exception {
        Restarter restarter = new Restarter(strategy, this);
        return restarter.restart(application, component, componentVersion, host, tenant, waitTime, listener);
    }

    @Override
    public IRestartStrategy.RestartStrategy getDefaultRestartStrategy() {
        return Restarter.getDefaultRestartStrategy();
    }

    @Override
    public LifecycleResult enable(String application, String component, String host, String tenant) throws Exception {
        TargetApplicationState targetApplicationState = new TargetApplicationState(null, LoadBalancerStateEnum.ENABLED, tenant);
        return this.doEnableOrDisableApplication(application, component, host, tenant, Operations.ENABLE, targetApplicationState);
    }

    @Override
    public LifecycleResult enable(String applicationProcessId, String host) throws Exception {
        return this.doEnableOrDisable(applicationProcessId, host, LoadBalancerStateEnum.ENABLED);
    }

    private LifecycleResult doEnableOrDisableApplication(String application, String component, String host, String tenant, Operations operation, TargetApplicationState targetAppState) throws Exception {
        EnableDisableApplicationClient newRESTCLient = this.createEnableDisableApplicationStateClient(application, host = this.prepareAndValidateHost(host), targetAppState);
        if (newRESTCLient.usePublicRest(component)) {
            return newRESTCLient.doUpdate(this.httpClient);
        }
        return this.doEnableOrDisableApplicationViaOldREST(application, component, host, tenant, operation);
    }

    protected EnableDisableApplicationClient createEnableDisableApplicationStateClient(String application, String host, TargetApplicationState targetAppState) {
        return new EnableDisableApplicationClient(this.jpSpaceName, application, host, targetAppState, this.agentName, this.agentVersion);
    }

    protected LifecycleResult doEnableOrDisableApplicationViaOldREST(String application, String component, String host, String tenant, Operations operation) throws Exception {
        HttpEntity entity = this.createActionResource(operation);
        if (application == null) {
            throw new IllegalArgumentException("Application name must not be null.");
        }
        if (host.endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        StringBuilder actionRequest = new StringBuilder(256);
        actionRequest.append(host);
        actionRequest.append('/').append("domain_basic");
        actionRequest.append('/').append("spaces");
        actionRequest.append('/').append(this.jpSpaceName);
        actionRequest.append('/').append("appliances").append('/').append(application);
        actionRequest.append('/').append("components").append('/').append(component);
        if (tenant != null && tenant.length() > 0) {
            actionRequest.append('/').append("tenants").append('/').append(tenant);
        }
        HttpPut actionHttpPutRequest = new HttpPut(actionRequest.toString());
        actionHttpPutRequest.setEntity(entity);
        if (LOGGER.isDebugEnabled()) {
            String action = String.valueOf(operation.name().substring(0, 1)) + operation.name().substring(1).toLowerCase();
            String debugMessage = component != null ? String.valueOf(action) + " component [" + component + "] of application [" + application + "] in account [ " + this.jpSpaceName + ']' : String.valueOf(action) + " application [" + application + "] in account [" + this.jpSpaceName + ']';
            LOGGER.debug((Object)debugMessage);
        }
        HttpResponse actionResponse = NetworkUtils.executeRequestAndFollowRedirect(this.httpClient, (HttpRequestBase)actionHttpPutRequest, "1.0", 2, 2);
        String restRequest = actionHttpPutRequest.getRequestLine().toString();
        return ResultBuilder.buildLifecycleResult(actionResponse, operation.name().toLowerCase(), restRequest, host, true);
    }

    private LifecycleResult doEnableOrDisable(String applicationProcessId, String host, LoadBalancerStateEnum targetLBState) throws Exception {
        host = this.prepareAndValidateHost(host);
        TargetProcessState targetProcessState = new TargetProcessState(targetLBState);
        EnableDisableProcessClient client = this.createEnableDisableProcessClient(applicationProcessId, host, targetProcessState);
        return ((UpdateProcessStateClient)client).doUpdate(this.httpClient);
    }

    protected EnableDisableProcessClient createEnableDisableProcessClient(String applicationProcessId, String host, TargetProcessState targetProcessState) {
        return new EnableDisableProcessClient(applicationProcessId, host, targetProcessState, this.agentName, this.agentVersion);
    }

    private HttpEntity createActionResource(Operations operation) throws UnsupportedEncodingException {
        Gson gson = new Gson();
        ActionResource actionResource = new ActionResource();
        actionResource.setActions(new String[]{operation.toString().toLowerCase()});
        String jsonBody = gson.toJson((Object)actionResource);
        StringEntity entity = new StringEntity(jsonBody.toString(), APPLICATION_JSON, UTF8);
        return entity;
    }

    protected String prepareAndValidateHost(String host) {
        return DeployClientUtils.prepareAndValidateHostString(host);
    }
}

