/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.impl.DeployFeedbackHelper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MeasuringInputStream
extends FilterInputStream {
    private DeployFeedbackHelper feedbackHelper;
    boolean notifyUploadFinished = false;

    public MeasuringInputStream(InputStream is, DeployFeedbackHelper feedbackHelper, boolean notifyUploadFinished) {
        super(is);
        this.feedbackHelper = feedbackHelper;
        this.notifyUploadFinished = notifyUploadFinished;
    }

    @Override
    public synchronized int read() throws IOException {
        int read = super.read();
        if (read == -1) {
            if (this.notifyUploadFinished) {
                this.feedbackHelper.uploadFinished();
            }
        } else {
            this.feedbackHelper.bytesUploaded(1);
        }
        return read;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read == -1) {
            if (this.notifyUploadFinished) {
                this.feedbackHelper.uploadFinished();
            }
        } else {
            this.feedbackHelper.bytesUploaded(read);
        }
        return read;
    }
}

