/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.IRestartStrategy;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.WaitResult;
import com.sap.core.deploy.client.exceptions.RestarterException;
import com.sap.core.deploy.client.impl.PeriodicalScheduler;
import com.sap.core.deploy.client.impl.ProcessIdAvailabilityZonePair;
import com.sap.core.deploy.client.impl.RollingUpdateContext;
import com.sap.core.deploy.client.impl.StatusCheckRunnable;
import com.sap.core.deploy.client.impl.WaitRunnable;
import com.sap.core.deploy.client.progress.IProgressListener;
import com.sap.core.deploy.client.progress.OperationNotification;
import com.sap.core.deploy.client.progress.OperationProperties;
import com.sap.core.deploy.client.progress.OperationStatus;
import com.sap.core.deploy.client.progress.OperationType;
import com.sap.core.deploy.client.progress.RollingUpdateProperties;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.retry.RetryPerformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OneByOneRestartStrategy
implements IRestartStrategy {
    private static final Logger LOGGER = Logger.getLogger(OneByOneRestartStrategy.class);
    public static final int SLEEP_INTERVAL = new Integer(5000);
    public static final int START_STOP_TIMEOUT = new Integer(1800000);
    static int SLEEP_TIMEOUT_AFTER_TRIGGERED_START_OF_NEW_PROCESS = 10000;
    public static final String MISSING_PROCESS_ID = "Cannot obtain the process id of the new started application process.";
    public static final String MORE_THAN_ONE_NEW_PROCESS_IDS = "There is more than one new started application process.";
    private static final String PERFORM_OPERATION_MESSAGE = "Perform %s for application process ID [%s].";
    private static final String OPERATION_FAILED_MESSAGE = "%s of the application process ID [%s] failed: message: %s";
    private static final String OPERATION_FINISHED_MESSAGE = "%s of the application process ID [%s] performed successfully.";
    private static final String START_WAITING_MESSAGE = "Start waiting in disable state for %d seconds.";
    private static final String WAITING_FINISHED_MESSAGE = "Wait in disable state finished successfully.";
    private static final String TENANT_MESSAGE = "tenant [%s]";
    private static final String PERFORM_RESTART_MESSAGE = "Perform restart using the one by one strategy requested for application [%s] component [%s] %s.";
    private static final String RESTART_FINISHED_MESSAGE = "Restart of the application [%s] component [%s] %s finished successfully.";
    private static final String RESTART_FAILED_MESSAGE = "Restart for application [%s] component [%s] %s failed: %s";
    private static final String APPLICATION_NOT_RUNNING_MESSAGE = "Application [%s] component [%s] %s is not running.";
    private static final String APPLICATION_RUNNING_PROCESSES_MESSAGE = "Application [%s] component [%s] %s has following running processes: %s.";
    private static final String PERFORM_START_MESSAGE = "Perform start for application [%s] component [%s] %s.";
    private static final String START_FAILED_MESSAGE = "Start for application [%s] component [%s] %s failed: %s";
    private static final String NEW_STARTED_PID_AZ_MESSAGE = "The new started processId/availability zone for application [%s] component [%s] %s is %s/%s.";
    private static final String RETRYABLE_EX_TARGET_SERVER_FAILED_TO_RESPOND = "The target server failed to respond";
    private static final String RETRYABLE_EX_CONNECTION_RESET = "Connection reset";
    public static final Set<String> NETWORK_ISSUES_EXCEPTION_MESSAGES = new HashSet<String>(Arrays.asList("The target server failed to respond", "Connection reset", IOException.class.getName()));
    private final IDeployer deployer;
    RetryPerformer retryPerformer = new RetryPerformer(NETWORK_ISSUES_EXCEPTION_MESSAGES);
    private RollingUpdateProperties privateProperties = new RollingUpdateProperties(null, null, 0L);

    public OneByOneRestartStrategy(IDeployer deployer) {
        this.deployer = deployer;
    }

    @Override
    public LifecycleResult execute(String application, String component, String componentVersion, String host, String tenant, long waitTime, IProgressListener listener) throws Exception {
        block16: {
            try {
                ApplicationProcessResource[] oldRunningProcesses;
                StatusResult statusResult;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(PERFORM_RESTART_MESSAGE, application, component, this.getTenantMessage(tenant)));
                }
                if ((statusResult = (StatusResult)this.retryPerformer.retry((Object)this.deployer, "getStatus", new Object[]{application, component, componentVersion, host, tenant})).getCode() != 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)String.format(RESTART_FAILED_MESSAGE, application, component, this.getTenantMessage(tenant), statusResult.getMessage()));
                    }
                    return new LifecycleResult(statusResult);
                }
                ArrayList<String> oldRunningProcessIds = new ArrayList<String>();
                if (Status.STOPPED.equals((Object)statusResult.getStatus())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)String.format(APPLICATION_NOT_RUNNING_MESSAGE, application, component, this.getTenantMessage(tenant)));
                    }
                    this.startNewProcessId(application, component, componentVersion, host, tenant, listener, oldRunningProcessIds);
                    return new LifecycleResult(0, Status.STARTED);
                }
                RollingUpdateContext rollingUpdateContext = new RollingUpdateContext();
                ApplicationProcessResource[] applicationProcessResourceArray = oldRunningProcesses = statusResult.getApplicationProcesses();
                int n = oldRunningProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    ApplicationProcessResource process = applicationProcessResourceArray[n2];
                    oldRunningProcessIds.add(process.getProcessId());
                    rollingUpdateContext.addOldRunningProcess(new ProcessIdAvailabilityZonePair(process.getProcessId(), process.getAvailabilityZone()));
                    ++n2;
                }
                ArrayList<String> currentlyRunningProcessIds = new ArrayList<String>();
                currentlyRunningProcessIds.addAll(oldRunningProcessIds);
                this.privateProperties.setOldProccessesRunning(currentlyRunningProcessIds.size());
                this.privateProperties.setTotalProccessesRunning(currentlyRunningProcessIds.size());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(APPLICATION_RUNNING_PROCESSES_MESSAGE, application, component, this.getTenantMessage(tenant), currentlyRunningProcessIds));
                }
                ProcessIdAvailabilityZonePair lastStartedProcessIdAzPair = null;
                while (rollingUpdateContext.hasMoreProcessesToStop()) {
                    ProcessIdAvailabilityZonePair processIdAzPair = this.startNewProcessId(application, component, componentVersion, host, tenant, listener, currentlyRunningProcessIds);
                    rollingUpdateContext.addNewRunningProcess(processIdAzPair);
                    lastStartedProcessIdAzPair = processIdAzPair;
                    String processIdToStop = rollingUpdateContext.getProcessIdToStop();
                    try {
                        this.disableProcessId(processIdToStop, host, listener);
                        this.privateProperties.incrementOldProccessesDisabled();
                        this.retryPerformer.retry((Object)this, "waitInDisableState", new Object[]{waitTime, listener});
                        this.privateProperties.decrementOldProccessesDisabled();
                    }
                    catch (RestarterException e) {
                        LOGGER.error((Object)"VM state is not started. Proceed with stopping it", (Throwable)e);
                    }
                    this.stopProcessId(application, component, processIdToStop, host, listener);
                    currentlyRunningProcessIds.add(processIdAzPair.getProcessId());
                    currentlyRunningProcessIds.remove(processIdToStop);
                }
                if (!rollingUpdateContext.isHABroken()) break block16;
                this.startNewProcessId(application, component, componentVersion, host, tenant, listener, currentlyRunningProcessIds);
                if (lastStartedProcessIdAzPair == null) {
                    throw new RestarterException("The last process failed to start properly!");
                }
                try {
                    this.disableProcessId(lastStartedProcessIdAzPair.getProcessId(), host, listener);
                    this.privateProperties.incrementOldProccessesDisabled();
                    this.retryPerformer.retry((Object)this, "waitInDisableState", new Object[]{waitTime, listener});
                    this.privateProperties.decrementOldProccessesDisabled();
                }
                catch (RestarterException e) {
                    LOGGER.error((Object)"VM state is not started. Proceed with stopping it", (Throwable)e);
                }
                this.stopProcessId(application, component, lastStartedProcessIdAzPair.getProcessId(), host, listener);
                currentlyRunningProcessIds.add(lastStartedProcessIdAzPair.getProcessId());
                currentlyRunningProcessIds.remove(lastStartedProcessIdAzPair.getProcessId());
            }
            catch (RestarterException e) {
                return e.getLifecycleResult();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(RESTART_FINISHED_MESSAGE, application, component, this.getTenantMessage(tenant)));
        }
        return new LifecycleResult(0, Status.STARTED);
    }

    private ProcessIdAvailabilityZonePair startNewProcessId(String application, String component, String componentVersion, String host, String tenant, IProgressListener listener, ArrayList<String> currentlyRunningProcessIds) throws Exception {
        ProcessIdAvailabilityZonePair newStartedProcessIdAZPair;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(PERFORM_START_MESSAGE, application, component, this.getTenantMessage(tenant)));
        }
        long startOperationStartTime = System.currentTimeMillis();
        LifecycleResult startResult = (LifecycleResult)this.retryPerformer.retry((Object)this.deployer, "start", new Object[]{application, component, componentVersion, host, tenant});
        this.privateProperties.incrementNewProccessesStarting();
        this.sendStartNotification(listener, OperationType.START, null, startResult);
        if (startResult.getCode() != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(START_FAILED_MESSAGE, application, component, this.getTenantMessage(tenant), startResult.getMessage()));
            }
            throw new RestarterException(startResult);
        }
        Thread.sleep(SLEEP_TIMEOUT_AFTER_TRIGGERED_START_OF_NEW_PROCESS);
        StatusResult status = (StatusResult)this.retryPerformer.retry((Object)this.deployer, "getStatus", new Object[]{application, component, componentVersion, host, tenant});
        try {
            newStartedProcessIdAZPair = this.findNewStartedProcessIdAZPair(status, currentlyRunningProcessIds);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(NEW_STARTED_PID_AZ_MESSAGE, application, component, this.getTenantMessage(tenant), newStartedProcessIdAZPair.getProcessId(), newStartedProcessIdAZPair.getAvailabilityZone()));
            }
        }
        catch (ProcessIdError e) {
            this.sendFailedNotification(listener, OperationType.START, null, status, startOperationStartTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(START_FAILED_MESSAGE, application, component, this.getTenantMessage(tenant), e.getMessage()));
            }
            throw new RestarterException(new LifecycleResult(1, e.getMessage()));
        }
        StatusResult newVmStartedResult = this.waitForStatus(newStartedProcessIdAZPair.getProcessId(), host, Status.STARTED, listener, OperationType.START, startOperationStartTime);
        if (newVmStartedResult.getCode() != 0) {
            this.sendFailedNotification(listener, OperationType.START, newStartedProcessIdAZPair.getProcessId(), newVmStartedResult, startOperationStartTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(START_FAILED_MESSAGE, application, component, this.getTenantMessage(tenant), newVmStartedResult.getMessage()));
            }
            throw new RestarterException(new LifecycleResult(newVmStartedResult));
        }
        this.privateProperties.decrementNewProccessesStarting();
        this.privateProperties.incrementNewProccessesRunning();
        this.sendFinishedNotification(listener, OperationType.START, newStartedProcessIdAZPair.getProcessId(), newVmStartedResult, startOperationStartTime);
        LOGGER.debug((Object)String.format(OPERATION_FINISHED_MESSAGE, "Start", newStartedProcessIdAZPair.getProcessId()));
        return newStartedProcessIdAZPair;
    }

    private void stopProcessId(String application, String component, String processId, String host, IProgressListener listener) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(PERFORM_OPERATION_MESSAGE, "stop", processId));
        }
        long stopOperationStartTime = System.currentTimeMillis();
        LifecycleResult stopResult = (LifecycleResult)this.retryPerformer.retry((Object)this.deployer, "stopProcess", new Object[]{application, component, processId, host});
        this.privateProperties.decrementOldProccessesRunning();
        this.privateProperties.incrementOldProccessesStopping();
        this.sendStartNotification(listener, OperationType.STOP, processId, stopResult);
        if (stopResult.getCode() != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(OPERATION_FAILED_MESSAGE, "Stop", processId, stopResult.getMessage()));
            }
            throw new RestarterException(stopResult);
        }
        StatusResult oldVmStopeddResult = this.waitForStatus(processId, host, Status.NOT_FOUND, listener, OperationType.STOP, stopOperationStartTime);
        if (oldVmStopeddResult.getCode() != 0 && !Status.NOT_FOUND.equals((Object)oldVmStopeddResult.getStatus())) {
            this.sendFailedNotification(listener, OperationType.STOP, processId, oldVmStopeddResult, stopOperationStartTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(OPERATION_FAILED_MESSAGE, "Stop", processId, oldVmStopeddResult.getMessage()));
            }
            throw new RestarterException(new LifecycleResult(oldVmStopeddResult));
        }
        this.privateProperties.decrementOldProccessesStopping();
        this.sendFinishedNotification(listener, OperationType.STOP, processId, oldVmStopeddResult, stopOperationStartTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(OPERATION_FINISHED_MESSAGE, "Stop", processId));
        }
    }

    private void disableProcessId(String processId, String host, IProgressListener listener) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(PERFORM_OPERATION_MESSAGE, "disable", processId));
        }
        long disableOperationStartTime = System.currentTimeMillis();
        LifecycleResult disableResult = (LifecycleResult)this.retryPerformer.retry((Object)this.deployer, "disable", new Object[]{processId, host});
        if (disableResult.getCode() != 0) {
            this.sendFailedNotification(listener, OperationType.DISABLE, processId, disableResult, disableOperationStartTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(OPERATION_FAILED_MESSAGE, "Disable", processId, disableResult.getMessage()));
            }
            throw new RestarterException(disableResult);
        }
        this.sendFinishedNotification(listener, OperationType.DISABLE, processId, disableResult, disableOperationStartTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(OPERATION_FINISHED_MESSAGE, "Disable", processId));
        }
    }

    public void waitInDisableState(long waitTime, IProgressListener listener) throws RestarterException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(START_WAITING_MESSAGE, waitTime));
        }
        long waitOperationStartTime = System.currentTimeMillis();
        RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.privateProperties.clone();
        clonedProperties.put("WAITING_TIME", waitTime);
        this.sendStartNotification(listener, OperationType.WAIT, clonedProperties);
        WaitRunnable runnable = new WaitRunnable(listener, waitOperationStartTime, waitTime, clonedProperties);
        PeriodicalScheduler<WaitResult> scheduler = new PeriodicalScheduler<WaitResult>(runnable);
        scheduler.startExecution(SLEEP_INTERVAL, START_STOP_TIMEOUT);
        WaitResult waitResult = scheduler.waitForFinishing();
        clonedProperties.setExecutionTime(System.currentTimeMillis() - waitOperationStartTime);
        clonedProperties.put("WAITING_TIME", waitTime);
        if (waitResult.getCode() != 0) {
            this.sendFailedNotification(listener, OperationType.WAIT, clonedProperties);
            throw new RestarterException(new LifecycleResult(waitResult));
        }
        this.sendFinishedNotification(listener, OperationType.WAIT, clonedProperties);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)WAITING_FINISHED_MESSAGE);
        }
    }

    private StatusResult waitForStatus(String newStartedProcessId, String host, Status wantedStatus, IProgressListener listener, OperationType type, long operationStartedTime) {
        RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.privateProperties.clone();
        clonedProperties.setProcessId(newStartedProcessId);
        StatusCheckRunnable runnable = new StatusCheckRunnable(this.deployer, newStartedProcessId, host, wantedStatus, listener, type, operationStartedTime, clonedProperties, this.retryPerformer);
        PeriodicalScheduler<StatusResult> scheduler = new PeriodicalScheduler<StatusResult>(runnable);
        scheduler.startExecution(SLEEP_INTERVAL, START_STOP_TIMEOUT);
        return scheduler.waitForFinishing();
    }

    private void sendStartNotification(IProgressListener listener, OperationType type, String processId, Result result) {
        if (listener != null) {
            RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.privateProperties.clone();
            clonedProperties.setProcessId(processId);
            clonedProperties.setOperationResult(result);
            OperationNotification notification = new OperationNotification(type, OperationStatus.STARTED, clonedProperties);
            listener.onOperationNotification(notification);
        }
    }

    private void sendStartNotification(IProgressListener listener, OperationType type, OperationProperties properties) {
        if (listener != null) {
            OperationNotification notification = new OperationNotification(type, OperationStatus.STARTED, properties);
            listener.onOperationNotification(notification);
        }
    }

    private void sendFinishedNotification(IProgressListener listener, OperationType type, String processId, Result result, long startedTime) {
        if (listener != null) {
            RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.privateProperties.clone();
            clonedProperties.setProcessId(processId);
            clonedProperties.setOperationResult(result);
            clonedProperties.setExecutionTime(System.currentTimeMillis() - startedTime);
            OperationNotification notification = new OperationNotification(type, OperationStatus.FINISHED, clonedProperties);
            listener.onOperationNotification(notification);
        }
    }

    private void sendFinishedNotification(IProgressListener listener, OperationType type, OperationProperties properties) {
        if (listener != null) {
            OperationNotification notification = new OperationNotification(type, OperationStatus.FINISHED, properties);
            listener.onOperationNotification(notification);
        }
    }

    private void sendFailedNotification(IProgressListener listener, OperationType type, String processId, Result result, long startedTime) {
        if (listener != null) {
            RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.privateProperties.clone();
            clonedProperties.setProcessId(processId);
            clonedProperties.setOperationResult(result);
            clonedProperties.setExecutionTime(System.currentTimeMillis() - startedTime);
            OperationNotification notification = new OperationNotification(type, OperationStatus.FAILED, clonedProperties);
            listener.onOperationNotification(notification);
        }
    }

    private void sendFailedNotification(IProgressListener listener, OperationType type, OperationProperties properties) {
        if (listener != null) {
            OperationNotification notification = new OperationNotification(type, OperationStatus.FAILED, properties);
            listener.onOperationNotification(notification);
        }
    }

    private ProcessIdAvailabilityZonePair findNewStartedProcessIdAZPair(StatusResult statusResult, ArrayList<String> runningProcessIds) throws ProcessIdError {
        ApplicationProcessResource[] processes;
        boolean found = false;
        ProcessIdAvailabilityZonePair processIdAZPair = null;
        ApplicationProcessResource[] applicationProcessResourceArray = processes = statusResult.getApplicationProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationProcessResource process = applicationProcessResourceArray[n2];
            if (!runningProcessIds.contains(process.getProcessId())) {
                if (found) {
                    LOGGER.error((Object)String.format("There is more than one new started application process. List of old running process id: %s. List of all currently running processes: %s.", runningProcessIds, Arrays.asList(processes)));
                    throw new ProcessIdError(MORE_THAN_ONE_NEW_PROCESS_IDS);
                }
                found = true;
                processIdAZPair = new ProcessIdAvailabilityZonePair(process.getProcessId(), process.getAvailabilityZone());
            }
            ++n2;
        }
        if (!found) {
            LOGGER.error((Object)String.format("Cannot obtain the process id of the new started application process. List of old running process id: %s. List of currently running processes after the start of the new process was triggered: %s", runningProcessIds, Arrays.asList(processes)));
            throw new ProcessIdError(MISSING_PROCESS_ID);
        }
        return processIdAZPair;
    }

    private String getTenantMessage(String tenant) {
        if (tenant != null) {
            return String.format(TENANT_MESSAGE, tenant);
        }
        return "";
    }

    private class ProcessIdError
    extends Exception {
        private static final long serialVersionUID = 8221458328453118232L;

        public ProcessIdError(String message) {
            super(message);
        }
    }
}

