/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.IPeriodicalScheduledRunnable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PeriodicalScheduler<T> {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> feature;
    private T result = null;
    private IPeriodicalScheduledRunnable<T> runnable;
    private boolean timeoutReached = false;

    public PeriodicalScheduler(IPeriodicalScheduledRunnable<T> runnable) {
        this.runnable = runnable;
        runnable.setWaitScheduler(this);
    }

    public void startExecution(long executionsInterval, long stopTimeout) {
        this.feature = this.scheduler.scheduleWithFixedDelay(this.runnable, 0L, executionsInterval, TimeUnit.MILLISECONDS);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                PeriodicalScheduler.this.timeoutReached = true;
                PeriodicalScheduler.this.stop();
            }
        }, stopTimeout, TimeUnit.MILLISECONDS);
    }

    public T waitForFinishing() {
        try {
            this.feature.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException e) {
            return this.runnable.getFailedResult(e);
        }
        catch (ExecutionException e) {
            return this.runnable.getFailedResult(e);
        }
        this.result = this.timeoutReached ? this.runnable.getTimeoutResult() : this.runnable.getResult();
        return this.result;
    }

    public void stop() {
        this.feature.cancel(true);
        this.scheduler.shutdownNow();
    }
}

