/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.IRestartStrategy;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.impl.OneByOneRestartStrategy;
import com.sap.core.deploy.client.progress.IProgressListener;

public class Restarter {
    final IRestartStrategy restartStrategy;

    public Restarter(IDeployer deployer) {
        this.restartStrategy = Restarter.getDefaultStrategyInterface(deployer);
    }

    public Restarter(IRestartStrategy.RestartStrategy strategy, IDeployer deployer) {
        switch (strategy) {
            case ONE_BY_ONE: {
                this.restartStrategy = new OneByOneRestartStrategy(deployer);
                break;
            }
            default: {
                this.restartStrategy = Restarter.getDefaultStrategyInterface(deployer);
            }
        }
    }

    public LifecycleResult restart(String application, String component, String componentVersion, String host, String tenant, long waitTime, IProgressListener listener) throws Exception {
        return this.restartStrategy.execute(application, component, componentVersion, host, tenant, waitTime, listener);
    }

    public static IRestartStrategy.RestartStrategy getDefaultRestartStrategy() {
        return IRestartStrategy.RestartStrategy.ONE_BY_ONE;
    }

    private static IRestartStrategy getDefaultStrategyInterface(IDeployer deployer) {
        return new OneByOneRestartStrategy(deployer);
    }
}

