/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.impl.ProcessIdAvailabilityZonePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RollingUpdateContext {
    private static final String EMPTY_AZ = "";
    private Map<String, List<String>> oldRunningProcesses = new HashMap<String, List<String>>();
    private Map<String, List<String>> newRunningProcesses = new HashMap<String, List<String>>();

    public void addOldRunningProcess(ProcessIdAvailabilityZonePair processIdAzPair) {
        this.addRunningProcess(processIdAzPair, this.oldRunningProcesses);
    }

    public void addNewRunningProcess(ProcessIdAvailabilityZonePair processIdAzPair) {
        this.addRunningProcess(processIdAzPair, this.newRunningProcesses);
    }

    public boolean isHABroken() {
        if (!this.isMultiAZEnvironment()) {
            return false;
        }
        if (this.getNewRunningProcessCount() == 1) {
            return false;
        }
        return this.newRunningProcesses.size() == 1;
    }

    private boolean isMultiAZEnvironment() {
        HashSet<String> availabilityZones = new HashSet<String>();
        availabilityZones.addAll(this.oldRunningProcesses.keySet());
        availabilityZones.addAll(this.newRunningProcesses.keySet());
        return availabilityZones.size() > 1;
    }

    private void addRunningProcess(ProcessIdAvailabilityZonePair processIdAzPair, Map<String, List<String>> processMap) {
        List<String> processes;
        String availabilityZone = processIdAzPair.getAvailabilityZone();
        if (availabilityZone == null) {
            availabilityZone = EMPTY_AZ;
        }
        if ((processes = processMap.get(availabilityZone)) == null) {
            processes = new ArrayList<String>();
            processMap.put(availabilityZone, processes);
        }
        processes.add(processIdAzPair.getProcessId());
    }

    protected void addProcessAz(String availabilityZone, Set<String> availabilityZoneSet) {
        if (!availabilityZone.isEmpty()) {
            availabilityZoneSet.add(availabilityZone);
        }
    }

    public String getProcessIdToStop() {
        String availabilityZoneWithMinProcessCount = this.getAvailabilityZoneWithMinProcessCount();
        List<String> oldRunningProcessesForAz = this.oldRunningProcesses.get(availabilityZoneWithMinProcessCount);
        if (oldRunningProcessesForAz == null) {
            return null;
        }
        return oldRunningProcessesForAz.remove(0);
    }

    public boolean hasMoreProcessesToStop() {
        return this.getOldRunningProcessCount() != 0;
    }

    String getAvailabilityZoneWithMinProcessCount() {
        Map<String, Integer> processCountPerAvailabilityZone = this.buildProcessPerAZMap();
        int min = Integer.MAX_VALUE;
        String availabilityZoneWithMinProcessCount = null;
        for (String availabilityZone : processCountPerAvailabilityZone.keySet()) {
            Integer processCount = processCountPerAvailabilityZone.get(availabilityZone);
            if (processCount >= min) continue;
            min = processCount;
            availabilityZoneWithMinProcessCount = availabilityZone;
        }
        return availabilityZoneWithMinProcessCount;
    }

    int getOldRunningProcessCount() {
        return this.getProcessCount(this.oldRunningProcesses);
    }

    int getNewRunningProcessCount() {
        return this.getProcessCount(this.newRunningProcesses);
    }

    private int getProcessCount(Map<String, List<String>> processMap) {
        int cnt = 0;
        for (String key : processMap.keySet()) {
            List<String> processes = processMap.get(key);
            cnt += processes.size();
        }
        return cnt;
    }

    Map<String, Integer> buildProcessPerAZMap() {
        Integer processCount;
        HashMap<String, Integer> processCountPerAvailabilityZone = new HashMap<String, Integer>();
        for (String availabilityZone : this.oldRunningProcesses.keySet()) {
            processCount = this.oldRunningProcesses.get(availabilityZone).size();
            if (processCount <= 0) continue;
            processCountPerAvailabilityZone.put(availabilityZone, processCount);
        }
        for (String availabilityZone : this.newRunningProcesses.keySet()) {
            processCount = (Integer)processCountPerAvailabilityZone.get(availabilityZone);
            if (processCount == null) continue;
            processCount = processCount + this.newRunningProcesses.get(availabilityZone).size();
            processCountPerAvailabilityZone.put(availabilityZone, processCount);
        }
        return processCountPerAvailabilityZone;
    }
}

