/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.IPeriodicalScheduledRunnable;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.exceptions.WaitForStatusException;
import com.sap.core.deploy.client.impl.PeriodicalScheduler;
import com.sap.core.deploy.client.progress.IProgressListener;
import com.sap.core.deploy.client.progress.OperationNotification;
import com.sap.core.deploy.client.progress.OperationStatus;
import com.sap.core.deploy.client.progress.OperationType;
import com.sap.core.deploy.client.progress.RollingUpdateProperties;
import com.sap.core.deploy.commons.retry.RetryPerformer;
import org.apache.log4j.Logger;

public class StatusCheckRunnable
implements IPeriodicalScheduledRunnable<StatusResult> {
    private static final Logger LOGGER = Logger.getLogger(StatusCheckRunnable.class);
    private static final String STATUS_MESSAGE_WITH_PID = "Application process ID [%s] is in status %s after %d ms";
    private static final String TIMEOUT_MESSAGE_WITH_PID = "Application process ID [%s] did not move into %s for %d ms";
    private static final String LOG_ERROR_MESSAGE_WITH_PID = "Application process ID  [%s] did not reach the status [%s] and is in status [%s].";
    private static final String LOG_CHECK_FAILED_MESSAGE_WITH_PID = "Status check failed for application process ID  [%s]: %s";
    private static final String PID_REACHED_WANTED_STATUS_MESSAGE = "Application process ID [%s] is in the wanted status %s";
    public static final int MAX_FAILED_CHECKS = 45;
    public static final int MAX_FAILED_STATUS_PINGS = 3;
    int checksFailed = 0;
    int statusPingsFailed = 0;
    private StatusResult statusResult;
    private IDeployer deployer;
    private String processId;
    private String host;
    private Status wantedStatus;
    private Status initialStatus = null;
    private IProgressListener progressListener;
    private OperationType operationType;
    private PeriodicalScheduler<StatusResult> scheduler;
    private long operationStartedTime;
    private RollingUpdateProperties properties;
    private RetryPerformer retryPerformer;

    public StatusCheckRunnable(IDeployer deployer, String processId, String host, Status wantedStatus, IProgressListener listener, OperationType type, long operationStartedTime, RollingUpdateProperties props, RetryPerformer retryPerformer) {
        this.deployer = deployer;
        this.processId = processId;
        this.host = host;
        this.wantedStatus = wantedStatus;
        this.progressListener = listener;
        this.operationType = type;
        this.operationStartedTime = operationStartedTime;
        this.properties = props;
        this.retryPerformer = retryPerformer;
    }

    @Override
    public void run() {
        try {
            boolean statusFound = this.progressCheck();
            if (statusFound) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(PID_REACHED_WANTED_STATUS_MESSAGE, new Object[]{this.processId, this.wantedStatus}));
                }
                this.scheduler.stop();
            } else {
                long elapsedTime = this.getElapsedTime();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(STATUS_MESSAGE_WITH_PID, new Object[]{this.processId, this.statusResult.getStatus(), elapsedTime}));
                }
                if (this.progressListener != null) {
                    RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.properties.clone();
                    clonedProperties.setOperationResult(this.statusResult);
                    clonedProperties.setExecutionTime(elapsedTime);
                    OperationNotification notification = new OperationNotification(this.operationType, OperationStatus.RUNNING, clonedProperties);
                    this.progressListener.onOperationNotification(notification);
                }
            }
        }
        catch (WaitForStatusException e) {
            this.statusResult = new StatusResult(e);
            this.scheduler.stop();
        }
    }

    private boolean progressCheck() throws WaitForStatusException {
        this.getCurrentStatus();
        Status currentStatus = this.statusResult.getStatus();
        if (currentStatus == null) {
            return false;
        }
        switch (currentStatus) {
            case STOPPED: {
                if (this.wantedStatus.equals((Object)Status.NOT_FOUND)) {
                    return false;
                }
            }
            case STARTED: 
            case NOT_FOUND: {
                if (this.wantedStatus.equals((Object)currentStatus)) {
                    return true;
                }
                this.checkForReachedMaxCountOfUnwantedStates(currentStatus);
                return false;
            }
            case STARTING: 
            case STOPPING: 
            case APP_SERVER_STARTED: 
            case APP_SERVER_TIMEOUT: 
            case PENDING: {
                return false;
            }
            case FAILED: {
                throw new WaitForStatusException(String.format(STATUS_MESSAGE_WITH_PID, new Object[]{this.processId, currentStatus, this.getElapsedTime()}));
            }
        }
        this.checkForReachedMaxCountOfUnwantedStates(currentStatus);
        return false;
    }

    private void getCurrentStatus() throws WaitForStatusException {
        try {
            this.statusResult = (StatusResult)this.retryPerformer.retry((Object)this.deployer, "getStatus", new Object[]{this.processId, this.host});
            if (this.initialStatus == null) {
                this.initialStatus = this.statusResult.getStatus();
            }
        }
        catch (Exception e) {
            if (this.statusPingsFailed >= 3) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(LOG_CHECK_FAILED_MESSAGE_WITH_PID, this.processId, e.getMessage()));
                }
                throw new WaitForStatusException(e);
            }
            LOGGER.error((Object)String.format(LOG_CHECK_FAILED_MESSAGE_WITH_PID, this.processId, e.getMessage()), (Throwable)e);
            ++this.statusPingsFailed;
        }
        if (this.statusResult != null && this.statusResult.getCode() != 0 && 4 != this.statusResult.getCode()) {
            if (this.statusPingsFailed >= 3) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format(LOG_CHECK_FAILED_MESSAGE_WITH_PID, this.processId, this.statusResult.getMessage()));
                }
                throw new WaitForStatusException(this.statusResult);
            }
            LOGGER.error((Object)String.format(LOG_CHECK_FAILED_MESSAGE_WITH_PID, this.processId, String.valueOf(this.statusResult.getCode()) + " : " + this.statusResult.getMessage()));
            ++this.statusPingsFailed;
        }
    }

    private void checkForReachedMaxCountOfUnwantedStates(Status currentStatus) throws WaitForStatusException {
        if (this.checksFailed >= 45) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format(LOG_ERROR_MESSAGE_WITH_PID, new Object[]{this.processId, this.wantedStatus, currentStatus}));
            }
            throw new WaitForStatusException(String.format(STATUS_MESSAGE_WITH_PID, new Object[]{this.processId, currentStatus, this.getElapsedTime()}));
        }
        ++this.checksFailed;
    }

    private long getElapsedTime() {
        long time = System.currentTimeMillis();
        return time - this.operationStartedTime;
    }

    @Override
    public StatusResult getResult() {
        return this.statusResult;
    }

    @Override
    public StatusResult getFailedResult(Exception e) {
        if (e instanceof WaitForStatusException) {
            this.statusResult = ((WaitForStatusException)e).getStatusResult();
        }
        this.statusResult = new StatusResult(e);
        return this.statusResult;
    }

    @Override
    public StatusResult getTimeoutResult() {
        this.statusResult = new StatusResult(new WaitForStatusException(String.format(TIMEOUT_MESSAGE_WITH_PID, new Object[]{this.processId, this.wantedStatus, this.getElapsedTime()})));
        return this.statusResult;
    }

    @Override
    public void setWaitScheduler(PeriodicalScheduler<StatusResult> scheduler) {
        this.scheduler = scheduler;
    }
}

