/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl;

import com.sap.core.deploy.client.IPeriodicalScheduledRunnable;
import com.sap.core.deploy.client.WaitResult;
import com.sap.core.deploy.client.impl.PeriodicalScheduler;
import com.sap.core.deploy.client.progress.IProgressListener;
import com.sap.core.deploy.client.progress.OperationNotification;
import com.sap.core.deploy.client.progress.OperationStatus;
import com.sap.core.deploy.client.progress.OperationType;
import com.sap.core.deploy.client.progress.RollingUpdateProperties;
import java.util.concurrent.TimeUnit;

public class WaitRunnable
implements IPeriodicalScheduledRunnable<WaitResult> {
    private PeriodicalScheduler<WaitResult> scheduler;
    private IProgressListener progressListener;
    private long startedTime;
    private long waitTime;
    RollingUpdateProperties properties;
    private WaitResult result = null;

    public WaitRunnable(IProgressListener listener, long startedTime, long waitTime, RollingUpdateProperties props) {
        this.progressListener = listener;
        this.startedTime = startedTime;
        this.waitTime = TimeUnit.MILLISECONDS.convert(waitTime, TimeUnit.SECONDS);
        this.properties = props;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        if (time - this.startedTime >= this.waitTime) {
            this.result = new WaitResult(0);
            this.scheduler.stop();
        } else if (this.progressListener != null) {
            RollingUpdateProperties clonedProperties = (RollingUpdateProperties)this.properties.clone();
            clonedProperties.setExecutionTime(time - this.startedTime);
            OperationNotification notification = new OperationNotification(OperationType.WAIT, OperationStatus.RUNNING, clonedProperties);
            this.progressListener.onOperationNotification(notification);
        }
    }

    @Override
    public WaitResult getResult() {
        return this.result;
    }

    @Override
    public WaitResult getFailedResult(Exception e) {
        return new WaitResult(e);
    }

    @Override
    public WaitResult getTimeoutResult() {
        return new WaitResult(1, "Waiting operation reached timeout.");
    }

    @Override
    public void setWaitScheduler(PeriodicalScheduler<WaitResult> scheduler) {
        this.scheduler = scheduler;
    }
}

