/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.sap.core.deploy.client.publicrest.exceptions.DeployPublicRestException;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.RequestPreparationFactory;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public abstract class BasicRequest {
    private static final Logger LOGGER = Logger.getLogger(BasicRequest.class);
    private static final String VERSION_PROPERTY_KEY = "version";
    private static final String VERSION_PROPERTIES_FILE_NAME = "version.properties";
    protected String csrfToken;
    protected String accountName;
    protected String applicationName;
    protected String host;
    protected HttpClient httpClient;
    protected String agentName;
    protected String agentVersion;
    protected String version = null;

    protected BasicRequest(String accountName, String applicationName, String host, HttpClient httpClient, String csrfToken, String agentName, String agentVersion) {
        this.accountName = accountName;
        this.applicationName = applicationName;
        this.host = host;
        this.httpClient = httpClient;
        this.csrfToken = csrfToken;
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    public HttpResponse executeRequest() throws IOException {
        HttpRequestBase request = this.getRequestPreparationFactory().prepareRequest(this.getRequestMethodName(), this.getRequestUrl(), (HttpEntity)this.getRequestEntity(), this.getHeaders());
        HttpResponse response = this.getNetworkUtils().executeRequestAndFollowRedirectNonStatic(this.httpClient, request, 2, 2);
        return response;
    }

    public NetworkUtils getNetworkUtils() {
        return NetworkUtils.getInstance();
    }

    public RequestPreparationFactory getRequestPreparationFactory() {
        return RequestPreparationFactory.getInstance();
    }

    protected Header[] getHeaders() throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("X-CSRF-Token", this.csrfToken), new BasicHeader("X-User-Agent", this.agentName == null ? "Deploy Client" : this.agentName), new BasicHeader("X-Client-Version", this.agentVersion == null ? this.getVersion("/version.properties", VERSION_PROPERTY_KEY) : this.agentVersion)};
        return headers;
    }

    public String getVersion(String propertyFileName, String versionKey) throws IOException {
        if (this.version == null) {
            this.version = this.retrieveDeployClientVersion(propertyFileName, versionKey);
        }
        return this.version;
    }

    private String retrieveDeployClientVersion(String propertyFileName, String versionKey) throws IOException {
        try (InputStream in = null;){
            in = this.getClass().getResourceAsStream(propertyFileName);
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                in.close();
                String version = properties.getProperty(versionKey);
                if (version != null) {
                    String string = version;
                    return string;
                }
            }
        }
        throw new IllegalStateException("Unable to retrieve deploy client version");
    }

    protected void processExceptionalCase(HttpResponse response) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        LOGGER.error((Object)("Exception occured: " + responseString));
        String message = null;
        try {
            ExceptionResponse responseEntity = (ExceptionResponse)new Gson().fromJson(responseString, ExceptionResponse.class);
            message = responseEntity != null ? responseEntity.getDescription() : null;
        }
        catch (JsonParseException e) {
            message = "Unexpected response from server. Error parsing response body.";
            LOGGER.error((Object)("Unexpected response from server. Error parsing response body. Extracted response body is: " + responseString), (Throwable)e);
        }
        throw new DeployPublicRestException(response, message);
    }

    protected abstract String getRequestMethodName();

    protected abstract String getRequestUrl();

    protected abstract AbstractHttpEntity getRequestEntity() throws IOException;

    protected abstract int getSuccessfullResponseCode();
}

