/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.sap.core.deploy.commons.rest.entity.enumerations.FileStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.FileResponseEntry;
import com.sap.core.deploy.commons.rest.entity.response.FileResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DeltaDeployAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(DeltaDeployAnalyzer.class);
    private double sizeRatio = 0.5;

    public DeltaDeployAnalyzer() {
    }

    public DeltaDeployAnalyzer(double sizeRatio) {
        this.sizeRatio = sizeRatio;
    }

    public DeltaLevel analyze(FileResponse fileResponse) {
        List entries = fileResponse.getEntries();
        if (entries == null || entries.isEmpty() || fileResponse.getSize() == null) {
            return DeltaLevel.LevelOne;
        }
        List<Long> sizes = this.calculateSizes(entries);
        Long totalSize = sizes.get(0);
        Long changeCumulativeSize = sizes.get(1);
        return this.calculateLevelBasedOnSize(totalSize, changeCumulativeSize);
    }

    private DeltaLevel calculateLevelBasedOnSize(Long binarySize, Long changeCumulativeSize) {
        if (changeCumulativeSize == null) {
            return DeltaLevel.LevelOne;
        }
        return (double)binarySize.longValue() * this.sizeRatio < (double)changeCumulativeSize.longValue() ? DeltaLevel.LevelOne : DeltaLevel.LevelTwo;
    }

    private List<Long> calculateSizes(List<FileResponseEntry> entries) {
        long changeCumulativeSize = 0L;
        long totalSize = 0L;
        ArrayList<Long> sizes = new ArrayList<Long>();
        for (FileResponseEntry entry : entries) {
            Long entrySize = entry.getSize();
            if (entrySize == null) {
                LOGGER.error((Object)("Null size for entry: " + entry.getPath()));
                continue;
            }
            totalSize += entry.getSize().longValue();
            if (entry.getAvailabilityState() != FileStateEnum.UNAVAILABLE) continue;
            changeCumulativeSize += entry.getSize().longValue();
        }
        sizes.add(totalSize);
        sizes.add(changeCumulativeSize);
        return sizes;
    }

    public static enum DeltaLevel {
        LevelOne,
        LevelTwo;

    }
}

