/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.impl.requests.RequestUtil;
import com.sap.core.deploy.client.impl.requests.RestRequest;
import com.sap.core.deploy.commons.rest.entity.request.ApplicationRequest;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.deploy.commons.rest.entity.response.Metadata;
import com.sap.core.deploy.commons.rest.entity.response.Response;
import com.sap.core.jpaasrepository.api.Descriptor;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public abstract class MakeApplication
extends RestRequest<ApplicationResponse> {
    protected Descriptor descriptor;

    public MakeApplication(String accountName, String applicationName, Descriptor descriptor, String host, HttpClient httpClient, String csrfToken, String agentName, String agentVersion) {
        super(accountName, applicationName, host, httpClient, csrfToken, agentName, agentVersion);
        this.descriptor = descriptor;
    }

    @Override
    protected AbstractHttpEntity getRequestEntity() throws IOException {
        ApplicationRequest applicationRequest = RequestUtil.getInstance().getApplicationRequest(this.applicationName, this.descriptor);
        String requestBodyAsString = new Gson().toJson((Object)applicationRequest);
        return new StringEntity(requestBodyAsString);
    }

    @Override
    protected ApplicationResponse getResponseEntity(HttpResponse response) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        Response responseEntity = (Response)new Gson().fromJson(responseString, new TypeToken<Response<Metadata, ApplicationResponse>>(){}.getType());
        return (ApplicationResponse)responseEntity.getEntity();
    }
}

