/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.sap.core.deploy.client.impl.requests.MakeApplication;
import com.sap.core.deploy.client.impl.requests.MakeApplicationFactory;
import com.sap.core.deploy.client.impl.requests.UpdateApplication;
import com.sap.core.deploy.client.publicrest.exceptions.DeployPublicRestException;
import com.sap.core.deploy.commons.log.StringFormatLoggerWrapper;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.jpaasrepository.api.Descriptor;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;

public class MakeApplicationExecutor {
    private static final StringFormatLoggerWrapper LOGGER = StringFormatLoggerWrapper.getLogger(MakeApplicationExecutor.class);
    private String accountName;
    private String applicationName;
    private Descriptor descriptor;
    private String host;
    private HttpClient httpClient;
    private String csrfToken;
    private MakeApplicationFactory factory;
    private String agentName;
    private String agentVersion;

    public MakeApplicationExecutor(String accountName, String applicationName, Descriptor descriptor, String host, HttpClient httpClient, String csrfToken, MakeApplicationFactory factory, String agentName, String agentVersion) {
        this.accountName = accountName;
        this.applicationName = applicationName;
        this.descriptor = descriptor;
        this.host = host;
        this.httpClient = httpClient;
        this.csrfToken = csrfToken;
        this.factory = factory;
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    public ApplicationResponse executeMakeApplicationRequest(boolean applicationExists) throws IOException {
        MakeApplication makeApplication = this.factory.getMakeApplicationInstance(applicationExists, this.accountName, this.applicationName, this.descriptor, this.host, this.httpClient, this.csrfToken, this.agentName, this.agentVersion);
        ApplicationResponse applicationResponse = null;
        try {
            applicationResponse = (ApplicationResponse)makeApplication.sendRequest();
        }
        catch (DeployPublicRestException e) {
            makeApplication = this.correctRequestIfNeeded(makeApplication, e);
            applicationResponse = (ApplicationResponse)makeApplication.sendRequest();
            LOGGER.info("Retry request executed successfully", new Object[0]);
        }
        return applicationResponse;
    }

    private MakeApplication correctRequestIfNeeded(MakeApplication originalMakeAppRequest, DeployPublicRestException e) throws IOException {
        HttpResponse httpResponse = e.getHttpResponse();
        if (this.tryingToUpdateNotExistingApplication(originalMakeAppRequest, httpResponse)) {
            LOGGER.info("UpdateApplication request failed with response code 404 and error message [%s]. The application %s/%s may not exist (see NGPBUG-16650). Will re-attempt deployment with CreateApplication request", new Object[]{e.getErrorMessage(), this.accountName, this.applicationName});
            return this.factory.getMakeApplicationInstance(false, this.accountName, this.applicationName, this.descriptor, this.host, this.httpClient, this.csrfToken, this.agentName, this.agentVersion);
        }
        throw e;
    }

    private boolean tryingToUpdateNotExistingApplication(MakeApplication originalMakeAppRequest, HttpResponse httpResponse) {
        return originalMakeAppRequest instanceof UpdateApplication && httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 404;
    }
}

