/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.google.gson.Gson;
import com.sap.core.deploy.client.impl.DeployFeedbackHelper;
import com.sap.core.deploy.client.impl.MeasuringInputStream;
import com.sap.core.deploy.client.impl.requests.ProcessBinary;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.commons.rest.entity.enumerations.FileStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.DeltaDescriptor;
import com.sap.core.deploy.commons.rest.entity.request.FileEntry;
import com.sap.core.deploy.commons.rest.entity.request.FileResponseEntry;
import com.sap.core.deploy.commons.rest.entity.response.FileResponse;
import com.sap.core.deploy.commons.util.DeploymentUtils;
import com.sap.core.deploy.commons.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.log4j.Logger;

public class PatchBinary
extends ProcessBinary {
    private static final String DELTA_TEMP_DIR = "delta-temp";
    private static final Logger LOGGER = Logger.getLogger(PatchBinary.class);
    private static final int BUFFER = 65536;
    private static String temporaryDeltaDir = null;
    private String pathGuid;
    private File file;
    private FileResponse fileResponse;
    private DeployFeedbackHelper feedbackHelper;

    public PatchBinary(String accountName, String applicationName, String pathGuid, File file, FileResponse fileResponse, String host, HttpClient httpClient, String csrfToken, DeployFeedbackHelper feedbackHelper, String agentName, String agentVersion) {
        super(accountName, applicationName, host, httpClient, csrfToken, agentName, agentVersion);
        this.pathGuid = pathGuid;
        this.file = file;
        this.fileResponse = fileResponse;
        this.feedbackHelper = feedbackHelper;
    }

    @Override
    protected String getRequestMethodName() {
        return "PATCH";
    }

    @Override
    protected String getRequestUrl() {
        return String.valueOf(this.host) + "/lifecycle/v1/accounts/" + this.accountName + "/apps/" + this.applicationName + "/binaries/" + this.pathGuid;
    }

    @Override
    public AbstractHttpEntity getRequestEntity() throws IOException {
        if (!this.file.exists()) {
            return new FileEntity(this.file, "application/octet-stream");
        }
        PipedInputStream pis = this.prepareDeltaZip();
        MeasuringInputStream measuringIS = new MeasuringInputStream(pis, this.feedbackHelper, false);
        BasicHttpEntity bEntity = new BasicHttpEntity();
        bEntity.setContent((InputStream)new BufferedInputStream(measuringIS, 65536));
        bEntity.setContentType("application/octet-stream");
        return bEntity;
    }

    protected PipedInputStream prepareDeltaZip() throws IOException {
        ArrayList<FileEntry> descriptorEntriesForUpdate = new ArrayList<FileEntry>();
        ArrayList<FileEntry> descriptorEntriesForDeletion = new ArrayList<FileEntry>();
        this.populateEntries(descriptorEntriesForUpdate, descriptorEntriesForDeletion);
        PipedInputStream pis = new PipedInputStream(131072);
        PipedOutputStream pos = new PipedOutputStream();
        pis.connect(pos);
        ZipOutputStream zos = new ZipOutputStream(pos);
        zos.setLevel(0);
        this.processInParallelThread(descriptorEntriesForUpdate, descriptorEntriesForDeletion, pos, zos);
        return pis;
    }

    private void populateEntries(List<FileEntry> descriptorEntriesForUpdate, List<FileEntry> descriptorEntriesForDeletion) {
        for (FileResponseEntry fileResponseEntry : this.fileResponse.getEntries()) {
            if (fileResponseEntry.getAvailabilityState() == FileStateEnum.UNAVAILABLE || fileResponseEntry.getAvailabilityState() == FileStateEnum.FOR_UPDATE) {
                descriptorEntriesForUpdate.add(new FileEntry(fileResponseEntry.getPath(), fileResponseEntry.getSize(), fileResponseEntry.getHash()));
                continue;
            }
            if (fileResponseEntry.getAvailabilityState() != FileStateEnum.FOR_DELETE) continue;
            descriptorEntriesForDeletion.add(new FileEntry(fileResponseEntry.getPath(), fileResponseEntry.getSize(), fileResponseEntry.getHash()));
        }
    }

    private void processInParallelThread(final List<FileEntry> descriptorEntriesForUpdate, final List<FileEntry> descriptorEntriesForDeletion, final PipedOutputStream pos, final ZipOutputStream zos) {
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        DeployClientUtils.createDeltaZip(PatchBinary.this.file, zos, new DeltaDescriptor(descriptorEntriesForUpdate, descriptorEntriesForDeletion));
                    }
                    catch (Throwable e) {
                        LOGGER.error((Object)e);
                        IOUtils.closeQuietly((Closeable)pos);
                        DeploymentUtils.deleteDirectory((File)PatchBinary.getTemporaryDeltaDirAsFile());
                    }
                }
                finally {
                    DeploymentUtils.deleteDirectory((File)PatchBinary.getTemporaryDeltaDirAsFile());
                }
            }
        }.start();
    }

    protected File createDeltaDescriptorFile(String outputDir, List<FileEntry> descriptorEntriesForUpdate, List<FileEntry> descriptorEntriesForDeletion) throws FileNotFoundException, IOException {
        int bytesRead;
        DeltaDescriptor deltaDescriptor = new DeltaDescriptor(descriptorEntriesForUpdate, descriptorEntriesForDeletion);
        File deltaDescriptorFile = new File(String.valueOf(outputDir) + "/delta-descriptor.json");
        FileOutputStream outStream = new FileOutputStream(deltaDescriptorFile);
        ByteArrayInputStream initialStream = new ByteArrayInputStream(new Gson().toJson((Object)deltaDescriptor).getBytes("UTF-8"));
        byte[] buffer = new byte[65536];
        while ((bytesRead = initialStream.read(buffer)) != -1) {
            ((OutputStream)outStream).write(buffer, 0, bytesRead);
        }
        IOUtils.closeQuietly((Closeable)initialStream);
        IOUtils.closeQuietly((Closeable)outStream);
        return deltaDescriptorFile;
    }

    private static File getTemporaryDeltaDirAsFile() {
        String temporaryDeltaDir = PatchBinary.getTemporaryDeltaDir();
        return new File(temporaryDeltaDir);
    }

    private static String getTemporaryDeltaDir() {
        if (temporaryDeltaDir == null) {
            String tempDir = System.getProperty("java.io.tmpdir", new File(".").getAbsolutePath());
            temporaryDeltaDir = String.valueOf(tempDir) + File.separatorChar + DELTA_TEMP_DIR;
            LOGGER.debug((Object)("Delta deploy temp dir is: " + tempDir));
            new File(temporaryDeltaDir).mkdirs();
        }
        return temporaryDeltaDir;
    }
}

