/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.sap.core.deploy.client.impl.requests.RestRequest;
import com.sap.core.deploy.commons.rest.entity.response.NoContentResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public abstract class ProcessBinary
extends RestRequest<NoContentResponse> {
    protected String warning;

    protected ProcessBinary(String accountName, String applicationName, String host, HttpClient httpClient, String csrfToken, String agentName, String agentVersion) {
        super(accountName, applicationName, host, httpClient, csrfToken, agentName, agentVersion);
    }

    @Override
    protected NoContentResponse getResponseEntity(HttpResponse response) throws IOException {
        this.setWarning(response);
        EntityUtils.consume((HttpEntity)response.getEntity());
        return NoContentResponse.INSTANCE;
    }

    private void setWarning(HttpResponse response) {
        Header[] header = response.getHeaders("Warning");
        if (header != null && header.length > 0) {
            this.warning = header[0].getValue();
            if (this.warning.length() > 2) {
                this.warning = this.warning.substring(2);
            }
        }
    }

    @Override
    protected int getSuccessfullResponseCode() {
        return 200;
    }

    @Override
    protected Header[] getHeaders() throws IOException {
        Header[] headers = super.getHeaders();
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getName().equals("Content-Type")) {
                headers[i] = new BasicHeader("Content-Type", "application/octet-stream");
            }
            ++i;
        }
        return headers;
    }

    public String getWarning() {
        return this.warning;
    }
}

