/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.commons.rest.entity.PermStorage;
import com.sap.core.deploy.commons.rest.entity.RuntimeArgument;
import com.sap.core.deploy.commons.rest.entity.request.ApplicationRequest;
import com.sap.core.deploy.commons.rest.entity.request.BinariesRequest;
import com.sap.core.deploy.commons.rest.entity.request.FileRequest;
import com.sap.core.deploy.commons.util.FileRequestFactory;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.core.jpaasrepository.api.ElasticityData;
import com.sap.core.jpaasrepository.api.MalformedJsonElementException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RequestUtil {
    private static final RequestUtil INSTANCE = new RequestUtil();

    public static RequestUtil getInstance() {
        return INSTANCE;
    }

    private RequestUtil() {
    }

    public List<FileRequest> getFileRequest(Descriptor descriptor) throws IOException {
        String[] deploymentLocations = DeployClientUtils.getInstance().splitStringWithTrimNonStatic(descriptor.get("update_sites"), ",");
        LinkedList<FileRequest> listFiles = new LinkedList<FileRequest>();
        File[] fileArray = DeployClientUtils.getInstance().detectLocalWarFilesAndBundlesNonStatic(deploymentLocations);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (Boolean.TRUE.toString().equalsIgnoreCase(descriptor.get("delta"))) {
                listFiles.add(this.createFileRequest(file));
            } else {
                listFiles.add(new FileRequest(file.getName()));
            }
            ++n2;
        }
        return listFiles;
    }

    private FileRequest createFileRequest(File file) throws IOException {
        return FileRequestFactory.createFileRequest((File)file);
    }

    public ApplicationRequest getApplicationRequest(String applicationName, Descriptor descriptor) throws IOException {
        ApplicationRequest applicationRequest = new ApplicationRequest();
        applicationRequest.setApplicationName(applicationName);
        this.setRuntimeInfo(descriptor, applicationRequest);
        this.setShortUrl(descriptor, applicationRequest);
        this.setComputeUnitSize(descriptor, applicationRequest);
        this.setElasticityData(descriptor, applicationRequest);
        this.setPermStorage(descriptor, applicationRequest);
        this.setRuntimeArguments(descriptor, applicationRequest);
        this.setMetadata(descriptor, applicationRequest);
        this.setCustomProperties(descriptor, applicationRequest);
        BinariesRequest binariesRequest = new BinariesRequest(this.getFileRequest(descriptor));
        applicationRequest.setBinaries(binariesRequest);
        return applicationRequest;
    }

    void setCustomProperties(Descriptor descriptor, ApplicationRequest applicationRequest) {
        Map customProperties = null;
        try {
            customProperties = (Map)descriptor.getAs("customProperties", new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (MalformedJsonElementException exception) {
            throw new IllegalStateException(exception);
        }
        applicationRequest.setCustomProperties(customProperties);
    }

    private void setMetadata(Descriptor descriptor, ApplicationRequest applicationRequest) {
        Map metadataMap = null;
        try {
            metadataMap = (Map)descriptor.getAs("metadata", new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (MalformedJsonElementException e) {
            throw new IllegalStateException(e);
        }
        applicationRequest.setMetadata(metadataMap);
    }

    private void setRuntimeInfo(Descriptor descriptor, ApplicationRequest applicationRequest) {
        String runtimeName = descriptor.get("runtimeId");
        applicationRequest.setRuntimeName(runtimeName);
        String runtimeVersion = descriptor.get("runtimeVersion");
        applicationRequest.setRuntimeVersion(runtimeVersion);
    }

    protected void setShortUrl(Descriptor descriptor, ApplicationRequest applicationRequest) {
        applicationRequest.setApplicationUrl(descriptor.get("url"));
    }

    protected void setComputeUnitSize(Descriptor descriptor, ApplicationRequest applicationRequest) {
        applicationRequest.setComputeUnitSize(descriptor.get("vmSize"));
    }

    private void setElasticityData(Descriptor descriptor, ApplicationRequest applicationRequest) {
        try {
            ElasticityData elasticityData = descriptor.getAs("elasticity.data", ElasticityData.class);
            if (elasticityData != null) {
                applicationRequest.setMinProcesses(Integer.valueOf(elasticityData.getMinVmCount()));
                applicationRequest.setMaxProcesses(Integer.valueOf(elasticityData.getMaxVmCount()));
            }
        }
        catch (MalformedJsonElementException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setPermStorage(Descriptor descriptor, ApplicationRequest applicationRequest) {
        String permStorageMode = descriptor.get("perm_storage_mode");
        String permStorageSize = descriptor.get("perm_storage_size");
        String permStorageLocalPath = descriptor.get("perm_storage_local_path");
        if (permStorageMode == null || permStorageLocalPath == null) {
            return;
        }
        PermStorage permStorage = new PermStorage();
        permStorage.setMode(permStorageMode);
        permStorage.setLocalPath(permStorageLocalPath);
        permStorage.setSize(permStorageSize);
        applicationRequest.setPermStorage(permStorage);
    }

    private void setRuntimeArguments(Descriptor descriptor, ApplicationRequest applicationRequest) {
        ArrayList<RuntimeArgument> runtimeArguments = new ArrayList<RuntimeArgument>();
        runtimeArguments.add(new RuntimeArgument("jvmVersion", descriptor.get("jvmVersion")));
        runtimeArguments.add(new RuntimeArgument("vmArguments", descriptor.get("vmArguments")));
        runtimeArguments.add(new RuntimeArgument("uriEncoding", descriptor.get("URIEncoding")));
        runtimeArguments.add(new RuntimeArgument("maxThreads", descriptor.get("max_threads")));
        runtimeArguments.add(new RuntimeArgument("connectionTimeout", descriptor.get("connection_timeout")));
        runtimeArguments.add(new RuntimeArgument("compression", descriptor.get("compression")));
        runtimeArguments.add(new RuntimeArgument("compressibleMimeTypes", descriptor.get("compressable_mime_type")));
        runtimeArguments.add(new RuntimeArgument("compressionMinSize", descriptor.get("compression_min_size")));
        applicationRequest.setRuntimeArguments(runtimeArguments);
    }
}

