/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.impl.requests;

import com.sap.core.deploy.client.impl.DeployFeedbackHelper;
import com.sap.core.deploy.client.impl.MeasuringInputStream;
import com.sap.core.deploy.client.impl.requests.ProcessBinary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;

public class UpdateBinary
extends ProcessBinary {
    private String pathGuid;
    private File file;
    private DeployFeedbackHelper feedbackHelper;

    public UpdateBinary(String accountName, String applicationName, String pathGuid, File file, String host, HttpClient httpClient, String csrfToken, DeployFeedbackHelper feedbackHelper, String agentName, String agentVersion) {
        super(accountName, applicationName, host, httpClient, csrfToken, agentName, agentVersion);
        this.pathGuid = pathGuid;
        this.file = file;
        this.feedbackHelper = feedbackHelper;
    }

    @Override
    protected String getRequestMethodName() {
        return "PUT";
    }

    @Override
    protected String getRequestUrl() {
        return String.valueOf(this.host) + "/lifecycle/v1/accounts/" + this.accountName + "/apps/" + this.applicationName + "/binaries/" + this.pathGuid;
    }

    @Override
    public AbstractHttpEntity getRequestEntity() throws IOException {
        if (!this.file.exists()) {
            return new FileEntity(this.file, "application/octet-stream");
        }
        MeasuringInputStream measuringIS = new MeasuringInputStream(new FileInputStream(this.file), this.feedbackHelper, false);
        InputStreamEntity isEntity = new InputStreamEntity((InputStream)measuringIS, this.file.length());
        isEntity.setContentType("application/octet-stream");
        return isEntity;
    }
}

