/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.progress;

import com.sap.core.deploy.client.Result;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.progress.OperationProperties;

public class LifecycleOperationProperties
extends OperationProperties {
    private static final long serialVersionUID = 9053018340229201134L;
    public static final String PROCESS_ID_KEY = "PROCESS_ID_KEY";
    public static final String CURRENT_VM_STATUS_KEY = "CURRENT_VM_STATUS_KEY";
    public static final String RESULT_KEY = "RESULT_KEY";

    public LifecycleOperationProperties(String processId, Result result, long executionTime) {
        super(executionTime);
        if (processId != null) {
            this.put(PROCESS_ID_KEY, processId);
        }
        if (result != null) {
            this.put(CURRENT_VM_STATUS_KEY, result.getStatus());
            this.put(RESULT_KEY, result);
        }
    }

    public String getProcessId() {
        return this.getProperty(PROCESS_ID_KEY, String.class);
    }

    public void setProcessId(String processId) {
        if (processId != null) {
            this.put(PROCESS_ID_KEY, processId);
        }
    }

    public Status getCurrentVMStatus() {
        return this.getProperty(CURRENT_VM_STATUS_KEY, Status.class);
    }

    public Result getOperationResult() {
        return this.getProperty(RESULT_KEY, Result.class);
    }

    public void setOperationResult(Result result) {
        if (result != null) {
            this.put(CURRENT_VM_STATUS_KEY, result.getStatus());
            this.put(RESULT_KEY, result);
        }
    }
}

