/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.Gson;
import com.sap.core.deploy.client.publicrest.exceptions.JsonResponseProcessingException;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BasicClient {
    private static final Logger LOGGER = Logger.getLogger(BasicClient.class);
    public static final String CSRF_TOKEN_HEADER_NAME = "X-CSRF-Token";
    public static final String CSRF_TOKEN_HEADER_FETCH_VALUE = "Fetch";
    public static final String USER_AGENT_HEADER_NAME = "X-User-Agent";
    public static final String USER_AGENT_HEADER_VALUE = "Deploy Client";
    public static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    public static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String VERSION_HEADER_NAME = "X-Client-Version";
    public static final String ACCOUNT_HEADER_NAME = "account";
    private String csrfToken;
    protected String host;
    protected String agentName;
    protected String agentVersion;
    protected String account;

    public BasicClient(String host, String account, String agentName, String agentVersion) {
        this.host = this.adoptHost(host);
        this.account = account;
        this.agentName = agentName;
        this.agentVersion = agentVersion;
    }

    public boolean usePublicRest(String jpApplianceComponentName) throws Exception {
        return jpApplianceComponentName != null && jpApplianceComponentName.equalsIgnoreCase("web");
    }

    public String getCsrfToken(HttpClient httpClient, String host) throws ClientProtocolException, IOException {
        if (this.csrfToken == null) {
            this.csrfToken = this.initCsrfToken(httpClient, host);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("csrfToken = [" + this.csrfToken + "]"));
            }
        }
        return this.csrfToken;
    }

    public String getHost() {
        return this.host;
    }

    protected String extractJsonResponseBody(HttpResponse response) throws JsonResponseProcessingException {
        String responseBody;
        Header responseContentType = response.getFirstHeader("Content-type");
        try {
            responseBody = this.extractResponseBody(response);
        }
        catch (IOException e) {
            throw new JsonResponseProcessingException(e.getMessage(), e);
        }
        if (responseBody == null || responseBody.trim().equals("")) {
            throw new JsonResponseProcessingException("There is no message in the response returned from server", null);
        }
        if (!this.contentIsJson(responseContentType)) {
            LOGGER.error((Object)("Not recognized response: " + responseBody + "\nResponse body is: \n" + responseBody));
            throw new JsonResponseProcessingException("Not recognized response.\n    The host name of the configured server is not a valid entry point to the SAP Cloud Platform, or, the request did not reach the server.", null);
        }
        return responseBody;
    }

    protected boolean contentIsJson(Header responseContentType) {
        return responseContentType != null && responseContentType.getValue().startsWith(CONTENT_TYPE_HEADER_VALUE);
    }

    protected String extractResponseBody(HttpResponse response) throws IOException {
        String jsonResponse = null;
        HttpEntity entity = response.getEntity();
        try {
            if (entity != null) {
                jsonResponse = EntityUtils.toString((HttpEntity)entity);
            }
        }
        finally {
            NetworkUtils.consumeEntity(entity);
        }
        return jsonResponse;
    }

    protected String getFormatedError(ExceptionEntity exceptionEntity, String operationName) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Error Occurred while execution of " + operationName + ". Details:" + lineSeparator);
        sb.append("\tCode: " + exceptionEntity.getCode() + lineSeparator);
        sb.append("\tDescription: " + exceptionEntity.getDescription() + lineSeparator);
        return sb.toString();
    }

    protected void logDebug(Logger logger, String messagePattern, Object ... messageAttributes) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format(messagePattern, messageAttributes));
        }
    }

    protected void logInfo(Logger logger, String messagePattern, Object ... messageAttributes) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format(messagePattern, messageAttributes));
        }
    }

    protected String initCsrfToken(HttpClient httpClient, String host) throws ClientProtocolException, IOException {
        LOGGER.info((Object)("NOTE: csrfToken init >> " + new Date()));
        HttpResponse response = null;
        try {
            HttpGet httpGetFetch = new HttpGet(String.valueOf(host) + "/lifecycle/v1/csrf");
            httpGetFetch.addHeader(CSRF_TOKEN_HEADER_NAME, CSRF_TOKEN_HEADER_FETCH_VALUE);
            httpGetFetch.addHeader(ACCOUNT_HEADER_NAME, this.account);
            response = httpClient.execute((HttpUriRequest)httpGetFetch);
            String string = this.getCsrfTokenHeader(response, host);
            return string;
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    protected <T> T getResponseFromJson(String json, Type responseType) {
        return (T)new Gson().fromJson(json, responseType);
    }

    private String adoptHost(String hostUrl) {
        if (hostUrl != null) {
            hostUrl = hostUrl.replace("https://api.", "");
            hostUrl = hostUrl.replace("https://deployment.", "");
            hostUrl = hostUrl.replace("https://", "");
            return "https://api." + hostUrl;
        }
        return hostUrl;
    }

    private String getCsrfTokenHeader(HttpResponse response, String host) {
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                return this.retrieveCsrfTokenFromResponse(response);
            }
            case 401: {
                throw new RuntimeException(ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
            case 404: {
                throw new RuntimeException("Unknown SAP Cloud Platform host was provided. Check whether the host is correctly spelled.");
            }
            case 403: {
                throw new RuntimeException(String.format("Access to %s is not allowed from your network. Contact SAP Cloud Platform for help", host));
            }
            case 503: {
                throw new RuntimeException("The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.");
            }
        }
        LOGGER.error((Object)("getCsrfToken status code: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase()));
        throw new RuntimeException("Csrf token could not be initialized with first fetch request\nThe Web Server may be down, too busy, or experiencing other problems preventing it from responding to requests. Try again at a later time");
    }

    private String retrieveCsrfTokenFromResponse(HttpResponse response) {
        if (response.containsHeader(CSRF_TOKEN_HEADER_NAME)) {
            return response.getFirstHeader(CSRF_TOKEN_HEADER_NAME).getValue();
        }
        LOGGER.error((Object)"Csrf token could not be initialized with first fetch request");
        throw new RuntimeException("Csrf token could not be initialized with first fetch request");
    }

    protected String adoptResultMessage(String errorMessage) {
        return errorMessage != null ? errorMessage : "Internal server error occurred. There is no message in the response returned from server.";
    }
}

