/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.impl.requests.CancelDeploymentRequest;
import com.sap.core.deploy.client.publicrest.exceptions.DeployPublicRestException;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.commons.log.StringFormatLoggerWrapper;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;

public class CancelDeploymentClient
extends BasicClient {
    static StringFormatLoggerWrapper LOGGER = StringFormatLoggerWrapper.getLogger(CancelDeploymentClient.class);
    private String application;
    private HttpClient httpClient;

    public CancelDeploymentClient(String account, String application, String host, HttpClient httpClient, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
        this.application = application;
        this.httpClient = httpClient;
    }

    public DeployResult cancelDeployment() {
        try {
            return this.doCancel();
        }
        catch (DeployPublicRestException e) {
            return this.handleException(e);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private DeployResult doCancel() throws ClientProtocolException, IOException {
        LOGGER.info("Starting cancelation of deployment of application [%s/%s]", new Object[]{this.account, this.application});
        CancelDeploymentRequest request = new CancelDeploymentRequest(this.account, this.application, this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), this.agentName, this.agentVersion);
        LOGGER.debug("Sending request for canceling deployment of application [%s/%s]", new Object[]{this.account, this.application});
        request.sendRequest();
        LOGGER.info("Deployment of application [%s/%s] was successfully canceled", new Object[]{this.account, this.application});
        return new DeployResult(0, null, null);
    }

    private DeployResult handleException(DeployPublicRestException e) {
        int statusCode = e.getHttpResponse().getStatusLine().getStatusCode();
        String errorMessage = e.getErrorMessage();
        LOGGER.error("Cancelation of deployment of application [%s/%s] failed with response code [%d] and error message [%s]", new Object[]{this.account, this.application, statusCode, errorMessage});
        String resultMessage = this.adoptResultMessage(errorMessage);
        return new DeployResult(3, resultMessage, null);
    }

    private DeployResult handleException(Exception e) {
        LOGGER.error((Throwable)e, "Request for deployment cancelation of application [%s/%s] failed", new Object[]{this.account, this.application});
        return new DeployResult(1, e.getMessage(), null);
    }
}

