/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.impl.DeployFeedbackHelper;
import com.sap.core.deploy.client.impl.requests.DeltaDeployAnalyzer;
import com.sap.core.deploy.client.impl.requests.ListBinaries;
import com.sap.core.deploy.client.impl.requests.MakeApplicationExecutor;
import com.sap.core.deploy.client.impl.requests.MakeApplicationFactory;
import com.sap.core.deploy.client.impl.requests.PatchBinary;
import com.sap.core.deploy.client.impl.requests.RestRequest;
import com.sap.core.deploy.client.impl.requests.UpdateBinaries;
import com.sap.core.deploy.client.impl.requests.UpdateBinary;
import com.sap.core.deploy.client.publicrest.exceptions.DeployPublicRestException;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.publicrest.impl.CancelDeploymentClient;
import com.sap.core.deploy.client.publicrest.impl.DeltaOutputBean;
import com.sap.core.deploy.client.publicrest.impl.DeployPacket;
import com.sap.core.deploy.client.publicrest.impl.retry.RetryException;
import com.sap.core.deploy.client.publicrest.impl.retry.RetryManager;
import com.sap.core.deploy.client.publicrest.impl.retry.RetryManagerBuilder;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.StopStrategyFactory;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.WaitStrategyFactory;
import com.sap.core.deploy.client.utils.DeployClientUtils;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.PropertiesConstants;
import com.sap.core.deploy.commons.rest.entity.enumerations.FileStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.FileResponseEntry;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.deploy.commons.rest.entity.response.BinariesResponse;
import com.sap.core.deploy.commons.rest.entity.response.FileResponse;
import com.sap.core.deploy.commons.rest.entity.response.NoContentResponse;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.core.jpaasrepository.api.MalformedJsonElementException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class DeployClient
extends BasicClient {
    private static final String DELTA_NO_DIFFERENCES_MESSAGE = "No differences: the provided source is the same as the deployed content.";
    private static final String DELETED = "deleted";
    private static final String UPDATED = "updated";
    private static final String ADDED = "added";
    private static final int TERMINAL_STATE_CHECK_SLEEP = 3000;
    public static final String SILENT_MODE = "silent";
    private static final String DELETED_ENTRIES_LABEL = "   deleted : %d\n";
    private static final String UPDATED_ENTRIES_LABEL = "   updated : %d\n";
    private static final String ADDED_ENTRIES_LABEL = "   added   : %d\n";
    private static final String CALCULATING_DIFFERENCES_MESSAGE = "%n[%s] Calculating differences...";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int NUMBER_OF_ATTEMPTS_BEFORE_STOP_RETRYING_BINARY_UPDATE = 2;
    private Map<String, List<DeltaOutputBean>> deltaFilesMap;
    static final Logger LOGGER = Logger.getLogger(DeployClient.class);
    private String applicationName;
    private Descriptor descriptor;
    private HttpClient httpClient;
    private DeployFeedbackHelper feedbackHelper;
    private String hotUpdateStrategy;

    public DeployClient(String accountName, String applicationName, Descriptor descriptor, String host, HttpClient httpClient, DeployFeedbackHelper feedbackHelper, String agentName, String agentVersion) {
        super(host, accountName, agentName, agentVersion);
        this.applicationName = applicationName;
        this.descriptor = descriptor;
        this.httpClient = httpClient;
        this.feedbackHelper = feedbackHelper;
    }

    private void executeWithRetryPattern(RestRequest<NoContentResponse> restRequest) throws DeployPublicRestException, ExecutionException {
        RetryManager retryer = RetryManagerBuilder.newBuilder().withWaitStrategy(WaitStrategyFactory.getNoWait()).withStopStrategy(StopStrategyFactory.getStopAfterAttemptCount(2)).retryWhenExpectedException(DeployPublicRestException.class).build();
        try {
            retryer.processRequest(restRequest);
        }
        catch (RetryException e) {
            LOGGER.error((Object)(String.valueOf(e.getClass().getName()) + " exception occured while executing request to server via retry mechanism."));
            DeployPublicRestException deployPublicRestException = (DeployPublicRestException)e.getLastFailedAttempt().getExceptionCause();
            throw deployPublicRestException;
        }
    }

    private RestRequest<NoContentResponse> prepareRestRequest(DeployPacket deployPacket) throws ClientProtocolException, IOException {
        if (deployPacket.getDeltaLevel() == DeltaDeployAnalyzer.DeltaLevel.LevelOne) {
            return this.prepareUpdateBinary(deployPacket);
        }
        if (deployPacket.getDeltaLevel() == DeltaDeployAnalyzer.DeltaLevel.LevelTwo) {
            return this.preparePatchBinary(deployPacket);
        }
        throw new IllegalArgumentException("Incorrect delta level: " + (Object)((Object)deployPacket.getDeltaLevel()));
    }

    protected long populateResponsesAndDeltaLevelsInDeployPacketsMap(Map<String, DeployPacket> clientSideDeployPackets, List<FileResponse> serverSideFileResponses) {
        long totalWarFilesSize = 0L;
        for (FileResponse fileResponse : serverSideFileResponses) {
            if (fileResponse.getStatus() == FileStateEnum.AVAILABLE || fileResponse.getStatus() == FileStateEnum.FOR_DELETE) {
                LOGGER.debug((Object)("SKIP UPLOADING >> Missing file [" + fileResponse.getPath() + "] is available on server side."));
                clientSideDeployPackets.remove(fileResponse.getPath());
                continue;
            }
            DeployPacket deployPacket = clientSideDeployPackets.get(fileResponse.getPath());
            deployPacket.setFileResponse(fileResponse);
            deployPacket.setDeltaLevel(fileResponse, this.isDelta());
            totalWarFilesSize += deployPacket.getWarFile().length();
        }
        return totalWarFilesSize;
    }

    private boolean containsFilesForPatching(Map<String, DeployPacket> warFiles) {
        for (DeployPacket deployPacket : warFiles.values()) {
            if (deployPacket.getDeltaLevel() == null || deployPacket.getDeltaLevel() != DeltaDeployAnalyzer.DeltaLevel.LevelTwo) continue;
            return true;
        }
        return false;
    }

    private RestRequest<NoContentResponse> prepareUpdateBinary(DeployPacket deployPackage) throws ClientProtocolException, IOException {
        return new UpdateBinary(this.account, this.applicationName, deployPackage.getFileResponse().getPathGuid(), deployPackage.getWarFile(), this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), this.feedbackHelper, this.agentName, this.agentVersion);
    }

    private RestRequest<NoContentResponse> preparePatchBinary(DeployPacket deployPacket) throws ClientProtocolException, IOException {
        return new PatchBinary(this.account, this.applicationName, deployPacket.getFileResponse().getPathGuid(), deployPacket.getWarFile(), deployPacket.getFileResponse(), this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), this.feedbackHelper, this.agentName, this.agentVersion);
    }

    protected BinariesResponse listBinaries() throws IOException, InterruptedException {
        ListBinaries listBinaries = new ListBinaries(this.account, this.applicationName, this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), this.agentName, this.agentVersion);
        BinariesResponse binariesResponse = null;
        String state = null;
        while (true) {
            DeployTimeoutUtil.cancelIfDeployTimeoutReached();
            binariesResponse = (BinariesResponse)listBinaries.sendRequest();
            state = binariesResponse.getStatus();
            if (this.isStateTerminal(state)) break;
            Thread.sleep(3000L);
        }
        LOGGER.debug((Object)("List binaries ends with state: " + state));
        return binariesResponse;
    }

    @Override
    public boolean usePublicRest(String componentName) throws IOException, MalformedJsonElementException {
        if (!this.isDefaultComponent(componentName)) {
            return false;
        }
        if (this.isInstallableUnit()) {
            return false;
        }
        if (this.isHotUpdate()) {
            return this.isDelta() || this.isDefaultComponent(componentName);
        }
        String[] jpaasServices = this.descriptor.getAs("jpaas_services", String[].class);
        if (jpaasServices == null || jpaasServices.length != 1 || !jpaasServices[0].equals(PropertiesConstants.ALL_SERVICES[0])) {
            return false;
        }
        if (this.isNetworkVisibilitySet()) {
            return false;
        }
        return this.isDelta() || this.shouldDeployWithOneConnection();
    }

    private boolean isHotUpdate() {
        this.hotUpdateStrategy = this.descriptor.get("hot-update");
        return this.hotUpdateStrategy != null;
    }

    private boolean isDefaultComponent(String componentName) {
        return "web".equalsIgnoreCase(componentName);
    }

    private boolean isInstallableUnit() {
        return this.descriptor.get("iu_name") != null;
    }

    private boolean isNetworkVisibilitySet() throws MalformedJsonElementException {
        return this.descriptor.getAs("network.visibility", String[].class) != null;
    }

    protected boolean isDelta() {
        return "true".equalsIgnoreCase(this.descriptor.get("delta"));
    }

    private boolean shouldDeployWithOneConnection() throws IOException {
        String uploadConnectionsString = this.descriptor.get("connections");
        if (uploadConnectionsString != null) {
            int uploadConnections = Integer.parseInt(uploadConnectionsString);
            return uploadConnections == 1;
        }
        return this.isContentSizeForOneConnection();
    }

    private boolean isContentSizeForOneConnection() throws IOException {
        File[] warFiles = this.getWarFiles();
        long totalSize = this.getSumOfFileSizes(warFiles);
        LOGGER.debug((Object)("Total size of content is: " + totalSize));
        return this.isContentTotalSizeForOneConnection(totalSize) || this.isEmptySite(totalSize);
    }

    private boolean isContentTotalSizeForOneConnection(long totalSize) {
        return 0L < totalSize && totalSize < 0x500000L;
    }

    private boolean isEmptySite(long totalSize) {
        return "EMPTY_SITE".equals(this.descriptor.get("update_sites")) && 0L == totalSize;
    }

    private long getSumOfFileSizes(File[] warFiles) {
        long totalSum = 0L;
        File[] fileArray = warFiles;
        int n = warFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File warFile = fileArray[n2];
            totalSum += warFile.length();
            ++n2;
        }
        return totalSum;
    }

    private File[] getWarFiles() throws IOException {
        String[] deploymentLocations = DeployClientUtils.getInstance().splitStringWithTrimNonStatic(this.descriptor.get("update_sites"), ",");
        File[] warFiles = DeployClientUtils.getInstance().detectLocalWarFilesAndBundlesNonStatic(deploymentLocations);
        return warFiles;
    }

    public DeployResult doDeploy() throws Exception {
        try {
            boolean isDelta = this.isDelta();
            BinariesResponse binariesResponse = this.triggerOperation(isDelta);
            if (isDelta) {
                this.populateOutputMap(binariesResponse);
                this.printDeltaOutput();
            }
            this.processBinaries(binariesResponse);
            BinariesResponse listBinaries = this.listBinaries();
            return this.getDeployResult(listBinaries);
        }
        catch (DeployPublicRestException e) {
            return this.handleDeployPublicRestException(e);
        }
    }

    private void processBinaries(BinariesResponse binariesResponse) throws IOException, ExecutionException {
        Map<String, DeployPacket> deployPacketsMap = this.createDeployPacketsMap(this.getWarFiles());
        List serverSideFileResponses = binariesResponse.getFiles();
        long totalWarFilesSize = this.populateResponsesAndDeltaLevelsInDeployPacketsMap(deployPacketsMap, serverSideFileResponses);
        boolean atLeastOneForPatch = this.containsFilesForPatching(deployPacketsMap);
        this.feedbackHelper.setDeployIsDeltaLevelTwo(atLeastOneForPatch);
        this.feedbackHelper.setTotalSize(totalWarFilesSize);
        for (DeployPacket deployPacket : deployPacketsMap.values()) {
            DeployTimeoutUtil.cancelIfDeployTimeoutReached();
            RestRequest<NoContentResponse> restRequest = this.prepareRestRequest(deployPacket);
            this.executeWithRetryPattern(restRequest);
        }
        if (this.skipUploadingOutput()) {
            this.feedbackHelper.processingStarted();
        } else {
            this.feedbackHelper.uploadFinished();
        }
    }

    protected BinariesResponse triggerOperation(boolean isDelta) throws IOException {
        BinariesResponse binariesResponse = null;
        if (isDelta) {
            System.out.print(String.format(CALCULATING_DIFFERENCES_MESSAGE, new Date()));
        }
        if (this.hotUpdateStrategy != null) {
            LOGGER.info((Object)("Hot Update with strategy [" + this.hotUpdateStrategy + "], delta option [" + isDelta + "]"));
            binariesResponse = this.updateBinaries();
        } else {
            LOGGER.info((Object)("Deploy with delta option [" + isDelta + "]"));
            binariesResponse = this.makeApplication();
        }
        return binariesResponse;
    }

    protected DeployResult getDeployResult(BinariesResponse listBinaries) {
        if (this.isDeploySuccessful(listBinaries)) {
            return new DeployResult(0, listBinaries.getWarnings(), null);
        }
        return new DeployResult(1, this.getErrorMessage(listBinaries), null);
    }

    private boolean isDeploySuccessful(BinariesResponse listBinaries) {
        return TerminalState.DEPLOYED.toString().equals(listBinaries.getStatus());
    }

    private String getErrorMessage(BinariesResponse listBinaries) {
        String errorMessage = listBinaries.getFailMessage();
        if (errorMessage == null || errorMessage.length() == 0) {
            return "Deployment failed to process binaries";
        }
        return errorMessage;
    }

    protected void printDeltaOutput() {
        if (this.deltaFilesMap.isEmpty()) {
            LOGGER.info((Object)DELTA_NO_DIFFERENCES_MESSAGE);
            this.print(DELTA_NO_DIFFERENCES_MESSAGE);
        } else {
            String generateOutputMessage = this.generateOutputMessage(this.deltaFilesMap);
            LOGGER.info((Object)generateOutputMessage);
            this.print(generateOutputMessage);
        }
    }

    private void populateOutputMap(BinariesResponse binariesResponse) {
        List files = binariesResponse.getFiles();
        this.deltaFilesMap = new HashMap<String, List<DeltaOutputBean>>();
        ArrayList<DeltaOutputBean> added = new ArrayList<DeltaOutputBean>();
        ArrayList<DeltaOutputBean> deleted = new ArrayList<DeltaOutputBean>();
        ArrayList<DeltaOutputBean> updated = new ArrayList<DeltaOutputBean>();
        for (FileResponse fileResponse : files) {
            if (fileResponse.getStatus() == FileStateEnum.UNAVAILABLE) {
                added.add(new DeltaOutputBean(fileResponse.getPath()));
                continue;
            }
            if (fileResponse.getStatus() == FileStateEnum.FOR_DELETE) {
                deleted.add(new DeltaOutputBean(fileResponse.getPath()));
                continue;
            }
            if (fileResponse.getStatus() != FileStateEnum.FOR_UPDATE) continue;
            Map<String, Integer> modifiedEntriesNumberMap = this.countModifiedEntries(fileResponse.getEntries());
            updated.add(new DeltaOutputBean(fileResponse.getPath(), modifiedEntriesNumberMap.get(ADDED), modifiedEntriesNumberMap.get(UPDATED), modifiedEntriesNumberMap.get(DELETED)));
        }
        this.putToMapWithEmptyCheck(this.deltaFilesMap, UPDATED, updated);
        this.putToMapWithEmptyCheck(this.deltaFilesMap, ADDED, added);
        this.putToMapWithEmptyCheck(this.deltaFilesMap, DELETED, deleted);
        LOGGER.info((Object)("Delta differences map: " + this.deltaFilesMap));
    }

    private void putToMapWithEmptyCheck(Map<String, List<DeltaOutputBean>> map, String key, List<DeltaOutputBean> value) {
        if (!value.isEmpty()) {
            map.put(key, value);
        }
    }

    private Map<String, Integer> countModifiedEntries(List<FileResponseEntry> entries) {
        HashMap<String, Integer> modifiedEntriesMap = new HashMap<String, Integer>();
        int added = 0;
        int updated = 0;
        int deleted = 0;
        for (FileResponseEntry entry : entries) {
            if (entry.getAvailabilityState() == FileStateEnum.UNAVAILABLE) {
                ++added;
                continue;
            }
            if (entry.getAvailabilityState() == FileStateEnum.FOR_UPDATE) {
                ++updated;
                continue;
            }
            if (entry.getAvailabilityState() != FileStateEnum.FOR_DELETE) continue;
            ++deleted;
        }
        modifiedEntriesMap.put(ADDED, added);
        modifiedEntriesMap.put(UPDATED, updated);
        modifiedEntriesMap.put(DELETED, deleted);
        return modifiedEntriesMap;
    }

    private String generateOutputMessage(Map<String, List<DeltaOutputBean>> outputFilesMap) {
        StringBuilder outputMessage = new StringBuilder("The following differences were detected:\n");
        outputMessage.append(this.getOutput(UPDATED, outputFilesMap));
        outputMessage.append(this.getOutput(ADDED, outputFilesMap));
        outputMessage.append(this.getOutput(DELETED, outputFilesMap));
        return outputMessage.toString();
    }

    private String getOutput(String changeTypeKey, Map<String, List<DeltaOutputBean>> outputFilesMap) {
        StringBuilder output = new StringBuilder();
        List<DeltaOutputBean> deltaOutputBeans = outputFilesMap.get(changeTypeKey);
        if (deltaOutputBeans != null) {
            for (DeltaOutputBean deltaOutputBean : deltaOutputBeans) {
                output.append(String.valueOf(changeTypeKey) + " " + deltaOutputBean.getFilePath());
                if (changeTypeKey.equals(UPDATED)) {
                    output.append(": " + deltaOutputBean.getModifiedNumber() + " modified file(s)\n");
                    output.append(String.format(UPDATED_ENTRIES_LABEL, deltaOutputBean.getUpdatedNumber()));
                    output.append(String.format(ADDED_ENTRIES_LABEL, deltaOutputBean.getAddedNumber()));
                    output.append(String.format(DELETED_ENTRIES_LABEL, deltaOutputBean.getDeletedNumber()));
                    continue;
                }
                output.append("\n");
            }
        }
        return output.toString();
    }

    protected BinariesResponse makeApplication() throws IOException {
        MakeApplicationFactory factory = new MakeApplicationFactory();
        MakeApplicationExecutor executor = new MakeApplicationExecutor(this.account, this.applicationName, this.descriptor, this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), factory, this.agentName, this.agentVersion);
        ApplicationResponse applicationResponse = executor.executeMakeApplicationRequest(true);
        BinariesResponse binariesResponse = applicationResponse.getBinaries();
        return binariesResponse;
    }

    private BinariesResponse updateBinaries() throws IOException {
        UpdateBinaries updateBinaries = new UpdateBinaries(this.account, this.applicationName, this.descriptor, this.host, this.httpClient, this.getCsrfToken(this.httpClient, this.host), this.agentName, this.agentVersion);
        BinariesResponse binariesResponse = (BinariesResponse)updateBinaries.sendRequest();
        return binariesResponse;
    }

    private boolean skipUploadingOutput() {
        boolean skipUploadingOutput = false;
        if (this.isDelta()) {
            skipUploadingOutput = this.deltaFilesMap == null || this.deltaFilesMap.isEmpty() ? true : !this.deltaMapContainsAddedOrUpdated();
        }
        return skipUploadingOutput;
    }

    private boolean deltaMapContainsAddedOrUpdated() {
        List<DeltaOutputBean> addedList = this.deltaFilesMap.get(ADDED);
        List<DeltaOutputBean> updatedList = this.deltaFilesMap.get(UPDATED);
        return addedList != null && !addedList.isEmpty() || updatedList != null && !updatedList.isEmpty();
    }

    private boolean isStateTerminal(String state) {
        if (state != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Current deploy state: " + state));
            }
            try {
                Enum.valueOf(TerminalState.class, state);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return false;
    }

    private Map<String, DeployPacket> createDeployPacketsMap(File[] wars) throws IOException {
        HashMap<String, DeployPacket> deployPacketsMap = new HashMap<String, DeployPacket>();
        File[] fileArray = wars;
        int n = wars.length;
        int n2 = 0;
        while (n2 < n) {
            File war = fileArray[n2];
            deployPacketsMap.put(war.getName(), new DeployPacket(war));
            ++n2;
        }
        return deployPacketsMap;
    }

    private DeployResult handleDeployPublicRestException(DeployPublicRestException e) {
        HttpResponse response = e.getHttpResponse();
        int statusCode = response.getStatusLine().getStatusCode();
        String errorMessage = e.getErrorMessage();
        switch (statusCode) {
            case 401: {
                return new DeployResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
            }
            case 500: {
                this.cancelDeployment();
                String message = this.adoptResultMessage(errorMessage);
                return new DeployResult(3, message, null);
            }
            case 503: {
                return new DeployResult(3, "The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.", null);
            }
        }
        String message = errorMessage != null ? errorMessage : "Unexpected response from server. HTTP status code " + statusCode;
        return new DeployResult(1, message, null);
    }

    private void cancelDeployment() {
        this.logInfo(LOGGER, "Internal server error occured during deployment of application [%s/%s]. Will try to cancel the deployment operation to clear locks", this.account, this.applicationName);
        CancelDeploymentClient cancelDeploymentClient = this.createCancelDeploymentClientInstance();
        cancelDeploymentClient.cancelDeployment();
    }

    protected CancelDeploymentClient createCancelDeploymentClientInstance() {
        return new CancelDeploymentClient(this.account, this.applicationName, this.host, this.httpClient, this.agentName, this.agentVersion);
    }

    private void print(String message) {
        System.out.println(String.valueOf(LINE_SEPARATOR) + message);
    }

    public static enum TerminalState {
        DEPLOYED,
        FAILED;

    }
}

