/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.publicrest.impl.ReadBasicApplicationStateClient;
import com.sap.core.deploy.client.publicrest.impl.UpdateApplicationStateClient;
import com.sap.core.deploy.commons.log.StringFormatLoggerWrapper;
import com.sap.core.deploy.commons.rest.entity.enumerations.LoadBalancerStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.TargetApplicationState;
import org.apache.http.client.HttpClient;

public class EnableDisableApplicationClient
extends UpdateApplicationStateClient {
    public static final String UPDATE_APPLICATION_LB_STATE_OPERATION_NAME = "update application loadbalancer state to %s";
    private static final StringFormatLoggerWrapper LOGGER = StringFormatLoggerWrapper.getLogger(EnableDisableApplicationClient.class);
    ReadBasicApplicationStateClient readBasicApplicationStateClient;

    public EnableDisableApplicationClient(String account, String application, String host, TargetApplicationState targetAppState, String agentName, String agentVersion) {
        super(account, application, host, targetAppState, agentName, agentVersion);
        this.readBasicApplicationStateClient = new ReadBasicApplicationStateClient(account, application, host, agentName, agentVersion);
    }

    @Override
    public LifecycleResult doUpdate(HttpClient httpClient) throws Exception {
        if (this.targetAppState.getApplicationState() != null) {
            LOGGER.error("Application state should not be set in request when enabling or disabling application. Provided input: %s", new Object[]{this.targetAppState.toString()});
            return new LifecycleResult(1, "Operation cannot be executed. Check client logs for details");
        }
        LoadBalancerStateEnum targetLoadBalancerState = this.targetAppState.getLoadBalancerState();
        if (targetLoadBalancerState != LoadBalancerStateEnum.ENABLED && targetLoadBalancerState != LoadBalancerStateEnum.DISABLED) {
            LOGGER.error("Invalid load balancer state %s specified for enabling or disabling application. Provided input: %s", new Object[]{targetLoadBalancerState, this.targetAppState.toString()});
            return new LifecycleResult(1, "Operation cannot be executed. Check client logs for details");
        }
        LifecycleResult result = super.doUpdate(httpClient);
        return this.postProcessResult(result, httpClient);
    }

    @Override
    protected boolean isStart() {
        return true;
    }

    @Override
    protected String getOperationName() {
        return String.format(UPDATE_APPLICATION_LB_STATE_OPERATION_NAME, this.targetAppState.getLoadBalancerState().name());
    }

    @Override
    protected void logOperationStart() {
        LOGGER.info("Update loadbalancer state of application %s/%s to %s", new Object[]{this.account, this.application, this.targetAppState.getLoadBalancerState().name()});
    }

    private LifecycleResult postProcessResult(LifecycleResult result, HttpClient httpClient) throws Exception {
        if (result.getStatus() == Status.UNKNOWN) {
            int code = result.getCode();
            String message = result.getMessage();
            StatusResult applicationStatus = this.readBasicApplicationStateClient.readState(httpClient);
            Status applicationStatusAfterOperation = applicationStatus.getStatus();
            result = new LifecycleResult(code, applicationStatusAfterOperation, message, null);
        }
        return result;
    }
}

