/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.publicrest.impl.UpdateProcessStateShortcutClient;
import com.sap.core.deploy.commons.rest.entity.enumerations.LoadBalancerStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.TargetProcessState;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;

public class EnableDisableProcessClient
extends UpdateProcessStateShortcutClient {
    public static final String UPDATE_PROCESS_LB_STATE_MSG_TEMPLATE = "Update process load balancer state to %s";

    public EnableDisableProcessClient(String processId, String host, TargetProcessState targetProcessState, String agentName, String agentVersion) {
        super(processId, host, targetProcessState, agentName, agentVersion);
    }

    @Override
    public LifecycleResult doUpdate(HttpClient httpClient) throws Exception {
        if (this.targetProcessState.getProcessState() != null) {
            this.LOGGER.error((Object)("Application state should not be set in request when enabling or disabling application process. Provided input: " + this.targetProcessState.toString()));
            return new LifecycleResult(1, "Operation cannot be executed. Check client logs for details");
        }
        LoadBalancerStateEnum targetLoadBalancerState = this.targetProcessState.getLoadBalancerState();
        if (targetLoadBalancerState != LoadBalancerStateEnum.ENABLED && targetLoadBalancerState != LoadBalancerStateEnum.DISABLED) {
            this.LOGGER.error((Object)("Invalid load balancer state " + targetLoadBalancerState + " specified for enabling or disabling application process. Provided input: " + this.targetProcessState.toString()));
            return new LifecycleResult(1, "Operation cannot be executed. Check client logs for details");
        }
        return super.doUpdate(httpClient);
    }

    @Override
    protected boolean isStart() {
        return false;
    }

    @Override
    protected String getOperationName() {
        return String.format(UPDATE_PROCESS_LB_STATE_MSG_TEMPLATE, this.targetProcessState.getLoadBalancerState().name());
    }

    @Override
    protected LifecycleResult buildResult(HttpResponse response, String operationName) {
        LifecycleResult result = super.buildResult(response, operationName);
        return this.postProcessResult(response, result);
    }

    private LifecycleResult postProcessResult(HttpResponse response, LifecycleResult result) {
        int status = response.getStatusLine().getStatusCode();
        if (status == 404) {
            return new LifecycleResult(result.getCode(), Status.NOT_FOUND, result.getMessage(), result.getStackTrace());
        }
        return result;
    }
}

