/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.impl.requests.PatchApplication;
import com.sap.core.deploy.client.publicrest.exceptions.JsonResponseProcessingException;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.request.ApplicationRequest;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import com.sap.core.deploy.commons.rest.entity.response.Metadata;
import com.sap.core.deploy.commons.rest.entity.response.Response;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class PatchApplicationClient
extends BasicClient {
    protected static Logger LOGGER = Logger.getLogger(PatchApplicationClient.class);

    public PatchApplicationClient(String host, String account, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
    }

    public ComponentAttributesResult doPatch(String accountName, String applicationName, ApplicationRequest applicationRequest, HttpClient httpClient) throws Exception {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Patching application " + applicationName + " on account " + accountName + "."));
        }
        PatchApplication patchApplication = new PatchApplication(accountName, applicationName, applicationRequest, this.host, httpClient, this.getCsrfToken(httpClient, this.host), this.agentName, this.agentVersion);
        HttpResponse httpResponse = patchApplication.executeRequest();
        return this.buildResult(httpResponse);
    }

    private ComponentAttributesResult buildResult(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Server returned code " + status));
        }
        try {
            switch (status) {
                case 200: {
                    ComponentAttributesResult componentAttributesResult = this.processOKResponse(response);
                    return componentAttributesResult;
                }
                case 403: 
                case 404: 
                case 500: {
                    ComponentAttributesResult componentAttributesResult = this.processErrorResponse(3, status, response);
                    return componentAttributesResult;
                }
                case 409: {
                    ComponentAttributesResult componentAttributesResult = this.processErrorResponse(6, status, response);
                    return componentAttributesResult;
                }
                case 401: {
                    ComponentAttributesResult componentAttributesResult = new ComponentAttributesResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
                    return componentAttributesResult;
                }
                case 503: {
                    ComponentAttributesResult componentAttributesResult = new ComponentAttributesResult(3, "The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.", null);
                    return componentAttributesResult;
                }
            }
            ComponentAttributesResult componentAttributesResult = this.processErrorResponse(1, status, response);
            return componentAttributesResult;
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    private ComponentAttributesResult processOKResponse(HttpResponse response) {
        try {
            String jsonResponseBody = this.extractJsonResponseBody(response);
            ApplicationResponse applicationResponse = this.extractApplicationResponse(jsonResponseBody);
            String warnings = this.getWarningsFromApplicationResponse(applicationResponse);
            return new ComponentAttributesResult(0, warnings);
        }
        catch (JsonResponseProcessingException e) {
            return new ComponentAttributesResult(1, e.getMessage(), e.getCauseErrorStackTrace());
        }
    }

    protected ApplicationResponse extractApplicationResponse(String jsonResponseBody) {
        Response responseEntity = (Response)new Gson().fromJson(jsonResponseBody, new TypeToken<Response<Metadata, ApplicationResponse>>(){}.getType());
        return (ApplicationResponse)responseEntity.getEntity();
    }

    private String getWarningsFromApplicationResponse(ApplicationResponse applicationResponse) {
        String warnings = applicationResponse.getWarnings();
        if (warnings != null) {
            return warnings;
        }
        return "";
    }

    private ComponentAttributesResult processErrorResponse(int code, int status, HttpResponse response) {
        try {
            String jsonResponseBody = this.extractJsonResponseBody(response);
            return this.processJsonError(code, jsonResponseBody, "set application property");
        }
        catch (JsonResponseProcessingException e) {
            return new ComponentAttributesResult(code, e.getMessage(), e.getCauseErrorStackTrace());
        }
    }

    private ComponentAttributesResult processJsonError(int code, String jsonString, String operationName) {
        try {
            ExceptionEntity exceptionEntity = (ExceptionEntity)this.getResponseFromJson(jsonString, (Type)((Object)ExceptionEntity.class));
            LOGGER.error((Object)this.getFormatedError(exceptionEntity, operationName));
            String message = exceptionEntity.getDescription() == null || exceptionEntity.getDescription().isEmpty() ? "Not recognized response.\n    The host name of the configured server is not a valid entry point to the SAP Cloud Platform, or, the request did not reach the server." : exceptionEntity.getDescription();
            return new ComponentAttributesResult(code, message, null);
        }
        catch (JsonParseException jsonParseException) {
            return new ComponentAttributesResult(code, "Unable to parse json response from server.", null);
        }
    }
}

