/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.impl.requests.ReadApplication;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationResponse;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import com.sap.core.deploy.commons.rest.entity.response.Metadata;
import com.sap.core.deploy.commons.rest.entity.response.ResponseEntity;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class ReadApplicationClient
extends BasicClient {
    private static final String READ_APPLICATION_OPERATION = "read application";
    protected static final String INTERNAL_SERVER_ERROR_MSG = "Internal server error.";
    protected static final String APPLICATION_NOT_FOUND_ERROR_MSG = "Application not found";
    protected static Logger LOGGER = Logger.getLogger(ReadApplicationClient.class);
    protected String application;

    public ReadApplicationClient(String host, String application, String account, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
        this.application = application;
    }

    public ComponentAttributesResult readApplication(HttpClient httpClient) throws Exception {
        if (this.host == null || "".equals(this.host.trim())) {
            return new ComponentAttributesResult(1, "No host specified");
        }
        if (this.application == null || "".equals(this.application.trim())) {
            return new ComponentAttributesResult(1, "Please specify application name.");
        }
        ReadApplication readApplication = this.createReadApplication(httpClient);
        HttpResponse httpResposnse = readApplication.executeRequest();
        this.logDebug(LOGGER, "Requesting read of application [%s] and  host [%s].", this.application, this.host);
        this.logDebug(LOGGER, "Response status %s received when requesting read of application %s and host %s.", httpResposnse.getStatusLine().getStatusCode(), this.application, this.host);
        return this.buildResult(httpResposnse, READ_APPLICATION_OPERATION);
    }

    private ReadApplication createReadApplication(HttpClient httpClient) {
        return new ReadApplication(this.account, this.application, this.host, httpClient, null, this.agentName, this.agentVersion);
    }

    protected ComponentAttributesResult buildResult(HttpResponse response, String operationName) {
        int status = response.getStatusLine().getStatusCode();
        try {
            switch (status) {
                case 200: {
                    String jsonResponse = this.extractResponseBody(response);
                    return this.processResponse(0, jsonResponse, operationName);
                }
                case 404: {
                    return new ComponentAttributesResult(4, APPLICATION_NOT_FOUND_ERROR_MSG);
                }
                case 500: {
                    return new ComponentAttributesResult(3, INTERNAL_SERVER_ERROR_MSG);
                }
                case 401: {
                    return new ComponentAttributesResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                }
            }
            String jsonResponse = this.extractResponseBody(response);
            return this.processResponse(1, jsonResponse, operationName);
        }
        catch (IOException e) {
            String errorMsg = String.format("Building of result for operation %s failed.", operationName);
            LOGGER.error((Object)errorMsg, (Throwable)e);
            return new ComponentAttributesResult(1, e.getMessage(), e.toString());
        }
    }

    private ComponentAttributesResult processResponse(int code, String jsonString, String operationName) {
        if (jsonString == null || "".equals(jsonString.trim())) {
            return new ComponentAttributesResult(code, "There is no message in the response returned from server.");
        }
        this.logDebug(LOGGER, "The body returned from the server is in json format: \n %s", jsonString);
        return code == 0 ? this.processJsonResponse(code, jsonString) : this.processJsonError(code, jsonString, operationName);
    }

    protected ComponentAttributesResult processJsonResponse(int code, String jsonString) {
        try {
            ResponseEntity<Metadata, ApplicationResponse> response = this.getResponse(jsonString);
            return ResultBuilder.createComponentAttributesResultFromAppResponse(code, (ApplicationResponse)response.getEntity());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while processing json response: " + jsonString), (Throwable)e);
            return new ComponentAttributesResult(code, "Unable to parse json response from server.");
        }
    }

    protected ResponseEntity<Metadata, ApplicationResponse> getResponse(String jsonString) {
        Type responseType = new TypeToken<ResponseEntity<Metadata, ApplicationResponse>>(){}.getType();
        ResponseEntity response = (ResponseEntity)this.getResponseFromJson(jsonString, responseType);
        return response;
    }

    protected ComponentAttributesResult processJsonError(int code, String jsonString, String operationName) {
        try {
            ExceptionEntity exceptionEntity = (ExceptionEntity)this.getResponseFromJson(jsonString, (Type)((Object)ExceptionEntity.class));
            LOGGER.error((Object)this.getFormatedError(exceptionEntity, operationName));
            return new ComponentAttributesResult(code, exceptionEntity.getDescription());
        }
        catch (JsonParseException e) {
            LOGGER.error((Object)("Unable to parse json response from server. Json response is: [" + jsonString + "]"), (Throwable)e);
            return new ComponentAttributesResult(code, "Unable to parse json response from server.", e.toString());
        }
    }
}

