/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.impl.requests.ReadApplicationState;
import com.sap.core.deploy.client.publicrest.impl.ReadStateClient;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.ResponseEntity;
import com.sap.core.deploy.commons.rest.entity.response.StatusResponseMetadata;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class ReadApplicationStateClient
extends ReadStateClient {
    protected static Logger LOGGER = Logger.getLogger(ReadApplicationStateClient.class);

    public ReadApplicationStateClient(String account, String application, String host, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
    }

    @Override
    public StatusResult readState(HttpClient httpClient) throws Exception {
        if (this.host == null || "".equals(this.host)) {
            return new StatusResult(1, "No host specified");
        }
        if (this.application == null || "".equals(this.application)) {
            return new StatusResult(1, "Please specify application name.");
        }
        ReadApplicationState readApplicationState = this.createReadApplicationState(httpClient);
        HttpResponse httpResposnse = readApplicationState.executeRequest();
        this.logDebug(LOGGER, "Requesting state of application [%s] and  host [%s].", this.application, this.host);
        this.logDebug(LOGGER, "Response status %s received when requesting state of application %s and host %s.", httpResposnse.getStatusLine().getStatusCode(), this.application, this.host);
        return this.buildResult(httpResposnse, null, "read application state");
    }

    protected ResponseEntity<StatusResponseMetadata, ApplicationStateEntity> getResponse(String jsonString) {
        Type responseType = new TypeToken<ResponseEntity<StatusResponseMetadata, ApplicationStateEntity>>(){}.getType();
        ResponseEntity response = (ResponseEntity)this.getResponseFromJson(jsonString, responseType);
        return response;
    }

    protected Status getStatus(ResponseEntity<StatusResponseMetadata, ApplicationStateEntity> response, String jsonString) {
        Status status;
        String statusStr = ((ApplicationStateEntity)response.getEntity()).getApplicationState();
        this.logDebug(LOGGER, "Received %s status of appliance %s and host %s.", statusStr, this.application, this.host);
        try {
            status = Status.valueOf(statusStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Received status response [%s] for [%s/%s] does not contain valid status", jsonString, this.account, this.application), e);
        }
        return status;
    }

    protected abstract ReadApplicationState createReadApplicationState(HttpClient var1);
}

