/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.impl.requests.ReadApplicationState;
import com.sap.core.deploy.client.impl.requests.ReadBasicApplicationState;
import com.sap.core.deploy.client.publicrest.impl.ReadApplicationStateClient;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.ResponseEntity;
import com.sap.core.deploy.commons.rest.entity.response.StatusResponseMetadata;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class ReadBasicApplicationStateClient
extends ReadApplicationStateClient {
    protected static Logger LOGGER = Logger.getLogger(ReadBasicApplicationStateClient.class);

    public ReadBasicApplicationStateClient(String account, String application, String host, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
    }

    @Override
    protected ReadApplicationState createReadApplicationState(HttpClient httpClient) {
        return new ReadBasicApplicationState(this.account, this.application, this.host, httpClient, null, this.agentName, this.agentVersion);
    }

    @Override
    protected StatusResult processJsonResponse(int code, String jsonString) {
        Status status = null;
        try {
            ResponseEntity<StatusResponseMetadata, ApplicationStateEntity> response = this.getResponse(jsonString);
            status = this.getStatus(response, jsonString);
            return new StatusResult(code, status, ((ApplicationStateEntity)response.getEntity()).getWarningMessage(), null, null, null, null, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while processing json response: " + jsonString), (Throwable)e);
            return new StatusResult(code, "Unable to parse json response from server.");
        }
    }
}

