/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.impl.requests.ReadApplicationState;
import com.sap.core.deploy.client.impl.requests.ReadDetailedApplicationState;
import com.sap.core.deploy.client.publicrest.impl.ReadApplicationStateClient;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.ResponseEntity;
import com.sap.core.deploy.commons.rest.entity.response.StatusResponseMetadata;
import com.sap.core.deploy.commons.status.LBStatus;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class ReadDetailedApplicationStateClient
extends ReadApplicationStateClient {
    protected static Logger LOGGER = Logger.getLogger(ReadDetailedApplicationStateClient.class);

    public ReadDetailedApplicationStateClient(String account, String application, String host, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
    }

    @Override
    protected ReadApplicationState createReadApplicationState(HttpClient httpClient) {
        return new ReadDetailedApplicationState(this.account, this.application, this.host, httpClient, null, this.agentName, this.agentVersion);
    }

    public StatusResult processResponse(int code, String jsonString) {
        return this.processJsonResponse(code, jsonString);
    }

    @Override
    protected StatusResult processJsonResponse(int code, String jsonString) {
        LBStatus lbStatus;
        ResponseEntity<StatusResponseMetadata, ApplicationStateEntity> responseEntity = null;
        Status status = null;
        String[] urls = null;
        String aliases = null;
        String recommendedUrl = null;
        Map<String, String> runtime = null;
        StatusResult statusResult = null;
        String warningMessage = null;
        try {
            responseEntity = this.getResponse(jsonString);
            status = this.getStatus(responseEntity, jsonString);
            warningMessage = ((ApplicationStateEntity)responseEntity.getEntity()).getWarningMessage();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while getting application state from json response: " + jsonString), (Throwable)e);
            return new StatusResult(code, "Unable to parse json response from server.");
        }
        urls = ((ApplicationStateEntity)responseEntity.getEntity()).getUrls();
        aliases = ((StatusResponseMetadata)responseEntity.getMetadata()).getAliases();
        recommendedUrl = this.getRecommendedUrl(urls);
        if (status == Status.STARTED && (recommendedUrl == null || recommendedUrl.isEmpty())) {
            return new StatusResult(3, status, "Component is started but the URL for access cannot be obtained.", null, null, null, null);
        }
        this.logDebug(LOGGER, "Recommended URL calculated as: %s", recommendedUrl);
        this.logDebug(LOGGER, "Available URLs calculated as: %s", urls != null ? Arrays.asList(urls) : "urls are null");
        this.logDebug(LOGGER, "Available aliases calculated as: %s", aliases);
        runtime = this.retrieveRuntime(responseEntity);
        if (urls == null) {
            urls = new String[]{};
        }
        statusResult = new StatusResult(code, status, warningMessage, null, recommendedUrl, urls, new String[]{aliases}, runtime);
        String lbStatusStr = ((ApplicationStateEntity)responseEntity.getEntity()).getLoadBalancerState();
        if (lbStatusStr != null && (lbStatus = LBStatus.fromString((String)lbStatusStr)) == LBStatus.IN_MAINTENANCE) {
            String maintenanceApplication = ((StatusResponseMetadata)responseEntity.getMetadata()).getMaintenanceApplication();
            statusResult.setLBStatus(lbStatus);
            statusResult.setMaintenanceApplication(maintenanceApplication);
        }
        statusResult.setDowntimeApplication(((StatusResponseMetadata)responseEntity.getMetadata()).getDowntimeApplication());
        statusResult.setApplicationProcesses(((ApplicationStateEntity)responseEntity.getEntity()).getProcesses());
        return statusResult;
    }

    protected String getRecommendedUrl(String[] urls) {
        String recommendedUrl = null;
        if (urls != null && urls.length >= 1) {
            recommendedUrl = urls[0];
        }
        return recommendedUrl;
    }

    private Map<String, String> retrieveRuntime(ResponseEntity<StatusResponseMetadata, ApplicationStateEntity> response) {
        Map runtime = ((StatusResponseMetadata)response.getMetadata()).getRuntime();
        if (runtime != null) {
            this.logDebug(LOGGER, "Available runtime meta data: %s", runtime.toString());
        }
        return runtime;
    }
}

