/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.impl.requests.ReadProcessState;
import com.sap.core.deploy.client.publicrest.impl.ReadStateClient;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.rest.entity.ProcessStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.ProcessStatusResponseMetadata;
import com.sap.core.deploy.commons.rest.entity.response.Response;
import com.sap.core.deploy.commons.status.LBStatus;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class ReadProcessStateClient
extends ReadStateClient {
    protected Logger LOGGER = Logger.getLogger(this.getClass());
    protected String processId;

    public ReadProcessStateClient(String account, String application, String processId, String host, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
        this.processId = processId;
    }

    @Override
    public StatusResult readState(HttpClient httpClient) throws Exception {
        if (this.isApplicationNameInvalid()) {
            return new StatusResult(1, "Please specify application name.");
        }
        if (this.processId == null || this.processId.trim().equals("")) {
            return new StatusResult(1, "Application process ID must not be null.");
        }
        ReadProcessState readProcessState = this.createReadProcessStateInstance(httpClient);
        this.logDebug(this.LOGGER, "Requesting state of application process [%s] and  host [%s].", this.processId, this.host);
        HttpResponse httpResponse = readProcessState.executeRequest();
        this.logDebug(this.LOGGER, "Response code %s received when requesting state of application porcess [%s]", httpResponse.getStatusLine().getStatusCode(), this.processId);
        return this.buildResult(httpResponse, this.processId, "read process state");
    }

    protected boolean isApplicationNameInvalid() {
        return this.application == null || this.application.trim().equals("");
    }

    protected ReadProcessState createReadProcessStateInstance(HttpClient httpClient) {
        return new ReadProcessState(this.account, this.application, this.processId, this.host, httpClient, null, this.agentName, this.agentVersion);
    }

    @Override
    protected StatusResult processJsonResponse(int code, String jsonString) {
        Response<ProcessStatusResponseMetadata, ProcessStateEntity> response = null;
        String statusStr = null;
        Status status = null;
        Map<String, String> runtime = null;
        StatusResult statusResult = null;
        try {
            response = this.getResponse(jsonString);
            statusStr = ((ProcessStateEntity)response.getEntity()).getProcessState().getProcessState();
            this.logDebug(this.LOGGER, "Received %s status of application process [%s]", statusStr, this.processId);
            status = this.getStatus(jsonString, statusStr);
        }
        catch (Exception exception) {
            return new StatusResult(code, "Unable to parse json response from server.");
        }
        runtime = this.retrieveRuntime(response);
        statusResult = new StatusResult(code, status, null, null, null, null, null, runtime);
        ApplicationProcessResource applProcessResource = this.getApplicationProcessResourceFromProcessResponse(response, statusStr, runtime);
        statusResult.setApplicationProcesses(new ApplicationProcessResource[]{applProcessResource});
        String lbStatusStr = ((ProcessStateEntity)response.getEntity()).getProcessState().getLoadBalancerState();
        if (lbStatusStr != null) {
            LBStatus lbStatus = LBStatus.fromString((String)lbStatusStr);
            statusResult.setLBStatus(lbStatus);
        }
        return statusResult;
    }

    private Response<ProcessStatusResponseMetadata, ProcessStateEntity> getResponse(String jsonString) {
        Type responseType = new TypeToken<Response<ProcessStatusResponseMetadata, ProcessStateEntity>>(){}.getType();
        Response response = (Response)this.getResponseFromJson(jsonString, responseType);
        return response;
    }

    private Status getStatus(String jsonString, String statusStr) {
        Status status;
        try {
            status = Status.valueOf(statusStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Received status response [%s] for process [%s] does not contain valid status", jsonString, this.processId), e);
        }
        return status;
    }

    private Map<String, String> retrieveRuntime(Response<ProcessStatusResponseMetadata, ProcessStateEntity> response) {
        Map runtime = ((ProcessStatusResponseMetadata)response.getMetadata()).getRuntime();
        if (runtime != null) {
            this.logDebug(this.LOGGER, "Available runtime meta data: %s", runtime.toString());
        }
        return runtime;
    }

    private ApplicationProcessResource getApplicationProcessResourceFromProcessResponse(Response<ProcessStatusResponseMetadata, ProcessStateEntity> response, String statusStr, Map<String, String> runtime) {
        ApplicationProcessResource applProcessResource = new ApplicationProcessResource();
        applProcessResource.setProcessId(((ProcessStatusResponseMetadata)response.getMetadata()).getProcessId());
        applProcessResource.setLastStatusChange(((ProcessStatusResponseMetadata)response.getMetadata()).getLastStatusChange());
        applProcessResource.setLbStatus(((ProcessStateEntity)response.getEntity()).getProcessState().getLoadBalancerState());
        applProcessResource.setMessage(((ProcessStateEntity)response.getEntity()).getProcessState().getMessage());
        applProcessResource.setTenant(((ProcessStateEntity)response.getEntity()).getProcessState().getTenant());
        applProcessResource.setAvailabilityZone(((ProcessStateEntity)response.getEntity()).getProcessState().getAvailabilityZone());
        applProcessResource.setComputeUnitSize(((ProcessStateEntity)response.getEntity()).getProcessState().getComputeUnitSize());
        applProcessResource.setRuntime(runtime);
        applProcessResource.setStatus(statusStr);
        return applProcessResource;
    }
}

