/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class ReadStateClient
extends BasicClient {
    private static final Logger LOGGER = Logger.getLogger(ReadStateClient.class);
    protected String application;

    public ReadStateClient(String account, String application, String host, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
        this.application = application;
    }

    protected StatusResult buildResult(HttpResponse response, String applicationProcessId, String operationName) {
        String jsonResponse = null;
        int status = response.getStatusLine().getStatusCode();
        try {
            switch (status) {
                case 200: {
                    jsonResponse = this.extractResponseBody(response);
                    StatusResult statusResult = this.processResponse(0, jsonResponse, operationName);
                    return statusResult;
                }
                case 404: {
                    String message = null;
                    if (applicationProcessId != null) {
                        message = "Application process not found\n";
                        jsonResponse = this.extractResponseBody(response);
                        StatusResult errorResult = this.processJsonError(404, jsonResponse, operationName);
                        message = String.valueOf(message) + errorResult.getMessage();
                    } else {
                        message = "Component not found";
                    }
                    StatusResult statusResult = new StatusResult(4, Status.NOT_FOUND, message);
                    return statusResult;
                }
                case 403: {
                    StatusResult statusResult = new StatusResult(5, Status.STOPPED, "Component is stopped");
                    return statusResult;
                }
                case 400: {
                    StatusResult statusResult = new StatusResult(2, "Invalid parameters. ");
                    return statusResult;
                }
                case 500: {
                    StatusResult statusResult = new StatusResult(3, "Internal server error: " + status);
                    return statusResult;
                }
                case 401: {
                    StatusResult statusResult = new StatusResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                    return statusResult;
                }
            }
            jsonResponse = this.extractResponseBody(response);
            StatusResult statusResult = this.processResponse(1, jsonResponse, operationName);
            return statusResult;
        }
        catch (IOException e) {
            String errorMsg = String.format("Building of result for operation %s failed.", operationName);
            LOGGER.error((Object)errorMsg, (Throwable)e);
            StatusResult statusResult = new StatusResult(1, Status.UNKNOWN, e.getMessage(), e.toString(), null, null, null);
            return statusResult;
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    protected StatusResult processJsonError(int code, String jsonString, String operationName) {
        try {
            ExceptionEntity exceptionEntity = (ExceptionEntity)this.getResponseFromJson(jsonString, (Type)((Object)ExceptionEntity.class));
            LOGGER.error((Object)this.getFormatedError(exceptionEntity, operationName));
            return new StatusResult(code, exceptionEntity.getDescription());
        }
        catch (JsonParseException e) {
            LOGGER.error((Object)("Unable to parse json response from server. Json response is: [" + jsonString + "]"), (Throwable)e);
            return new StatusResult(code, Status.UNKNOWN, "Unable to parse json response from server.", e.toString(), null, null, null);
        }
    }

    private StatusResult processResponse(int code, String jsonString, String operationName) {
        if (jsonString == null || "".equals(jsonString.trim())) {
            return new StatusResult(code, "There is no message in the response returned from server.");
        }
        this.logDebug(LOGGER, "The body returned from the server is in json format: \n %s", jsonString);
        return code == 0 ? this.processJsonResponse(code, jsonString) : this.processJsonError(code, jsonString, operationName);
    }

    public abstract StatusResult readState(HttpClient var1) throws Exception;

    protected abstract StatusResult processJsonResponse(int var1, String var2);
}

