/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.impl.requests.UndeployApplication;
import com.sap.core.deploy.client.publicrest.exceptions.JsonResponseProcessingException;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import java.lang.reflect.Type;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class UndeployClient
extends BasicClient {
    private static final String WARNING_MESSAGES_HEADER_NAME = "warnings";
    private static final Logger LOGGER = Logger.getLogger(UndeployClient.class);

    public UndeployClient(String host, String account, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
    }

    public DeployResult doUndeploy(String accountName, String applicationName, HttpClient httpClient) throws Exception {
        if (applicationName == null || applicationName.trim().equals("")) {
            return new DeployResult(1, "Please specify application name.", null);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Undeploying application " + applicationName + " on account " + accountName + "."));
        }
        UndeployApplication undeployApplication = new UndeployApplication(accountName, applicationName, this.host, httpClient, this.getCsrfToken(httpClient, this.host), this.agentName, this.agentVersion);
        HttpResponse httpResponse = undeployApplication.executeRequest();
        return this.buildResult(httpResponse);
    }

    private DeployResult buildResult(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Server returned code " + status));
        }
        try {
            switch (status) {
                case 204: {
                    DeployResult deployResult = this.processUndeployResponse(response);
                    return deployResult;
                }
                case 404: {
                    DeployResult deployResult = new DeployResult(0, null, null);
                    return deployResult;
                }
                case 403: 
                case 500: {
                    DeployResult deployResult = this.processErrorResponse(3, response);
                    return deployResult;
                }
                case 409: {
                    DeployResult deployResult = this.processErrorResponse(6, response);
                    return deployResult;
                }
                case 401: {
                    DeployResult deployResult = new DeployResult(1, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response), null);
                    return deployResult;
                }
                case 503: {
                    DeployResult deployResult = new DeployResult(3, "The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.", null);
                    return deployResult;
                }
            }
            DeployResult deployResult = this.processErrorResponse(1, response);
            return deployResult;
        }
        finally {
            NetworkUtils.consumeEntity(response);
        }
    }

    private DeployResult processUndeployResponse(HttpResponse response) {
        Header warningMessagesHeader = response.getFirstHeader(WARNING_MESSAGES_HEADER_NAME);
        if (this.hasWarningMessageHeader(warningMessagesHeader)) {
            String message = warningMessagesHeader.getValue();
            return new DeployResult(0, message, null);
        }
        return new DeployResult(0, null, null);
    }

    private boolean hasWarningMessageHeader(Header warningMessagesHeader) {
        return warningMessagesHeader != null && warningMessagesHeader.getValue() != null && warningMessagesHeader.getValue().length() > 0;
    }

    private DeployResult processErrorResponse(int code, HttpResponse response) {
        try {
            String jsonResponseBody = this.extractJsonResponseBody(response);
            return this.processJsonError(code, jsonResponseBody, "undeploy");
        }
        catch (JsonResponseProcessingException e) {
            return new DeployResult(code, e.getMessage(), e.getCauseErrorStackTrace());
        }
    }

    private DeployResult processJsonError(int code, String jsonString, String operationName) {
        try {
            ExceptionEntity exceptionEntity = (ExceptionEntity)this.getResponseFromJson(jsonString, (Type)((Object)ExceptionEntity.class));
            LOGGER.error((Object)this.getFormatedError(exceptionEntity, operationName));
            String message = exceptionEntity.getDescription() == null || exceptionEntity.getDescription().isEmpty() ? "Not recognized response.\n    The host name of the configured server is not a valid entry point to the SAP Cloud Platform, or, the request did not reach the server." : exceptionEntity.getDescription();
            return new DeployResult(code, message, null);
        }
        catch (JsonParseException jsonParseException) {
            return new DeployResult(code, "Unable to parse json response from server.", null);
        }
    }
}

