/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.impl.requests.UpdateApplicationState;
import com.sap.core.deploy.client.publicrest.impl.UpdateStateClient;
import com.sap.core.deploy.commons.rest.entity.enumerations.ApplicationStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.TargetApplicationState;
import com.sap.core.deploy.commons.rest.entity.response.ApplicationStateEntity;
import com.sap.core.deploy.commons.rest.entity.response.Response;
import com.sap.core.deploy.commons.rest.entity.response.StatusResponseMetadata;
import com.sap.core.deploy.commons.status.LBStatus;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class UpdateApplicationStateClient
extends UpdateStateClient {
    public static final String UPDATE_APPLICATION_STATE_OPERATION_NAME = "update application state to %s";
    static final String UNABLE_TO_PARSE_RESPONSE_FROM_SERVER = "Unable to parse response from server";
    private static final Logger LOGGER = Logger.getLogger(UpdateApplicationStateClient.class);
    protected TargetApplicationState targetAppState;

    public UpdateApplicationStateClient(String account, String application, String host, TargetApplicationState targetAppState, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
        this.targetAppState = targetAppState;
    }

    @Override
    public LifecycleResult doUpdate(HttpClient httpClient) throws Exception {
        if (this.application == null || this.application.trim().equals("")) {
            return new LifecycleResult(1, "Please specify application name.", null);
        }
        this.logOperationStart();
        UpdateApplicationState updateApplication = new UpdateApplicationState(this.account, this.application, this.host, httpClient, this.targetAppState, this.getCsrfToken(httpClient, this.host), this.agentName, this.agentVersion);
        HttpResponse response = updateApplication.executeRequest();
        return this.buildResult(response, this.getOperationName());
    }

    @Override
    protected LifecycleResult processJsonResponse(int code, String jsonString) {
        try {
            Type responseType = new TypeToken<Response<StatusResponseMetadata, ApplicationStateEntity>>(){}.getType();
            Response response = (Response)this.getResponseFromJson(jsonString, responseType);
            ApplicationStateEntity appStateEntity = (ApplicationStateEntity)response.getEntity();
            StatusResponseMetadata metadata = (StatusResponseMetadata)response.getMetadata();
            LifecycleResult lifecycleResult = new LifecycleResult(code, Status.valueOf(appStateEntity.getApplicationState()), appStateEntity.getWarningMessage(), null);
            if (appStateEntity.getLoadBalancerState() != null) {
                LBStatus lbStatus = LBStatus.fromString((String)appStateEntity.getLoadBalancerState());
                lifecycleResult.setLBStatus(lbStatus);
                if (lbStatus == LBStatus.IN_MAINTENANCE) {
                    lifecycleResult.setMaintenanceApplication(metadata.getMaintenanceApplication());
                }
            }
            if (metadata.getDowntimeApplication() != null) {
                lifecycleResult.setDowntimeApplication(metadata.getDowntimeApplication());
            }
            return lifecycleResult;
        }
        catch (JsonParseException jsonParseException) {
            return new LifecycleResult(code, "Unable to parse json response from server.");
        }
    }

    @Override
    protected boolean isStart() {
        return ApplicationStateEnum.STARTED == this.targetAppState.getApplicationState();
    }

    protected String getOperationName() {
        String targetStateName = this.targetAppState.getApplicationState().name();
        String operationName = String.format(UPDATE_APPLICATION_STATE_OPERATION_NAME, targetStateName);
        return operationName;
    }

    protected void logOperationStart() {
        String targetStateName = this.targetAppState.getApplicationState().name();
        this.logInfo(LOGGER, "Update application state of application %s/%s to %s", this.account, this.application, targetStateName);
    }
}

