/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.impl.requests.UpdateProcess;
import com.sap.core.deploy.client.publicrest.impl.UpdateStateClient;
import com.sap.core.deploy.commons.rest.entity.ProcessStateEntity;
import com.sap.core.deploy.commons.rest.entity.enumerations.ProcessStateEnum;
import com.sap.core.deploy.commons.rest.entity.request.TargetProcessState;
import com.sap.core.deploy.commons.rest.entity.response.ProcessStatusResponseMetadata;
import com.sap.core.deploy.commons.rest.entity.response.Response;
import com.sap.core.deploy.commons.status.LBStatus;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class UpdateProcessStateClient
extends UpdateStateClient {
    protected final Logger LOGGER = Logger.getLogger(this.getClass());
    protected TargetProcessState targetProcessState;
    protected String processId;

    public UpdateProcessStateClient(String account, String application, String processId, String host, TargetProcessState targetProcessState, String agentName, String agentVersion) {
        super(account, application, host, agentName, agentVersion);
        this.processId = processId;
        this.targetProcessState = targetProcessState;
    }

    @Override
    public LifecycleResult doUpdate(HttpClient httpClient) throws Exception {
        if (this.isApplicationNameInvalid()) {
            return new LifecycleResult(1, "Please specify application name.", null);
        }
        if (this.processId == null || this.processId.trim().equals("")) {
            return new LifecycleResult(1, "Application process ID must not be null.", null);
        }
        this.logInfo(this.LOGGER, "Update state of process %s to %s", this.processId, this.targetProcessState.toString());
        UpdateProcess updateProcess = this.createUpdateProcessInstance(httpClient);
        String operationName = this.getOperationName();
        return this.buildResult(updateProcess.executeRequest(), operationName);
    }

    protected boolean isApplicationNameInvalid() {
        return this.application == null || this.application.trim().equals("");
    }

    protected UpdateProcess createUpdateProcessInstance(HttpClient httpClient) throws ClientProtocolException, IOException {
        return new UpdateProcess(this.account, this.application, this.processId, this.host, httpClient, this.targetProcessState, this.getCsrfToken(httpClient, this.host), this.agentName, this.agentVersion);
    }

    protected String getOperationName() {
        return String.format("update process state to %s", this.targetProcessState.getProcessState().name());
    }

    @Override
    protected LifecycleResult processJsonResponse(int code, String jsonString) {
        try {
            Type responseType = new TypeToken<Response<ProcessStatusResponseMetadata, ProcessStateEntity>>(){}.getType();
            Response response = (Response)this.getResponseFromJson(jsonString, responseType);
            ProcessStateEntity processStateEntity = (ProcessStateEntity)response.getEntity();
            LifecycleResult lifecycleResult = new LifecycleResult(code, Status.valueOf(processStateEntity.getProcessState().getProcessState()), processStateEntity.getProcessState().getMessage(), null);
            if (processStateEntity.getProcessState().getLoadBalancerState() != null) {
                LBStatus lbStatus = LBStatus.fromString((String)processStateEntity.getProcessState().getLoadBalancerState());
                lifecycleResult.setLBStatus(lbStatus);
            }
            return lifecycleResult;
        }
        catch (JsonParseException jsonParseException) {
            return new LifecycleResult(code, "Unable to parse json response from server.");
        }
    }

    @Override
    protected boolean isStart() {
        return ProcessStateEnum.STOPPED != this.targetProcessState.getProcessState();
    }
}

