/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl;

import com.google.gson.JsonParseException;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.publicrest.impl.BasicClient;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.rest.entity.response.ExceptionEntity;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class UpdateStateClient
extends BasicClient {
    private static final Logger LOGGER = Logger.getLogger(UpdateStateClient.class);
    protected String application;

    public UpdateStateClient(String account, String application, String host, String agentName, String agentVersion) {
        super(host, account, agentName, agentVersion);
        this.application = application;
    }

    protected LifecycleResult buildResult(HttpResponse response, String operationName) {
        String jsonResponse;
        int status = response.getStatusLine().getStatusCode();
        try {
            jsonResponse = this.extractResponseBody(response);
        }
        catch (IOException e) {
            String errorMsg = String.format("Building of result for operation %s failed.", operationName);
            LOGGER.error((Object)errorMsg, (Throwable)e);
            return new LifecycleResult(1, errorMsg);
        }
        return this.analyzeStatus(status, response, operationName, jsonResponse);
    }

    private LifecycleResult analyzeStatus(int status, HttpResponse response, String operationName, String jsonResponse) {
        switch (status) {
            case 200: {
                return this.processResponse(0, jsonResponse, operationName);
            }
            case 400: {
                return new LifecycleResult(2, "Invalid parameters.");
            }
            case 500: {
                return this.processResponse(3, jsonResponse, operationName);
            }
            case 405: {
                return new LifecycleResult(3, "Authentication error. Check if you have provided correct credentials.");
            }
            case 401: {
                return new LifecycleResult(3, ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
            }
            case 409: {
                return this.processResponse(6, jsonResponse, operationName);
            }
            case 503: {
                return this.processJsonErrorSafely(3, jsonResponse, "The request cannot be processed at specified host. Please try again later. If the problem persists, contact support.", operationName);
            }
        }
        return this.isStart() ? this.processResponse(4, jsonResponse, operationName) : this.processResponse(5, jsonResponse, operationName);
    }

    protected LifecycleResult processJsonError(int code, String jsonString, String operationName) {
        return this.processJsonErrorSafely(code, jsonString, "Unable to parse json response from server.", operationName);
    }

    protected LifecycleResult processJsonErrorSafely(int code, String jsonString, String errorMessage, String operationName) {
        try {
            return this.processJsonError(code, jsonString, errorMessage, operationName);
        }
        catch (JsonParseException e) {
            return new LifecycleResult(code, errorMessage, e.toString());
        }
    }

    private LifecycleResult processJsonError(int code, String jsonString, String errorMessage, String operationName) {
        ExceptionEntity exceptionEntity = (ExceptionEntity)this.getResponseFromJson(jsonString, (Type)((Object)ExceptionEntity.class));
        if (exceptionEntity != null) {
            LOGGER.error((Object)this.getFormatedError(exceptionEntity, operationName));
            return new LifecycleResult(code, exceptionEntity.getDescription());
        }
        return new LifecycleResult(code, errorMessage);
    }

    private LifecycleResult processResponse(int code, String jsonString, String operationName) {
        if (jsonString == null || "".equals(jsonString.trim())) {
            return new LifecycleResult(code, "There is no message in the response returned from server.");
        }
        this.logDebug(LOGGER, "The body returned from the server is in json format: \n%s", jsonString);
        return code == 0 ? this.processJsonResponse(code, jsonString) : this.processJsonError(code, jsonString, operationName);
    }

    public abstract LifecycleResult doUpdate(HttpClient var1) throws Exception;

    protected abstract LifecycleResult processJsonResponse(int var1, String var2);

    protected abstract boolean isStart();
}

