/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl.retry;

import com.sap.core.deploy.client.impl.requests.RestRequest;
import com.sap.core.deploy.client.publicrest.impl.retry.RetryException;
import com.sap.core.deploy.client.publicrest.impl.retry.attempt.FailedAttempt;
import com.sap.core.deploy.client.publicrest.impl.retry.attempt.RequestAttempt;
import com.sap.core.deploy.client.publicrest.impl.retry.attempt.SuccessfulAttempt;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.StopStrategy;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.WaitStrategy;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import java.util.concurrent.ExecutionException;

public final class RetryManager<R> {
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final Class<? extends Throwable> retryExceptionType;

    public RetryManager(StopStrategy stopStrategy, WaitStrategy waitStrategy, Class<? extends Throwable> retryExceptionType) {
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.retryExceptionType = retryExceptionType;
    }

    public R processRequest(RestRequest<R> restRequest) throws RetryException, ExecutionException {
        long startTime = System.currentTimeMillis();
        int attemptNumber = 1;
        while (true) {
            DeployTimeoutUtil.cancelIfDeployTimeoutReached();
            RequestAttempt<R> attempt = this.execute(restRequest);
            if (attempt.isSuccessful()) {
                return attempt.get();
            }
            if (this.attemptFailedWithExpectedException(attempt)) {
                long delaySinceFirstAttemptInMillis = System.currentTimeMillis() - startTime;
                if (this.stopStrategy.mustStop(attemptNumber, delaySinceFirstAttemptInMillis)) {
                    throw new RetryException(attemptNumber, attempt);
                }
                long sleepTime = this.waitStrategy.calculateSleepTime(attemptNumber, System.currentTimeMillis() - startTime);
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RetryException(attemptNumber, attempt, e);
                }
            } else {
                return attempt.get();
            }
            ++attemptNumber;
        }
    }

    private RequestAttempt<R> execute(RestRequest<R> restRequest) {
        RequestAttempt attempt;
        try {
            R responseEntity = restRequest.sendRequest();
            attempt = new SuccessfulAttempt<R>(responseEntity);
        }
        catch (Throwable t) {
            attempt = new FailedAttempt(t);
        }
        return attempt;
    }

    private boolean attemptFailedWithExpectedException(RequestAttempt<R> attempt) {
        return this.retryExceptionType != null && attempt.isFailed() && attempt.getExceptionCause().getClass() == this.retryExceptionType;
    }
}

