/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.publicrest.impl.retry;

import com.sap.core.deploy.client.publicrest.impl.retry.RetryManager;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.StopStrategy;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.StopStrategyFactory;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.WaitStrategy;
import com.sap.core.deploy.client.publicrest.impl.retry.strategy.WaitStrategyFactory;

public final class RetryManagerBuilder<T> {
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private Class<? extends Throwable> expectedExceptionClass;

    private RetryManagerBuilder() {
    }

    public static <V> RetryManagerBuilder<V> newBuilder() {
        return new RetryManagerBuilder();
    }

    public RetryManagerBuilder<T> withWaitStrategy(WaitStrategy waitStrategy) throws IllegalStateException {
        this.waitStrategy = waitStrategy;
        return this;
    }

    public RetryManagerBuilder<T> withStopStrategy(StopStrategy stopStrategy) {
        this.stopStrategy = stopStrategy;
        return this;
    }

    public RetryManagerBuilder<T> retryWhenExpectedException(Class<? extends Throwable> exceptionClass) {
        this.expectedExceptionClass = exceptionClass;
        return this;
    }

    public RetryManager<T> build() {
        WaitStrategy theWaitStrategy = this.waitStrategy == null ? WaitStrategyFactory.getNoWait() : this.waitStrategy;
        StopStrategy theStopStrategy = this.stopStrategy == null ? StopStrategyFactory.getNeverStop() : this.stopStrategy;
        return new RetryManager(theStopStrategy, theWaitStrategy, this.expectedExceptionClass);
    }
}

