/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sap.core.deploy.client.exceptions.DeployClientException;
import com.sap.core.deploy.commons.rest.entity.request.DeltaDescriptor;
import com.sap.core.deploy.commons.util.IOUtils;
import com.sap.core.jpaasrepository.api.Descriptor;
import com.sap.core.utils.infrastructure.validation.LandscapeHostValidator;
import com.sap.core.utils.infrastructure.validation.ValidationStatus;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class DeployClientUtils {
    public static final Logger LOGGER = Logger.getLogger(DeployClientUtils.class);
    public static final String DOMAIN_ALIAS = "domain";
    public static final String SPACES = "spaces";
    public static final String DEPLOY = "deploy";
    public static final String DOMAIN_ALIAS_BASIC = "domain_basic";
    public static final String APPLIANCES = "appliances";
    public static final String COMPONENTS = "components";
    public static final String TENANTS = "tenants";
    public static final String RUNTIME = "runtime";
    public static final String RUNTIME_TYPES = "runtime_types";
    public static final String APPLICATION_ID = "application_id";
    public static final String UPDATE_SITES = "update_sites";
    public static final String IU_NAME = "iu_name";
    public static final String IU_VERSION = "iu_version";
    public static final String JPAAS_SERVICES = "jpaas_services";
    public static final String VM_ARGUMENTS = "vmArguments";
    public static final String JVM_VERSION = "jvmVersion";
    public static final String HOT_UPDATE = "hot-update";
    public static final Map<String, String> ACCEPTED_VM_ARGUMENTS = new HashMap<String, String>();
    public static final String SEPARATOR = ", ";
    public static final String ADDITIONAL = "additional=";
    public static final String RUNTIME_ID_KEY = "runtimeId";
    public static final String RUNTIME_VERSION_KEY = "runtimeVersion";
    public static final String KEY_URL = "url";
    public static final String NETWORK_VISIBILITY = "network.visibility";
    public static final String COMPONENT_WEB = "web";
    public static final String SERVICE_INSTANCES_CFG = "services_instances_cfg";
    public static final String SERVICES_FOLDER = "services";
    public static final String HTTPS_SCHEMA = "https://";
    private static final String HTTP_SCHEMA = "http://";
    private static final String LOCALHOST_BY_IP = "http://127.0.0.1";
    private static final String LOCALHOST_BY_NAME = "http://localhost";
    public static final String DEPLOYMENT_SUBDOMAIN = "https://deployment.";
    public static final String API_SUBDOMAIN = "https://api.";
    private static final String ORCHESTRATOR_SUBDOMAIN = "https://orchestrator.";
    private static final int SOCKET_TIMEOUT;
    public static final String UPLOAD_CONNECTIONS = "connections";
    private static final DeployClientUtils INSTANCE;
    static byte[] buffer;

    static {
        ACCEPTED_VM_ARGUMENTS.put("-Xms", "Xms");
        ACCEPTED_VM_ARGUMENTS.put("-Xmx", "Xmx");
        ACCEPTED_VM_ARGUMENTS.put("-XX:PermSize=", "PermSize");
        ACCEPTED_VM_ARGUMENTS.put("-XX:MaxPermSize=", "MaxPermSize");
        SOCKET_TIMEOUT = Integer.parseInt(System.getProperty("deploy.client.validation.timeout", "60000"));
        INSTANCE = new DeployClientUtils();
        buffer = new byte[1024];
    }

    public static DeployClientUtils getInstance() {
        return INSTANCE;
    }

    protected DeployClientUtils() {
    }

    public static String[] getUpdateSitesValue(Descriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String updateSitesString = descriptor.get(UPDATE_SITES);
        return DeployClientUtils.splitStringWithTrim(updateSitesString, ",");
    }

    public String[] splitStringWithTrimNonStatic(String stringToSplit, String regex) {
        return DeployClientUtils.splitStringWithTrim(stringToSplit, regex);
    }

    public static String[] splitStringWithTrim(String stringToSplit, String regex) {
        if (stringToSplit == null || regex == null) {
            throw new IllegalArgumentException("Provided string to split is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("String given for split: " + stringToSplit));
        }
        String[] result = stringToSplit.split(regex);
        int index = 0;
        while (index < result.length) {
            result[index] = result[index].trim();
            ++index;
        }
        return result;
    }

    public static File detectLocalUpdateSiteIfAvailable(String[] updateSites) {
        if (updateSites == null) {
            throw new IllegalArgumentException("Component descriptor has no property for update sites");
        }
        if (updateSites.length != 1) {
            return null;
        }
        String updateSiteString = updateSites[0];
        if (updateSiteString == null || updateSiteString.equals("EMPTY_SITE")) {
            return null;
        }
        File localUpdateSite = DeployClientUtils.getLocalFile(updateSiteString);
        if (localUpdateSite != null && localUpdateSite.isDirectory()) {
            try {
                if (DeployClientUtils.checkForRepositoryFile(localUpdateSite, "content.xml") && DeployClientUtils.checkForRepositoryFile(localUpdateSite, "artifacts.xml") || DeployClientUtils.checkForRepositoryFile(localUpdateSite, "content.jar") && DeployClientUtils.checkForRepositoryFile(localUpdateSite, "artifacts.jar") || DeployClientUtils.checkForRepositoryFile(localUpdateSite, "compositeContent.xml") && DeployClientUtils.checkForRepositoryFile(localUpdateSite, "compositeArtifacts.xml") || DeployClientUtils.checkForRepositoryFile(localUpdateSite, "compositeContent.jar") && DeployClientUtils.checkForRepositoryFile(localUpdateSite, "compositeArtifacts.jar")) {
                    return localUpdateSite;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForRepositoryFile(File rootDirectory, String repositoryFileName) throws IOException {
        File repositoryFile = new File(rootDirectory, repositoryFileName);
        if (!repositoryFile.exists()) return false;
        String name = repositoryFileName.substring(0, repositoryFileName.lastIndexOf(46));
        String suffix = repositoryFileName.substring(repositoryFileName.lastIndexOf(46) + 1);
        if (!"jar".equalsIgnoreCase(suffix)) return true;
        FileInputStream fileInputStream = null;
        ZipInputStream jis = null;
        try {
            fileInputStream = new FileInputStream(repositoryFile);
            jis = new JarInputStream(fileInputStream);
            JarEntry jarEntry = null;
            jarEntry = ((JarInputStream)jis).getNextJarEntry();
            if (jarEntry != null) {
            }
            return false;
        }
        catch (IOException e) {
            throw new IOException("Unable to read file " + repositoryFile.getAbsolutePath(), e);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (jis != null) {
                jis.close();
            }
        }
    }

    private static File getLocalFile(String updateSiteString) {
        File file = new File(updateSiteString);
        if (file.exists()) {
            return file;
        }
        URI updateSiteURI = null;
        try {
            updateSiteURI = new URI(DeployClientUtils.escapeURIString(updateSiteString));
        }
        catch (MalformedURLException mue) {
            LOGGER.warn((Object)("Malformed URL [" + updateSiteString + "]"), (Throwable)mue);
            return null;
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Object)("URI [" + updateSiteString + "] syntax is wrong"), (Throwable)e);
            return null;
        }
        if ("file".equalsIgnoreCase(updateSiteURI.getScheme())) {
            try {
                file = new File(updateSiteURI);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn((Object)("URI [" + updateSiteString + "] syntax is wrong. Check for remote update sites"), (Throwable)e);
                return null;
            }
            if (file.exists()) {
                return file;
            }
        }
        LOGGER.warn((Object)("File [" + file.getAbsolutePath() + "] does not exists"));
        return null;
    }

    public static String escapeURIString(String s) throws MalformedURLException, URISyntaxException {
        URL u = new URL(s);
        return new URI(u.getProtocol(), u.getAuthority(), u.getPath(), u.getQuery(), u.getRef()).toURL().toString();
    }

    public static boolean detectRemoteUri(String string) {
        try {
            URI destinationUri = new URI(string);
            return "http".equalsIgnoreCase(destinationUri.getScheme()) || "https".equalsIgnoreCase(destinationUri.getScheme());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public File[] detectLocalWarFilesAndBundlesNonStatic(String[] deploymentResources) throws IOException {
        return DeployClientUtils.detectLocalWarFilesAndBundles(deploymentResources);
    }

    public static File[] detectLocalWarFilesAndBundles(String[] deploymentResources) throws IOException {
        return DeployClientUtils.detectLocalWarFilesAndBundles(deploymentResources, null);
    }

    public static File[] detectLocalWarFilesAndBundles(String[] deploymentResources, Map<String, String> ignoredFilesAndReason) throws IOException {
        if (deploymentResources.length == 1 && "EMPTY_SITE".equals(deploymentResources[0])) {
            return new File[0];
        }
        boolean localFileDetected = false;
        boolean remoteURIDetected = false;
        ArrayList<File> result = new ArrayList<File>();
        HashMap<String, File> name2FileMapping = new HashMap<String, File>();
        HashMap<String, File> bundleId2FileMapping = new HashMap<String, File>();
        String[] stringArray = deploymentResources;
        int n = deploymentResources.length;
        int n2 = 0;
        while (n2 < n) {
            String deploymentResource = stringArray[n2];
            File localFile = DeployClientUtils.getLocalFile(deploymentResource = deploymentResource.trim());
            if (localFile != null) {
                if (remoteURIDetected) {
                    throw new IllegalArgumentException("Deployment of a mix of local and remote destinations is not supported");
                }
                localFileDetected = true;
                DeployClientUtils.traverseFile(localFile, result, name2FileMapping, bundleId2FileMapping, new ArrayList<String>(), ignoredFilesAndReason);
            } else if (DeployClientUtils.detectRemoteUri(deploymentResource)) {
                if (localFileDetected) {
                    throw new IllegalArgumentException("Deployment of a mix of local and remote destinations is not supported");
                }
                remoteURIDetected = true;
            } else {
                throw new IllegalArgumentException(String.valueOf(deploymentResource) + " was not found");
            }
            ++n2;
        }
        if (result.isEmpty() && !remoteURIDetected) {
            throw new IllegalArgumentException("The passed source locations for deployment does not contain any valid files or URIs to deploy");
        }
        return result.toArray(new File[result.size()]);
    }

    static void traverseFile(File location, List<File> result, Map<String, File> name2FileMapping, Map<String, File> bundleId2FileMapping, List<String> alreadyTraversed, Map<String, String> ignoredFilesAndReason) throws IOException {
        block21: {
            if (!location.canRead()) {
                String fileType = location.isDirectory() ? "Directory" : "File";
                String message = String.valueOf(fileType) + " " + location.getAbsolutePath() + " cannot be read (permission denied) and will be ignored";
                DeployClientUtils.logIgnoredFile(location.getAbsolutePath(), message, ignoredFilesAndReason);
                return;
            }
            if (location.isDirectory()) {
                if (alreadyTraversed.contains(location.getCanonicalPath())) {
                    LOGGER.warn((Object)("Recursive directory loop detected: " + location.getCanonicalPath()));
                    return;
                }
                alreadyTraversed.add(location.getCanonicalPath());
                File[] filteredFiles = location.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String fileName = file.getName();
                        String suffix = fileName.substring(fileName.lastIndexOf(46) + 1);
                        return "war".equalsIgnoreCase(suffix) || "jar".equalsIgnoreCase(suffix) || "zip".equalsIgnoreCase(suffix);
                    }
                });
                Arrays.sort(filteredFiles, new FileComparator());
                File[] fileArray = filteredFiles;
                int n = filteredFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    DeployClientUtils.traverseFile(file, result, name2FileMapping, bundleId2FileMapping, alreadyTraversed, ignoredFilesAndReason);
                    ++n2;
                }
            } else {
                String fileName = location.getName();
                if (fileName.toLowerCase(Locale.ENGLISH).endsWith(".war") || fileName.toLowerCase(Locale.ENGLISH).endsWith(".zip")) {
                    String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
                    if (!DeployClientUtils.detectDuplicateDeploySource(location, fileName, String.valueOf(fileNameWithoutExtension) + "_0.0.0", name2FileMapping, bundleId2FileMapping, ignoredFilesAndReason)) {
                        result.add(location);
                        name2FileMapping.put(fileName, location);
                        name2FileMapping.put(String.valueOf(fileNameWithoutExtension) + ".jar", location);
                        bundleId2FileMapping.put(String.valueOf(fileNameWithoutExtension) + "_0.0.0", location);
                    }
                } else {
                    if (fileName.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
                        try (ZipInputStream zis = null;){
                            try {
                                zis = new ZipInputStream(new FileInputStream(location));
                                Manifest manifest = DeployClientUtils.getManifest(zis);
                                if (manifest != null) {
                                    String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                                    if (symbolicName != null) {
                                        String bundleId;
                                        String version = manifest.getMainAttributes().getValue("Bundle-Version");
                                        if (version == null) {
                                            version = "0.0.0";
                                        }
                                        if (!DeployClientUtils.detectDuplicateDeploySource(location, fileName, bundleId = String.valueOf(symbolicName) + "_" + version, name2FileMapping, bundleId2FileMapping, ignoredFilesAndReason)) {
                                            result.add(location);
                                            name2FileMapping.put(fileName, location);
                                            bundleId2FileMapping.put(bundleId, location);
                                        }
                                    } else {
                                        String message = "Jar file " + location.getAbsolutePath() + " is not recognized as a bundle and will be ignored for deployment";
                                        DeployClientUtils.logIgnoredFile(location.getAbsolutePath(), message, ignoredFilesAndReason);
                                    }
                                } else {
                                    String message = "No manifest detected in file " + fileName + " and this jar file will be ignored for deployment";
                                    DeployClientUtils.logIgnoredFile(location.getAbsolutePath(), message, ignoredFilesAndReason);
                                }
                                break block21;
                            }
                            catch (IOException e) {
                                throw new IOException("Error opening jar file " + location.getAbsolutePath() + " to verify if it is bundle", e);
                            }
                        }
                    }
                    String message = "File " + location.getAbsolutePath() + " is neither a .war file, nor a bundle, and will be ignored for deployment";
                    DeployClientUtils.logIgnoredFile(location.getAbsolutePath(), message, ignoredFilesAndReason);
                }
            }
        }
    }

    private static void logIgnoredFile(String filePath, String message, Map<String, String> ignoredFilesAndReason) {
        LOGGER.warn((Object)message);
        if (ignoredFilesAndReason != null) {
            ignoredFilesAndReason.put(filePath, message);
        }
    }

    private static boolean detectDuplicateDeploySource(File deploySource, String fileName, String bundleId, Map<String, File> name2FileMapping, Map<String, File> bundleId2FileMapping, Map<String, String> ignoredFilesAndReason) {
        File duplicateFile = name2FileMapping.get(fileName);
        File duplicateBundle = bundleId2FileMapping.get(bundleId);
        if (duplicateFile != null) {
            String message = "File " + deploySource.getAbsolutePath() + " duplicates another deployment resource by name:\n" + duplicateFile.getAbsolutePath() + " and will be ignored for deployment";
            DeployClientUtils.logIgnoredFile(deploySource.getAbsolutePath(), message, ignoredFilesAndReason);
            return true;
        }
        if (duplicateBundle != null) {
            String message = "File " + deploySource.getAbsolutePath() + " duplicates another deployment resource by symbolic name:\n" + duplicateBundle.getAbsolutePath() + " and will be ignored for deployment";
            DeployClientUtils.logIgnoredFile(deploySource.getAbsolutePath(), message, ignoredFilesAndReason);
            return true;
        }
        return false;
    }

    private static Manifest getManifest(ZipInputStream in) throws IOException {
        ZipEntry e;
        Manifest man = new Manifest();
        while ((e = in.getNextEntry()) != null) {
            if (e == null || !e.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            man.read(new BufferedInputStream(in));
            in.closeEntry();
            return man;
        }
        return null;
    }

    public static File detectWarFileIfAvailable(String[] warLocations) {
        if (warLocations == null || warLocations.length == 0) {
            return null;
        }
        File warFile = new File(warLocations[0]);
        if (warFile.isFile() && warFile.getName().endsWith(".war")) {
            return warFile;
        }
        return null;
    }

    public static void zipWithDescriptor(ZipOutputStream zos, File file, Descriptor descriptor, String zipEntryPrefix) throws IOException {
        DeployClientUtils.zipWithDescriptor(zos, new File[]{file}, descriptor, zipEntryPrefix);
    }

    public static void zipWithDescriptor(ZipOutputStream zout, File[] files, Descriptor descriptor, String zipEntryPrefix) throws IOException {
        try {
            DeployClientUtils.addConfigurationFiles(descriptor, zout);
            DeployClientUtils.addDescriptorToZip(zout, descriptor);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    DeployClientUtils.addDirectoryToZip(zout, file, zipEntryPrefix);
                } else {
                    DeployClientUtils.addFileToZip(zout, file, zipEntryPrefix);
                }
                ++n2;
            }
        }
        finally {
            try {
                zout.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void createDeltaZip(ZipOutputStream zos, File[] files, String[] zipEntryPrefixes) throws IOException {
        try {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    DeployClientUtils.addDirectoryToZip(zos, files[i], zipEntryPrefixes[i]);
                } else {
                    DeployClientUtils.addFileToZip(zos, files[i], zipEntryPrefixes[i]);
                }
                ++i;
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)zos);
        }
    }

    public static void createDeltaZip(File file, ZipOutputStream zos, DeltaDescriptor deltaDescriptor) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        HashSet<String> pathsToUpdate = new HashSet<String>();
        for (Object entry : deltaDescriptor.getFilesForUpdate()) {
            pathsToUpdate.add(entry.getPath());
        }
        DeployClientUtils.putZipEntry(zos, new ZipEntry("delta-descriptor.json"), new ByteArrayInputStream(new Gson().toJson((Object)deltaDescriptor).getBytes("UTF-8")));
        try {
            try {
                Object entry;
                entry = zis.getNextEntry();
                while (entry != null) {
                    if (pathsToUpdate.contains(((ZipEntry)entry).getName())) {
                        if (((ZipEntry)entry).isDirectory()) {
                            zos.putNextEntry((ZipEntry)entry);
                            zos.closeEntry();
                        } else {
                            DeployClientUtils.putZipEntry(zos, (ZipEntry)entry, zis);
                        }
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (EOFException eOFException) {
                IOUtils.closeQuietly((Closeable)zos);
                IOUtils.closeQuietly((Closeable)zis);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)zos);
            IOUtils.closeQuietly((Closeable)zis);
        }
    }

    private static void putZipEntry(ZipOutputStream zos, ZipEntry entry, InputStream is) throws IOException, FileNotFoundException {
        int len;
        zos.putNextEntry(new ZipEntry(entry.getName()));
        while ((len = is.read(buffer)) > 0) {
            zos.write(buffer, 0, len);
            zos.flush();
        }
        zos.closeEntry();
    }

    public static void validateServiceInstancesCfg(Descriptor descriptor) throws IOException {
        String serviceInstancesCfgPath = descriptor.get(SERVICE_INSTANCES_CFG);
        if (serviceInstancesCfgPath != null && serviceInstancesCfgPath.length() > 0) {
            File serviceInstancesCfgFile = new File(serviceInstancesCfgPath);
            if (!serviceInstancesCfgFile.exists()) {
                throw new IOException(MessageFormat.format("Specified service instances configuration file [{0}] does not exist and it is not possible to perform deployment", serviceInstancesCfgPath));
            }
            if (!serviceInstancesCfgFile.isFile()) {
                throw new IOException(MessageFormat.format("Specified service instances configuration file [{0}] is not file. Provide a non-directory file to perform deployment", serviceInstancesCfgPath));
            }
            if (!serviceInstancesCfgFile.canRead()) {
                throw new IOException(MessageFormat.format("Specified service instances configuration file [{0}] cannot be read and it is not possible to perform deployment. Check the file permissions for read", serviceInstancesCfgPath));
            }
            if (!serviceInstancesCfgFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
                throw new IOException(MessageFormat.format("Only service instances configuration file with .json extension are accepted for deployment. The specified file is [{0}]", serviceInstancesCfgPath));
            }
            FileInputStream fileInputStream = null;
            InputStreamReader reader = null;
            try {
                fileInputStream = new FileInputStream(serviceInstancesCfgFile);
                reader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                Gson gson = new Gson();
                try {
                    gson.fromJson((Reader)reader, JsonObject.class);
                }
                catch (Exception e) {
                    throw new IOException(MessageFormat.format("Error parsing provided service instances configuration file [{0}]. The file must be in a valid JSON format", serviceInstancesCfgPath), e);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private static void addConfigurationFiles(Descriptor descriptor, ZipOutputStream zout) throws IOException {
        String serviceInstancesCfgPath;
        String configFolder = descriptor.get("configuration_folder");
        if (configFolder != null && configFolder.length() > 0) {
            LOGGER.debug((Object)("Adding configuration folder " + configFolder + " as a directory \"" + "config_master" + "\" into zip stream"));
            descriptor.set("configuration_folder", "config_master");
            DeployClientUtils.addDirectoryToZip(zout, new File(configFolder), "config_master");
        }
        if ((serviceInstancesCfgPath = descriptor.get(SERVICE_INSTANCES_CFG)) != null && serviceInstancesCfgPath.length() > 0) {
            File serviceInstancesCfgFile = new File(serviceInstancesCfgPath);
            DeployClientUtils.addFileToZip(zout, serviceInstancesCfgFile, SERVICES_FOLDER);
            descriptor.set(SERVICE_INSTANCES_CFG, "services/" + serviceInstancesCfgFile.getName());
        }
    }

    private static void addDescriptorToZip(ZipOutputStream zout, Descriptor descriptor) throws IOException {
        byte[] chunk = new byte[4096];
        ByteArrayInputStream bais = null;
        ZipEntry zipEntry = new ZipEntry("descriptor.json");
        zout.putNextEntry(zipEntry);
        try {
            int count;
            bais = new ByteArrayInputStream(descriptor.serializeToJson().getBytes("UTF-8"));
            while ((count = bais.read(chunk, 0, 4096)) != -1) {
                zout.write(chunk, 0, count);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Added file descriptor.json to archive stream");
            }
        }
        finally {
            if (bais != null) {
                bais.close();
            }
        }
    }

    private static void addDirectoryToZip(ZipOutputStream zout, File directoryToZip, String zipEntryPrefix) throws IOException {
        if (!directoryToZip.exists()) {
            throw new FileNotFoundException("Directory [" + directoryToZip + "] doesn`t exist!");
        }
        if (!directoryToZip.isDirectory()) {
            throw new IOException("File [" + directoryToZip + "] doesn`t denote a folder!");
        }
        File[] filesToZip = directoryToZip.listFiles();
        if (filesToZip == null) {
            throw new IOException("Cannot list [" + directoryToZip + "] directory");
        }
        File[] fileArray = filesToZip;
        int n = filesToZip.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                DeployClientUtils.addDirectoryToZip(zout, file, zipEntryPrefix.length() > 0 ? String.valueOf(zipEntryPrefix) + "/" + file.getName() : file.getName());
            } else {
                DeployClientUtils.addFileToZip(zout, file, zipEntryPrefix);
            }
            ++n2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added directory " + directoryToZip.getName() + " to archive stream"));
        }
    }

    private static void addFileToZip(ZipOutputStream zout, File file, String zipEntryPrefix) throws FileNotFoundException, IOException {
        byte[] chunk = new byte[4096];
        FileInputStream fis = null;
        try (BufferedInputStream bis = null;){
            int count;
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis, 4096);
            ZipEntry zipEntry = new ZipEntry(zipEntryPrefix.length() > 0 ? String.valueOf(zipEntryPrefix) + "/" + file.getName() : file.getName());
            zout.putNextEntry(zipEntry);
            while ((count = bis.read(chunk, 0, 4096)) != -1) {
                zout.write(chunk, 0, count);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Added file " + file.getName() + " to archive stream"));
            }
        }
    }

    public static String prepareAndValidateHostString(String host) {
        if (host == null) {
            throw new IllegalArgumentException("Host must not be null");
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        host = host.toLowerCase();
        host = host.replace(DEPLOYMENT_SUBDOMAIN, HTTPS_SCHEMA);
        host = host.replace(ORCHESTRATOR_SUBDOMAIN, HTTPS_SCHEMA);
        DeployClientUtils.checkHostValidity(host, "/");
        return host.replace(HTTPS_SCHEMA, DEPLOYMENT_SUBDOMAIN);
    }

    private static void checkHostValidity(String host, String alias) {
        ValidationStatus status;
        if (host.equals(LOCALHOST_BY_IP) || host.equals(LOCALHOST_BY_NAME)) {
            return;
        }
        if (!alias.startsWith("/")) {
            alias = "/" + alias;
        }
        if ((status = LandscapeHostValidator.isLandscapeHostValid((String)host, (String)alias, (int)SOCKET_TIMEOUT, (boolean)false)).isError()) {
            LOGGER.error((Object)("Host [" + host + "] and alias [" + alias + "] cannot be reached. Original error message is: " + status.getMessage()), (Throwable)status.getException());
            throw new DeployClientException("Cannot reach host [" + host + "]. Check host name for typing errors and make sure your proxy and network settings are correct", status.getException());
        }
    }

    public static String getFullApplicationName(String accountName, String applicationName, String componentName) {
        String baseApplicationName = String.valueOf(accountName) + "/" + applicationName;
        if (componentName == null || componentName.length() == 0 || COMPONENT_WEB.equalsIgnoreCase(componentName)) {
            return baseApplicationName;
        }
        return String.valueOf(baseApplicationName) + "/" + componentName;
    }

    public static boolean isDefaultComponent(String component) {
        return COMPONENT_WEB.equalsIgnoreCase(component);
    }

    static class FileComparator
    implements Comparator<File> {
        FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            try {
                String o1FilePath = o1.getCanonicalPath();
                String o2FilePath = o2.getCanonicalPath();
                return o1FilePath.compareTo(o2FilePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Error obtaining canonical path for deployment resources", e);
            }
        }
    }
}

