/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.utils;

import com.sap.core.deploy.client.DeployResult;
import com.sap.core.deploy.client.connection.utils.Multiplexer;
import com.sap.core.deploy.client.utils.DeployTimeoutUtil;
import com.sap.core.deploy.client.utils.NetworkUtils;
import com.sap.core.deploy.client.utils.ResultBuilder;
import com.sap.core.deploy.commons.log.StringFormatLoggerWrapper;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class DeployResultPollingUtil {
    private static final StringFormatLoggerWrapper LOGGER = StringFormatLoggerWrapper.getLogger(DeployResultPollingUtil.class);
    private static final int CONNECTIONS_COUNT_INCREMENT = 5;
    static final String DEPLOY_OPERATION_TIMED_OUT_MSG = "Deploy operation timed out";
    static final String UPLOAD_OF_DEPLOYMENT_CONTENT_FAILED_MSG = "Upload of deployment content failed";
    private HttpClient httpClient;
    private Multiplexer multiplexer;
    private byte parallelConnectionsCount;
    private String statusPollUrl;
    private String restRequest;
    NetworkUtils networkUtils;

    public DeployResultPollingUtil(HttpClient httpClient, Multiplexer multiplexer, byte parallelConnectionsCount, String statusPollUrl, String restRequest) {
        this.httpClient = httpClient;
        this.multiplexer = multiplexer;
        this.parallelConnectionsCount = parallelConnectionsCount;
        this.statusPollUrl = statusPollUrl;
        this.restRequest = restRequest;
        this.networkUtils = new NetworkUtils();
    }

    public DeployResult getAsyncDeployResult() throws IOException {
        if (this.multiplexer != null) {
            return this.getAsyncResultFromDeployWithMultipleConnections();
        }
        return this.getAsyncResultFromDeployWithSingleConnection();
    }

    private DeployResult getAsyncResultFromDeployWithMultipleConnections() throws IOException {
        HttpGet statusRequest = new HttpGet(this.statusPollUrl);
        long pollStartTime = System.currentTimeMillis();
        this.logStartOfPolling();
        while (this.timeoutNotReached(pollStartTime, 18000000L)) {
            DeployTimeoutUtil.cancelIfDeployTimeoutReached();
            if (this.multiplexer.failed()) {
                LOGGER.debug("Multiplexer failed to upload the content", new Object[0]);
                return new DeployResult(1, UPLOAD_OF_DEPLOYMENT_CONTENT_FAILED_MSG, null);
            }
            this.logTriggerOfPollingRequest(statusRequest);
            HttpResponse statusResponse = this.networkUtils.executeRequestAndFollowRedirectNonStatic(this.httpClient, (HttpRequestBase)statusRequest, "2.2", this.parallelConnectionsCount + 5, this.parallelConnectionsCount + 5);
            DeployResult pollResult = ResultBuilder.buildDeployPollResult(statusResponse, this.restRequest);
            this.logResultFromPollingRequest(pollResult);
            if (pollResult == null) continue;
            if (pollResult.getCode() != 0) {
                this.multiplexer.notifyFailure();
            }
            return pollResult;
        }
        return this.deployTimeoutResult();
    }

    private DeployResult getAsyncResultFromDeployWithSingleConnection() throws IOException {
        HttpGet statusRequest = new HttpGet(this.statusPollUrl);
        long pollStartTime = System.currentTimeMillis();
        this.logStartOfPolling();
        while (this.timeoutNotReached(pollStartTime, 1800000L)) {
            DeployTimeoutUtil.cancelIfDeployTimeoutReached();
            this.logTriggerOfPollingRequest(statusRequest);
            HttpResponse statusResponse = this.networkUtils.executeRequestAndFollowRedirectNonStatic(this.httpClient, (HttpRequestBase)statusRequest, "2.2", 5, 5);
            DeployResult pollResult = ResultBuilder.buildDeployPollResult(statusResponse, this.restRequest);
            this.logResultFromPollingRequest(pollResult);
            if (pollResult == null) continue;
            return pollResult;
        }
        return this.deployTimeoutResult();
    }

    protected boolean timeoutNotReached(long startTime, long timeout) {
        return System.currentTimeMillis() - startTime < timeout;
    }

    private void logStartOfPolling() {
        LOGGER.debug("Initiating periodic status poll to: %s", new Object[]{this.statusPollUrl});
    }

    private void logTriggerOfPollingRequest(HttpGet statusRequest) {
        LOGGER.debug("Starting status request for [%s]", new Object[]{statusRequest.getURI()});
    }

    private void logResultFromPollingRequest(DeployResult pollResult) {
        LOGGER.debug("Status request for [%s] finished with status [%s]", new Object[]{this.restRequest, pollResult});
    }

    private DeployResult deployTimeoutResult() {
        return new DeployResult(1, DEPLOY_OPERATION_TIMED_OUT_MSG, null);
    }
}

